/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitorBasedInspection;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionToolWrapperWithHint;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCInspection
extends OCInspectionBase
implements InspectionToolWrapperWithHint {
    public static final Key<ProblemDescriptionsProcessor> TEST_PROBLEMS_PROCESSOR_KEY = Key.create((String)"TEST_PROBLEMS_PROCESSOR_KEY");

    protected Class<? extends OCInspection> getInspectionClass() {
        return ((Object)((Object)this)).getClass();
    }

    protected void registerProblems(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, List<? extends PsiElement> elements, @InspectionMessage String message, @Nullable String clangID, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
        for (PsiElement psiElement : elements) {
            if (psiElement.getTextLength() <= 0) continue;
            this.registerProblem(holder, processor, globalContext, isOnTheFly, psiElement, message, clangID, highlightType, quickFixes);
        }
    }

    protected void registerProblem(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, @Nullable PsiElement element, @InspectionMessage String message, @Nullable String clangID, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
        OCInspection.registerProblem(holder, processor, globalContext, isOnTheFly, element, message, clangID, highlightType, this.getInspectionClass(), quickFixes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerProblem(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, @Nullable PsiElement element, @InspectionMessage String message, @Nullable String clangID, ProblemHighlightType highlightType, Class<? extends OCInspection> inspection, IntentionAction ... quickFixes) {
        OCMacroRange range;
        if (element == null) {
            return;
        }
        if (element.getTextLength() == 0) {
            range = OCElementUtil.getRangeInMacroCall(element);
            if (range == null) return;
            OCMacroCall macroCall = range.getMacroCall();
            if (macroCall != element.getPrevSibling()) return;
            element = macroCall;
        }
        range = OCElementUtil.getRangeWithMacros(element);
        OCInspection.registerProblem(holder, processor, globalContext, isOnTheFly, element, null, message, clangID, highlightType, (TextRange)range, inspection, quickFixes);
    }

    public static void registerProblem(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, @Nullable OCElementsRange elementsRange, @InspectionMessage String message, @Nullable String clangID, ProblemHighlightType highlightType, Class<? extends OCInspection> inspection, IntentionAction ... quickFixes) {
        if (elementsRange == null) {
            return;
        }
        TextRange textRange = elementsRange.getTextRange();
        if (textRange.isEmpty()) {
            return;
        }
        OCInspection.registerProblem(holder, processor, globalContext, isOnTheFly, elementsRange.getFirstElement(), elementsRange.getLastElement(), message, clangID, highlightType, textRange, inspection, quickFixes);
    }

    public static void registerProblem(ProblemsHolder holder, ProblemDescriptionsProcessor processor, GlobalInspectionContext globalContext, boolean isOnTheFly, PsiElement startElement, @Nullable PsiElement endElement, @InspectionMessage String message, String clangID, ProblemHighlightType highlightType, TextRange range, Class<? extends OCInspection> inspection, IntentionAction[] quickFixes) {
        while (startElement instanceof OCMacroForeignLeafElement) {
            startElement = startElement.getParent();
        }
        while (endElement instanceof OCMacroForeignLeafElement) {
            endElement = endElement.getParent();
        }
        if (endElement != null && startElement.getTextOffset() >= endElement.getTextRange().getEndOffset()) {
            return;
        }
        HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(inspection, (PsiElement)startElement, (HighlightSeverity)HighlightSeverity.WARNING);
        if (highlightSeverity == null) {
            return;
        }
        highlightType = OCAnnotator.getProblemHighlightType(highlightSeverity, highlightType != null ? highlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        OCFile file = (OCFile)startElement.getContainingFile();
        List wrappers = ContainerUtil.mapNotNull((Object[])quickFixes, action -> action instanceof SuppressIntentionAction ? null : new IntentionWrapper(action, (PsiFile)file));
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file, range, clangID, inspection);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragma.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return;
                }
                case ERROR: 
                case FATAL: {
                    highlightType = ProblemHighlightType.GENERIC_ERROR;
                    break;
                }
            }
        }
        InspectionManager manager = InspectionManager.getInstance((Project)startElement.getProject());
        ProblemDescriptor problem = endElement == null ? manager.createProblemDescriptor(startElement, message, (LocalQuickFix[])wrappers.toArray(new IntentionWrapper[0]), highlightType, isOnTheFly, false) : manager.createProblemDescriptor(startElement, endElement, message, highlightType, isOnTheFly, (LocalQuickFix[])wrappers.toArray(new IntentionWrapper[0]));
        if (problemGroup != null) {
            problem.setProblemGroup((ProblemGroup)problemGroup);
            for (IntentionAction fix : quickFixes) {
                if (!(fix instanceof SuppressIntentionAction)) continue;
                problemGroup.addSuppressAction((SuppressIntentionAction)fix);
            }
        }
        if (processor == null) {
            ProblemDescriptionsProcessor problemDescriptionsProcessor = processor = file != null ? (ProblemDescriptionsProcessor)file.getProject().getUserData(TEST_PROBLEMS_PROCESSOR_KEY) : null;
        }
        if (processor != null) {
            processor.addProblemElement((RefEntity)(globalContext != null ? GlobalInspectionContextUtil.retrieveRefElement((PsiElement)startElement, (GlobalInspectionContext)globalContext) : null), new CommonProblemDescriptor[]{problem});
        }
        if (holder != null) {
            holder.registerProblem(problem);
        }
    }

    public String getMainToolId() {
        if (OCInspections.class.equals(((Object)((Object)this)).getClass().getDeclaringClass())) {
            return new DefaultHighlightVisitorBasedInspection.AnnotatorBasedInspection().getShortName();
        }
        return null;
    }

    public JComponent createOptionsPanel() {
        if (!this.showAdjustableHint()) {
            return super.createOptionsPanel();
        }
        GridBag bag = new GridBag().setDefaultAnchor(18).setDefaultFill(2).setDefaultWeightX(1.0).setDefaultWeightY(0.0);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)new JBLabel(OCInspectionsBundle.message("inspection.works.only.when.clangd.disabled.hint", new Object[0])), bag.nextLine().nextLine().insets((Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0)));
        panel2.add((Component)new JBLabel(OCBundle.message("label.or.in.objective.c.code", new Object[0])), bag.nextLine().nextLine().insets((Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0)));
        return panel2;
    }

    public static abstract class Cpp
    extends OCInspection
    implements OCInspectionBase.CppMarker {
        public String @NotNull [] getGroupPath() {
            String[] stringArray = new String[]{CidrLangBundle.message((String)"c.cpp", (Object[])new Object[0]), this.getGroupDisplayName()};
            if (stringArray == null) {
                Cpp.$$$reportNull$$$0(0);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCInspection$Cpp", "getGroupPath"));
        }
    }

    public static abstract class ObjC
    extends OCInspection
    implements OCInspectionBase.ObjCMarker {
        public String @NotNull [] getGroupPath() {
            String[] stringArray = new String[]{CidrLangBundle.message((String)"objective.c", (Object[])new Object[0]), this.getGroupDisplayName()};
            if (stringArray == null) {
                ObjC.$$$reportNull$$$0(0);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCInspection$ObjC", "getGroupPath"));
        }
    }
}

