/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.interactive.cling;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.interactive.cling.OCClingSettings;
import com.jetbrains.cidr.lang.interactive.repl.hosting.OCAbstractReplConsoleRunner;
import com.jetbrains.cidr.lang.interactive.repl.hosting.OCAbstractReplHost;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCParsedLanguageAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.ClangSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSpecificSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import icons.CidrLangIcons;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0014J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\fH\u0016J\u001a\u0010\"\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010#\u001a\u00020\u0005H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/cidr/lang/interactive/cling/OCClingInteractiveConsoleRunner;", "Lcom/jetbrains/cidr/lang/interactive/repl/hosting/OCAbstractReplConsoleRunner;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "replHost", "Lcom/jetbrains/cidr/lang/interactive/repl/hosting/OCAbstractReplHost;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/jetbrains/cidr/lang/interactive/repl/hosting/OCAbstractReplHost;)V", "myClingProcess", "Lcom/jetbrains/cidr/lang/interactive/cling/OCClingInteractiveConsoleRunner$OCClingInteractiveProcess;", "addCtrlCKeyListener", "", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleView;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "createConsoleView", "createProcess", "Ljava/lang/Process;", "fillToolBarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "toolbarActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "defaultExecutor", "Lcom/intellij/execution/Executor;", "contentDescriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "getCompilerInfo", "Lcom/jetbrains/cidr/lang/workspace/OCCompilerSettings;", "currentFile", "Lcom/intellij/psi/PsiFile;", "initAndRun", "showNotification", "message", "OCClingInteractiveProcess", "intellij.c"})
public final class OCClingInteractiveConsoleRunner
extends OCAbstractReplConsoleRunner {
    private OCClingInteractiveProcess myClingProcess;

    @Override
    @NotNull
    protected LanguageConsoleView createConsoleView() {
        LanguageConsoleView createdConsoleView = super.createConsoleView();
        this.addCtrlCKeyListener(createdConsoleView);
        return createdConsoleView;
    }

    private final void addCtrlCKeyListener(LanguageConsoleView consoleView) {
        EditorEx editorEx = consoleView.getConsoleEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"consoleView.consoleEditor");
        editorEx.getContentComponent().addKeyListener(new KeyAdapter(this, consoleView){
            final /* synthetic */ OCClingInteractiveConsoleRunner this$0;
            final /* synthetic */ LanguageConsoleView $consoleView;

            public void keyReleased(@NotNull KeyEvent e) {
                block1: {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!e.isControlDown() || e.getKeyCode() != 67) break block1;
                    EditorEx editorEx = this.$consoleView.getConsoleEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"consoleView.consoleEditor");
                    SelectionModel selectionModel = editorEx.getSelectionModel();
                    Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"consoleView.consoleEditor.selectionModel");
                    CharSequence charSequence = selectionModel.getSelectedText();
                    boolean bl = false;
                    boolean bl2 = false;
                    if ((charSequence == null || charSequence.length() == 0) && (object = OCClingInteractiveConsoleRunner.access$getMyClingProcess$p(this.this$0)) != null && (object = ((OCClingInteractiveProcess)object).getProcess()) != null) {
                        ((Process)object).destroy();
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$consoleView = $captured_local_variable$1;
            }
        });
    }

    public void initAndRun() {
        try {
            super.initAndRun();
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)e;
        }
        catch (ProcessNotCreatedException e) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            String string = e.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.localizedMessage");
            this.showNotification(project, string);
        }
    }

    private final void showNotification(Project project, @Nls String message) {
        NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup("Cling Interactive");
        group.createNotification(message, NotificationType.ERROR).notify(project);
    }

    private final OCCompilerSettings getCompilerInfo(PsiFile currentFile) {
        PsiFile psiFile = currentFile;
        if (!(psiFile instanceof OCConfigurationOwner)) {
            psiFile = null;
        }
        OCConfigurationOwner oCConfigurationOwner = (OCConfigurationOwner)psiFile;
        if (oCConfigurationOwner == null) {
            return null;
        }
        OCConfigurationOwner configurationOwner = oCConfigurationOwner;
        OCParsedLanguageAndConfiguration oCParsedLanguageAndConfiguration = configurationOwner.getParsedLanguageAndConfiguration();
        if (oCParsedLanguageAndConfiguration == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)oCParsedLanguageAndConfiguration, (String)"configurationOwner.parse\u2026figuration ?: return null");
        OCParsedLanguageAndConfiguration langAndConfig = oCParsedLanguageAndConfiguration;
        OCLanguageKind oCLanguageKind = langAndConfig.getLanguageKind();
        Intrinsics.checkNotNullExpressionValue((Object)oCLanguageKind, (String)"langAndConfig.languageKind");
        OCLanguageKind languageKind = oCLanguageKind;
        OCResolveConfiguration oCResolveConfiguration = langAndConfig.getConfiguration();
        return oCResolveConfiguration != null ? oCResolveConfiguration.getCompilerSettings(languageKind, ((OCConfigurationOwner)currentFile).getVirtualFile()) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public GeneralCommandLine createCommandLine() {
        VirtualFile currentFile;
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        Charset charset = SystemInfo.isWindows ? StandardCharsets.UTF_8 : CharsetToolkit.getDefaultSystemCharset();
        String string = OCClingSettings.Companion.getInstance().getClingPath();
        Intrinsics.checkNotNull((Object)string);
        String clingPath = string;
        VirtualFile virtualFile3 = this.getCurrentFile();
        if (virtualFile3 != null) {
            VirtualFile virtualFile4 = virtualFile3;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile4;
            boolean bl3 = false;
            virtualFile2 = PsiManager.getInstance((Project)this.getProject()).findFile(it);
        } else {
            virtualFile2 = null;
        }
        if ((virtualFile = (currentFile = virtualFile2)) == null || (virtualFile = virtualFile.getVirtualFile()) == null || (virtualFile = virtualFile.getParent()) == null) {
            virtualFile = this.getFallbackDir();
        }
        String workingDir = virtualFile != null ? virtualFile.getPath() : null;
        GeneralCommandLine generalCommandLine = new PtyCommandLine().withExePath(clingPath).withWorkDirectory(workingDir).withCharset(charset);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"PtyCommandLine()\n      .\u2026    .withCharset(charset)");
        GeneralCommandLine cmdLine = generalCommandLine;
        if (currentFile instanceof OCFile) {
            OCLanguageStandard oCLanguageStandard = OCCompilerFeaturesHelper.getLanguageStandard(null, (PsiFile)currentFile);
            Intrinsics.checkNotNullExpressionValue((Object)oCLanguageStandard, (String)"OCCompilerFeaturesHelper\u2026andard(null, currentFile)");
            OCLanguageStandard languageStandard = oCLanguageStandard;
            CompilerSpecificSwitchBuilder switchBuilder = new ClangSwitchBuilder(null, 1, null).withLanguageStandard(languageStandard);
            OCCompilerSettings compInfo = this.getCompilerInfo((PsiFile)currentFile);
            Object object = compInfo;
            if (object != null && (object = object.getHeadersSearchPaths()) != null) {
                void $this$forEach$iv;
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv = (Iterable)object;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    HeadersSearchPath it = (HeadersSearchPath)element$iv$iv;
                    boolean bl = false;
                    HeadersSearchPath headersSearchPath = it;
                    Intrinsics.checkNotNullExpressionValue((Object)headersSearchPath, (String)"it");
                    if (headersSearchPath.isBuiltInHeaders()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    HeadersSearchPath it = (HeadersSearchPath)element$iv;
                    boolean bl = false;
                    HeadersSearchPath headersSearchPath = it;
                    Intrinsics.checkNotNullExpressionValue((Object)headersSearchPath, (String)"it");
                    String string2 = headersSearchPath.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.path");
                    switchBuilder = switchBuilder.withIncludePath(string2);
                }
            }
            List switches = switchBuilder.buildRaw();
            GeneralCommandLine generalCommandLine2 = cmdLine.withParameters(switches);
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"cmdLine.withParameters(switches)");
            cmdLine = generalCommandLine2;
        }
        return cmdLine;
    }

    @Override
    @NotNull
    protected List<AnAction> fillToolBarActions(@NotNull DefaultActionGroup toolbarActions, @NotNull Executor defaultExecutor, @NotNull RunContentDescriptor contentDescriptor) {
        Intrinsics.checkNotNullParameter((Object)toolbarActions, (String)"toolbarActions");
        Intrinsics.checkNotNullParameter((Object)defaultExecutor, (String)"defaultExecutor");
        Intrinsics.checkNotNullParameter((Object)contentDescriptor, (String)"contentDescriptor");
        this.setContentDescriptor(contentDescriptor);
        List<AnAction> parentActionList = super.fillToolBarActions(toolbarActions, defaultExecutor, contentDescriptor);
        return CollectionsKt.toMutableList((Collection)parentActionList);
    }

    @Override
    @Nullable
    protected Process createProcess() {
        Process process2 = super.createProcess();
        if (process2 != null) {
            this.myClingProcess = new OCClingInteractiveProcess(process2);
        }
        return process2;
    }

    public OCClingInteractiveConsoleRunner(@NotNull Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, @NotNull OCAbstractReplHost replHost) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)replHost, (String)"replHost");
        Icon icon = CidrLangIcons.FileTypes.Cpp;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"CidrLangIcons.FileTypes.Cpp");
        PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage, (String)"PlainTextLanguage.INSTANCE");
        super(project, title, icon, (Language)plainTextLanguage, ".cpp", replHost);
    }

    public static final /* synthetic */ OCClingInteractiveProcess access$getMyClingProcess$p(OCClingInteractiveConsoleRunner $this) {
        return $this.myClingProcess;
    }

    public static final /* synthetic */ void access$setMyClingProcess$p(OCClingInteractiveConsoleRunner $this, OCClingInteractiveProcess oCClingInteractiveProcess) {
        $this.myClingProcess = oCClingInteractiveProcess;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/interactive/cling/OCClingInteractiveConsoleRunner$OCClingInteractiveProcess;", "", "process", "Ljava/lang/Process;", "(Ljava/lang/Process;)V", "getProcess", "()Ljava/lang/Process;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.c"})
    private static final class OCClingInteractiveProcess {
        @NotNull
        private final Process process;

        @NotNull
        public final Process getProcess() {
            return this.process;
        }

        public OCClingInteractiveProcess(@NotNull Process process2) {
            Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
            this.process = process2;
        }

        @NotNull
        public final Process component1() {
            return this.process;
        }

        @NotNull
        public final OCClingInteractiveProcess copy(@NotNull Process process2) {
            Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
            return new OCClingInteractiveProcess(process2);
        }

        public static /* synthetic */ OCClingInteractiveProcess copy$default(OCClingInteractiveProcess oCClingInteractiveProcess, Process process2, int n, Object object) {
            if ((n & 1) != 0) {
                process2 = oCClingInteractiveProcess.process;
            }
            return oCClingInteractiveProcess.copy(process2);
        }

        @NotNull
        public String toString() {
            return "OCClingInteractiveProcess(process=" + this.process + ")";
        }

        public int hashCode() {
            Process process2 = this.process;
            return process2 != null ? process2.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof OCClingInteractiveProcess)) break block3;
                    OCClingInteractiveProcess oCClingInteractiveProcess = (OCClingInteractiveProcess)object;
                    if (!Intrinsics.areEqual((Object)this.process, (Object)oCClingInteractiveProcess.process)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

