/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.daemon.OCAssignmentChecker;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResultBuilder;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.quickfixes.OCChangeFunctionSignatureIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCFunctionArgumentsProcessor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCArgumentsChecker {
    public static List<OCTypeCheckResult> checkFunctionArguments(OCElement element, OCFunctionType funcType, @NotNull List<OCExpression> arguments, OCSymbol functionSymbol, @NotNull OCResolveContext context, boolean isRecoveringFromOverloadFailure) {
        OCFunctionSymbol symbol;
        List<OCDeclaratorSymbol> parameterSymbols;
        int requiredArgumentsCnt;
        if (arguments == null) {
            OCArgumentsChecker.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCArgumentsChecker.$$$reportNull$$$0(1);
        }
        List<OCType> paramTypes = funcType.getParameterTypes();
        int n = requiredArgumentsCnt = functionSymbol instanceof OCFunctionSymbol ? ((OCFunctionSymbol)functionSymbol).getNonInitializedParametersCount(context) : OCTypeUtils.getNonVariadicParametersCount(paramTypes);
        if (functionSymbol instanceof OCDeclaratorSymbol && functionSymbol.getType() instanceof OCAutoType) {
            functionSymbol = ((OCAutoType)functionSymbol.getType()).getExpressionSymbol();
        }
        if (functionSymbol instanceof OCLambdaExpressionSymbol) {
            requiredArgumentsCnt = ((OCLambdaExpressionSymbol)functionSymbol).getNonInitializedParametersCount(context);
        }
        OCArgumentsList<OCExpression> argumentsList = OCArgumentsList.getArgumentList(arguments);
        int maxArgumentsCnt = OCTypeUtils.getNonVariadicParametersCount(paramTypes);
        boolean variableArgs = funcType.isVararg();
        OCTypeCheckResult countMismatchResult = null;
        if (argumentsList.getCount() < requiredArgumentsCnt && !argumentsList.hasNonExpandedVariadics()) {
            countMismatchResult = OCTypeCheckResultBuilder.createError(element, OCInspections.FunctionParameterCountMismatch.class, "err_typecheck_call_too_few_args", "Too few arguments, expected " + (variableArgs ? "at least " : "") + requiredArgumentsCnt, new IntentionAction[0]);
        } else if (!variableArgs && argumentsList.getCount() > maxArgumentsCnt) {
            countMismatchResult = OCCodeInsightUtil.isInPlainOldC(element) && funcType.getParameterTypes(true).isEmpty() ? OCTypeCheckResultBuilder.createWarning(element, OCInspections.KRUnspecifiedParameters.class, "CIDR", "Too many arguments, expected " + requiredArgumentsCnt, null, IntentionAction.EMPTY_ARRAY) : OCTypeCheckResultBuilder.createError(element, OCInspections.FunctionParameterCountMismatch.class, "err_typecheck_call_too_many_args", "Too many arguments, expected " + requiredArgumentsCnt, new IntentionAction[0]);
        }
        if (countMismatchResult != null) {
            List argumentTypes = ContainerUtil.map(arguments, expression -> OCExpectedTypeUtil.getExpressionType(expression, true));
            OCFunctionType newFunctionType = new OCFunctionType(funcType.getReturnType(), argumentTypes);
            if (functionSymbol instanceof OCFunctionSymbol) {
                countMismatchResult.addQuickFix(new OCChangeFunctionSignatureIntentionAction((OCFunctionSymbol)functionSymbol, newFunctionType, arguments, context, element));
            }
            if (element.getContainingOCFile().isCpp() && functionSymbol instanceof OCFunctionSymbol) {
                OCSymbolWithQualifiedName parent = ((OCFunctionSymbol)functionSymbol).getResolvedOwner(context);
                boolean isStatic = ((OCFunctionSymbol)functionSymbol).resolveIsFriendOrStatic(context);
                OCElement usage = element instanceof OCCallExpression ? ((OCCallExpression)element).getFunctionReferenceExpression() : element;
                countMismatchResult.addQuickFix(new OCCreateNewDefinitionIntentionAction(functionSymbol.getKind().toDeclarationKind(), usage, null, parent, functionSymbol.getName(), newFunctionType, isStatic));
            }
            return Collections.singletonList(countMismatchResult);
        }
        List<OCDeclaratorSymbol> paramSymbols = null;
        if (functionSymbol instanceof OCFunctionSymbol && (parameterSymbols = (symbol = (OCFunctionSymbol)functionSymbol).getParameterSymbols(context)).size() == argumentsList.getCount()) {
            paramSymbols = parameterSymbols;
        }
        ArrayList<OCTypeCheckResult> argResults = new ArrayList<OCTypeCheckResult>(paramSymbols != null ? paramSymbols.size() : 1);
        OCFunctionArgumentsProcessor.processArguments(paramTypes, paramSymbols, argumentsList, context, (parameterType, parameterSymbol, argumentType, argumentExpr, isVariadic) -> {
            if (argumentExpr == null) {
                return true;
            }
            if (parameterType instanceof OCEllipsisType || argumentType instanceof OCEllipsisType) {
                if (argumentType.isVoid()) {
                    argResults.add(OCTypeCheckResultBuilder.createError(argumentExpr, null, "err_call_incomplete_argument", "Invalid use of void expression", new IntentionAction[0]));
                    return false;
                }
                return false;
            }
            if (isRecoveringFromOverloadFailure && parameterType instanceof OCTypeParameterType && argumentType instanceof OCBracedInitListType) {
                argResults.add(OCTypeCheckResultBuilder.createError(argumentExpr, null, "CIDR", "Can't deduce template parameter", new IntentionAction[0]));
                return false;
            }
            if (parameterType instanceof OCFunctionType && argumentType instanceof OCPointerType && argumentType.getTerminalType() instanceof OCFunctionType) {
                argumentType = ((OCPointerType)argumentType).getRefType();
            }
            if (OCTypeUtils.isUnresolvedLambdaAutoType(argumentType)) {
                argumentType = OCTypeUtils.resolveLambdaAutoType(parameterType, argumentType, context);
            }
            OCType requiredType = argumentType.accept(OCArrayToPointerChanger.INSTANCE).cloneWithAliasName(argumentType.getAliasName());
            argResults.add(OCAssignmentChecker.checkAssignment(argumentExpr, parameterType, argumentType, parameterSymbol, requiredType, true, "Parameter type mismatch: ", context));
            return true;
        });
        return argResults;
    }

    public static OCTypeCheckResult combine(List<OCTypeCheckResult> results) {
        if (results.size() == 1) {
            return results.get(0);
        }
        OCTypeCheckState worst = results.stream().map(result -> result.getState()).max(Comparator.comparingInt(Enum::ordinal)).orElse(OCTypeCheckState.OK);
        OCTypeCheckResult result2 = new OCTypeCheckResult(worst);
        result2.addAdditionalProblems(results);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "arguments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/legacy/daemon/OCArgumentsChecker";
        objectArray[2] = "checkFunctionArguments";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

