/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.OCRealModuleMapConfigurations;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMap;
import com.jetbrains.cidr.lang.workspace.OCModuleMapConfigurations;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/OCRealModuleMapConfigurations;", "Lcom/jetbrains/cidr/lang/workspace/OCModuleMapConfigurations;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getPublicHeadersToInclude", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "framework", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework;", "isFrameworkSearchRoot", "", "root", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "providePublicHeadersForRoot", "", "processor", "Ljava/util/function/Consumer;", "intellij.c"})
public final class OCRealModuleMapConfigurations
extends OCModuleMapConfigurations {
    @NotNull
    private final Project myProject;

    public boolean isFrameworkSearchRoot(@NotNull HeadersSearchRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return root instanceof FrameworksSearchRoot;
    }

    public void providePublicHeadersForRoot(@NotNull HeadersSearchRoot root, @NotNull Consumer<? super VirtualFile> processor) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        ModuleMap moduleMap = ModuleMapManager.Companion.getInstance(this.myProject).getGlobalCache().getModuleMap(root);
        if (moduleMap == null) {
            return;
        }
        ModuleMap moduleMap2 = moduleMap;
        StreamsKt.asStream(ModuleMapUtil.allModules(moduleMap2)).filter(providePublicHeadersForRoot.1.INSTANCE).flatMap(providePublicHeadersForRoot.2.INSTANCE).forEach(processor);
    }

    @NotNull
    public List<VirtualFile> getPublicHeadersToInclude(@NotNull AppleFramework framework) {
        Intrinsics.checkNotNullParameter((Object)framework, (String)"framework");
        return ModuleMapUtil.getPublicHeadersToInclude(framework);
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    public OCRealModuleMapConfigurations(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }
}

