/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.serialization;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPlatformType;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.serialization.DependencyInitializationSession;
import com.jetbrains.cidr.lang.modulemap.serialization.DeserializationSession;
import com.jetbrains.cidr.lang.modulemap.serialization.DeserializationSessionImpl;
import com.jetbrains.cidr.lang.modulemap.serialization.HeadersSearchRootId;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapAssembledPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapLowLevelSerializationService;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapPrebuiltSerializationPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationService;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationServiceImpl;
import com.jetbrains.cidr.lang.modulemap.serialization.PackAssembler;
import com.jetbrains.cidr.lang.modulemap.serialization.SerializationSessionImpl;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPack;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPackWithRoot;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.FileSymbolTableSerializationVersion;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationAttributeService;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.headerRoots.ExplicitFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderMapRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0016\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00029:B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J&\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0002J4\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00180\u001eH\u0016J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0016J&\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0002J\b\u0010!\u001a\u00020\u0018H\u0016J.\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010#\u001a\u00020\u00182\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010&2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0016H\u0002J\u0010\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u000f\u001a\u00020\nJ\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u00104\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u00104\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\f\u00105\u001a\b\u0012\u0004\u0012\u00020*0\u0011H\u0016J\u0012\u00106\u001a\u000207*\b\u0012\u0004\u0012\u00020\u001208H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006;"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationServiceImpl;", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "storage", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationServiceImpl$Storage;", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "getStorage", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;)Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationServiceImpl$Storage;", "calculateContentHashCode", "", "root", "deserializeAllModuleMaps", "", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapPackWithRoot;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "roots", "", "deserializeModuleMaps", "", "deserializationSession", "Lcom/jetbrains/cidr/lang/modulemap/serialization/DeserializationSession;", "prebuiltOnly", "", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapAssembledPack;", "deserializePrebuiltModuleMapsOnly", "dispose", "doDeserializePacks", "flushValidPacksToModuleMapCache", "validPacks", "getInputStream", "Ljava/io/InputStream;", "getOutputStream", "Ljava/io/OutputStream;", "pack", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationPack;", "getPrebuiltCacheInputStream", "getProjectPlatforms", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapPlatformType;", "getRootBaseDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRootID", "Lcom/jetbrains/cidr/lang/modulemap/serialization/HeadersSearchRootId;", "nullInputStream", "", "serializeModuleMaps", "serializationPacks", "flatSize", "", "", "Companion", "Storage", "intellij.c"})
public class ModuleMapSerializationServiceImpl
implements ModuleMapSerializationService,
Disposable {
    @NotNull
    private final Project project;
    @NonNls
    private static final String TABLES_KEY_PREFIX = "clang_module_map_attribute";
    @NonNls
    private static final String EXPLICIT_FRAMEWORK_ID_PREFIX = "explicitFramework:";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void serializeModuleMaps(@NotNull ProgressIndicator indicator, @NotNull List<ModuleMapSerializationPack> serializationPacks) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(serializationPacks, (String)"serializationPacks");
        ModuleMapLowLevelSerializationService.Companion.getInstance().serialize(indicator, serializationPacks, FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion(), (Function1<? super ModuleMapSerializationPack, ? extends OutputStream>)((Function1)new Function1<ModuleMapSerializationPack, OutputStream>(this){

            @Nullable
            public final OutputStream invoke(@NotNull ModuleMapSerializationPack p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((ModuleMapSerializationServiceImpl)this.receiver).getOutputStream(p1);
            }
        }), this);
    }

    public void deserializeModuleMaps(@NotNull ProgressIndicator indicator, @NotNull DeserializationSession deserializationSession, boolean prebuiltOnly, @NotNull Function1<? super ModuleMapAssembledPack, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)deserializationSession, (String)"deserializationSession");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Set<ModuleMapPlatformType> platforms = this.getProjectPlatforms();
        PackAssembler assembler = new PackAssembler(platforms);
        ModuleMapLowLevelSerializationService.Companion.getInstance().deserialize(deserializationSession, (Function1<? super HeadersSearchRoot, ? extends InputStream>)((Function1)(prebuiltOnly ? new Function1(this){

            @Nullable
            public final Void invoke(@NotNull HeadersSearchRoot p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ModuleMapSerializationServiceImpl.access$nullInputStream((ModuleMapSerializationServiceImpl)this.receiver, p1);
            }
        } : new Function1<HeadersSearchRoot, InputStream>(this){

            @Nullable
            public final InputStream invoke(@NotNull HeadersSearchRoot p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((ModuleMapSerializationServiceImpl)this.receiver).getInputStream(p1);
            }
        })), (Function1<? super HeadersSearchRoot, ? extends InputStream>)((Function1)new Function1<HeadersSearchRoot, InputStream>(this){

            @Nullable
            public final InputStream invoke(@NotNull HeadersSearchRoot p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((ModuleMapSerializationServiceImpl)this.receiver).getPrebuiltCacheInputStream(p1);
            }
        }), indicator, this, (Function2<? super ModuleMapPrebuiltSerializationPack, ? super ModuleMapSerializationPack, Unit>)((Function2)new Function2<ModuleMapPrebuiltSerializationPack, ModuleMapSerializationPack, Unit>(assembler, processor){
            final /* synthetic */ PackAssembler $assembler;
            final /* synthetic */ Function1 $processor;

            public final void invoke(@Nullable ModuleMapPrebuiltSerializationPack prebuiltPack, @Nullable ModuleMapSerializationPack plainPack) {
                ModuleMapAssembledPack pack = this.$assembler.assemblePack(prebuiltPack, plainPack);
                if (pack != null) {
                    this.$processor.invoke((Object)pack);
                }
            }
            {
                this.$assembler = packAssembler;
                this.$processor = function1;
                super(2);
            }
        }));
    }

    private final Void nullInputStream(HeadersSearchRoot root) {
        return null;
    }

    private final Set<ModuleMapPlatformType> getProjectPlatforms() {
        boolean $i$f$runReadAction = false;
        return (Set)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ ModuleMapSerializationServiceImpl this$0;
            {
                this.this$0 = moduleMapSerializationServiceImpl;
            }

            public final T compute() {
                boolean bl = false;
                OCWorkspace oCWorkspace = OCWorkspace.getInstance((Project)this.this$0.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"OCWorkspace.getInstance(project)");
                List list = oCWorkspace.getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"OCWorkspace.getInstance(project).configurations");
                return (T)SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)getProjectPlatforms.1.1.INSTANCE));
            }
        });
    }

    @Override
    public void serializeModuleMaps(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ModuleMapCache moduleMapCache = ModuleMapCache.Companion.getInstance(this.project);
        Collection<ModuleMapPackWithRoot> cachedPacks = moduleMapCache.getAll();
        ModuleMapLog.LOG.info("Saved " + this.flatSize(cachedPacks) + " module maps in " + cachedPacks.size() + " packs");
        SerializationSessionImpl session = new SerializationSessionImpl(cachedPacks, this);
        List<ModuleMapSerializationPack> serializationPacks = session.getSerializationPacks();
        this.serializeModuleMaps(indicator, serializationPacks);
    }

    @Override
    @Nullable
    public HeadersSearchRootId getRootID(@NotNull HeadersSearchRoot root) {
        HeadersSearchRootId headersSearchRootId;
        String string;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Object object = root;
        if (object instanceof HeaderMapRoot) {
            string = ((HeaderMapRoot)root).getUrl() + ":" + ((HeaderMapRoot)root).getKind();
        } else if (object instanceof IncludedHeadersRoot) {
            string = ((IncludedHeadersRoot)root).getUrl() + ":" + ((IncludedHeadersRoot)root).isRecursive() + ":" + ((IncludedHeadersRoot)root).getKind();
        } else if (object instanceof ExplicitFramework) {
            string = EXPLICIT_FRAMEWORK_ID_PREFIX + ((ExplicitFramework)root).getId();
        } else {
            VirtualFile virtualFile = root.getVirtualFile();
            string = virtualFile != null ? virtualFile.getUrl() : null;
        }
        if (string != null) {
            object = string;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            headersSearchRootId = new HeadersSearchRootId((String)it);
        } else {
            headersSearchRootId = null;
        }
        return headersSearchRootId;
    }

    @Override
    @NotNull
    public Set<HeadersSearchRoot> deserializeModuleMaps(@NotNull ProgressIndicator indicator, @NotNull Set<? extends HeadersSearchRoot> roots2) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            boolean $i$f$runReadAction = false;
            ApplicationManager.getApplication().runReadAction(new Computable(roots2){
                final /* synthetic */ Set $roots$inlined;
                {
                    this.$roots$inlined = set;
                }

                public final T compute() {
                    boolean bl = false;
                    for (HeadersSearchRoot root : this.$roots$inlined) {
                        ModuleMapLog.LOG.trace("Deserializing module maps: " + root);
                    }
                    return (T)Unit.INSTANCE;
                }
            });
        }
        if ((list2 = this.deserializeAllModuleMaps(indicator, roots2)) == null) {
            list2 = list = this.deserializePrebuiltModuleMapsOnly(indicator, roots2);
        }
        if (list2 == null) {
            ModuleMapSerializationServiceImpl moduleMapSerializationServiceImpl = this;
            boolean bl = false;
            boolean bl2 = false;
            ModuleMapSerializationServiceImpl $this$run = moduleMapSerializationServiceImpl;
            boolean bl3 = false;
            ModuleMapLog.LOG.error("Prebuilt module map deserialization failed");
            list = CollectionsKt.emptyList();
        }
        List validPacks = list;
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)validPacks), (Function1)deserializeModuleMaps.6.INSTANCE));
    }

    private final List<ModuleMapPackWithRoot> deserializeAllModuleMaps(ProgressIndicator indicator, Set<? extends HeadersSearchRoot> roots2) {
        return this.doDeserializePacks(indicator, roots2, false);
    }

    private final List<ModuleMapPackWithRoot> deserializePrebuiltModuleMapsOnly(ProgressIndicator indicator, Set<? extends HeadersSearchRoot> roots2) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            throw (Throwable)((Object)new AssertionError((Object)"Deserialization failed"));
        }
        ModuleMapLog.LOG.error("Module map deserialization failed");
        ModuleMapCache.Companion.getInstance(this.project).reset();
        ModuleMapManager.Companion.getInstance(this.project).clearCache();
        return this.doDeserializePacks(indicator, roots2, true);
    }

    private final List<ModuleMapPackWithRoot> doDeserializePacks(ProgressIndicator indicator, Set<? extends HeadersSearchRoot> roots2, boolean prebuiltOnly) {
        boolean shouldDeserializeNonBundledPacks = ModuleMapCache.Companion.shouldReloadCache();
        boolean bl = false;
        List packs = new ArrayList();
        DeserializationSessionImpl session = new DeserializationSessionImpl((Collection<? extends HeadersSearchRoot>)roots2, this);
        this.deserializeModuleMaps(indicator, session, prebuiltOnly, (Function1<? super ModuleMapAssembledPack, Unit>)((Function1)new Function1<ModuleMapAssembledPack, Unit>(indicator, shouldDeserializeNonBundledPacks, packs){
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ boolean $shouldDeserializeNonBundledPacks;
            final /* synthetic */ List $packs;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull ModuleMapAssembledPack pack) {
                block6: {
                    boolean bl;
                    Object object;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
                        HeadersSearchRoot headersSearchRoot = pack.getHeadersSearchRoot();
                        this.$indicator.setText2(headersSearchRoot.getName());
                        if (this.$shouldDeserializeNonBundledPacks) break block5;
                        object = ((ModuleMapAssembledPack.State)pack.getState()).getPrebuiltMaps();
                        bl = false;
                        if (!(!object.isEmpty())) break block6;
                    }
                    object = this.$packs;
                    bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        boolean bl3 = false;
                        bl2 = this.$packs.add(pack);
                    }
                }
            }
            {
                this.$indicator = progressIndicator;
                this.$shouldDeserializeNonBundledPacks = bl;
                this.$packs = list;
                super(1);
            }
        }));
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            boolean $i$f$runReadAction = false;
            ApplicationManager.getApplication().runReadAction(new Computable(packs){
                final /* synthetic */ List $packs$inlined;
                {
                    this.$packs$inlined = list;
                }

                public final T compute() {
                    boolean bl = false;
                    for (ModuleMapAssembledPack pack : this.$packs$inlined) {
                        ModuleMapLog.LOG.trace("Deserialized module maps: " + pack.getHeadersSearchRoot());
                    }
                    return (T)Unit.INSTANCE;
                }
            });
        }
        DependencyInitializationSession initializationSession = new DependencyInitializationSession(packs, this, prebuiltOnly);
        List<ModuleMapPackWithRoot> list = initializationSession.getInitializedPacks();
        if (list == null) {
            return null;
        }
        List<ModuleMapPackWithRoot> validPacks = list;
        this.flushValidPacksToModuleMapCache(validPacks);
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            boolean $i$f$runReadAction = false;
            ApplicationManager.getApplication().runReadAction(new Computable(validPacks){
                final /* synthetic */ List $validPacks$inlined;
                {
                    this.$validPacks$inlined = list;
                }

                public final T compute() {
                    boolean bl = false;
                    for (ModuleMapPackWithRoot pack : this.$validPacks$inlined) {
                        ModuleMapLog.LOG.trace("Applied module maps: " + pack.getHeadersSearchRoot());
                    }
                    return (T)Unit.INSTANCE;
                }
            });
        }
        ModuleMapLog.LOG.info("Loaded " + this.flatSize((Collection<ModuleMapPackWithRoot>)validPacks) + " module maps in " + validPacks.size() + " packs for " + roots2.size() + " search roots");
        return validPacks;
    }

    private final void flushValidPacksToModuleMapCache(List<ModuleMapPackWithRoot> validPacks) {
        ModuleMapCache moduleMapCache = ModuleMapCache.Companion.getInstance(this.project);
        for (ModuleMapPackWithRoot pack : validPacks) {
            ModuleMapPack moduleMapPack = pack.getModuleMapPack();
            moduleMapPack.compact();
            moduleMapCache.cache(pack.getHeadersSearchRoot(), moduleMapPack);
        }
    }

    private final int flatSize(Collection<ModuleMapPackWithRoot> $this$flatSize) {
        return $this$flatSize.parallelStream().mapToInt(flatSize.1.INSTANCE).sum();
    }

    @Nullable
    public OutputStream getOutputStream(@NotNull ModuleMapSerializationPack pack) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        Storage storage = this.getStorage(pack.getHeadersSearchRoot());
        return storage != null ? storage.getOutputStream() : null;
    }

    @Nullable
    public InputStream getInputStream(@NotNull HeadersSearchRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Storage storage = this.getStorage(root);
        return storage != null ? storage.getInputStream() : null;
    }

    private final Storage getStorage(HeadersSearchRoot $this$storage) {
        HeadersSearchRootId headersSearchRootId = this.getRootID($this$storage);
        if (headersSearchRootId == null) {
            return null;
        }
        HeadersSearchRootId id = headersSearchRootId;
        VirtualFile virtualFile = this.getRootBaseDirectory($this$storage);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile dir = virtualFile;
        SerializationAttributeService serializationAttributeService = SerializationAttributeService.Companion.getInstance();
        StringBuilder stringBuilder = new StringBuilder().append("clang_module_map_attribute:");
        Project project = $this$storage.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        FileAttribute attribute = serializationAttributeService.getFileCacheAttributeForProjectKey(stringBuilder.append(project.getLocationHash()).append(":").append(id).toString(), 44);
        return new Storage(attribute, dir);
    }

    @Nullable
    public InputStream getPrebuiltCacheInputStream(@NotNull HeadersSearchRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return null;
    }

    @Nullable
    public final VirtualFile getRootBaseDirectory(@NotNull HeadersSearchRoot root) {
        VirtualFile file;
        Object object;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        HeadersSearchRoot headersSearchRoot = root;
        if (headersSearchRoot instanceof ModuleMapRoot) {
            VirtualFile virtualFile = ((ModuleMapRoot)root).getVirtualFile();
            object = virtualFile != null ? virtualFile.getParent() : null;
        } else {
            object = file = headersSearchRoot instanceof ExplicitFramework ? ((ExplicitFramework)root).getModuleMapBaseDirectory() : root.getVirtualFile();
        }
        if (file == null || !file.isValid()) {
            return null;
        }
        return file;
    }

    @Override
    public long calculateContentHashCode(@NotNull HeadersSearchRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        boolean $i$f$runReadAction = false;
        return ((Number)ApplicationManager.getApplication().runReadAction(new Computable(root){
            final /* synthetic */ HeadersSearchRoot $root$inlined;
            {
                this.$root$inlined = headersSearchRoot;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                void hash;
                boolean bl = false;
                Ref.LongRef longRef = new Ref.LongRef();
                longRef.element = 0L;
                this.$root$inlined.processChildren(new PsiElementProcessor((Ref.LongRef)hash){
                    final /* synthetic */ Ref.LongRef $hash;
                    {
                        this.$hash = longRef;
                    }

                    public final boolean execute(@NotNull PsiFileSystemItem element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        long l = this.$hash.element;
                        VirtualFile virtualFile = element.getVirtualFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"element.virtualFile");
                        this.$hash.element = l + virtualFile.getTimeStamp();
                        return true;
                    }
                });
                return (T)Long.valueOf(hash.element);
            }
        })).longValue();
    }

    public void dispose() {
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ModuleMapSerializationServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public static final /* synthetic */ Void access$nullInputStream(ModuleMapSerializationServiceImpl $this, HeadersSearchRoot root) {
        return $this.nullInputStream(root);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationServiceImpl$Storage;", "", "attribute", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/newvfs/FileAttribute;Lcom/intellij/openapi/vfs/VirtualFile;)V", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "intellij.c"})
    private static final class Storage {
        private final FileAttribute attribute;
        private final VirtualFile file;

        @Nullable
        public final InputStream getInputStream() {
            return this.attribute.readAttribute(this.file);
        }

        @NotNull
        public final OutputStream getOutputStream() {
            DataOutputStream dataOutputStream = this.attribute.writeAttribute(this.file);
            Intrinsics.checkNotNullExpressionValue((Object)dataOutputStream, (String)"attribute.writeAttribute(file)");
            return dataOutputStream;
        }

        public Storage(@NotNull FileAttribute attribute, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.attribute = attribute;
            this.file = file;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationServiceImpl$Companion;", "", "()V", "EXPLICIT_FRAMEWORK_ID_PREFIX", "", "TABLES_KEY_PREFIX", "intellij.c"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

