/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.text.FilePathHashingStrategy;
import com.intellij.util.text.MergingCharSequence;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCCompilerMacros;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilderImpl;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCModuleResolver;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCConceptSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInterner;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class OCInclusionContextImpl
implements OCInclusionContext {
    @NotNull
    static final Logger LOG = Logger.getInstance(OCInclusionContext.class);
    static int DEFAULT_MAX_INCLUSION_LEVEL = 256;
    @NotNull
    private final OCLanguageKind myLanguageKind;
    private boolean myIsSurrogate;
    @Nullable
    private Runnable myImpatientReschedule;
    private boolean myAbortOnLanguageKindMismatch;
    private final boolean myNotifyLocalDefinitions;
    @Nullable
    private final OCResolveConfiguration myConfiguration;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, OCMacroSymbol> mySubstitutions;
    @NotNull
    private final Set<String> myUndefList;
    @NotNull
    private volatile OCParsingNameScope myNameScope;
    private boolean myInheritProcessedFiles;
    @NotNull
    private final Set<VirtualFile> myProcessedFiles;
    @Nullable
    private final OCInclusionContextImpl myParentContext;
    private final int myInclusionLevel;
    @Nullable
    private PsiFile myRootFile;
    private VirtualFile @Nullable [] myPrecompiledHeaders;
    @Nullable
    private OCInclusionContext.SignatureBuilder mySignatureBuilder;
    @Nullable
    private final CompilerSettingsKey myCompilerSettingsKey;
    @NotNull
    private final List<String> myCurrentNamespace;
    private Processor<OCSymbol> myProcessingListener;
    @Nullable
    private OCContextChangeBuilder myChangeBuilder;
    private final Map<String, OCMacroSymbol> myOverriddenSubstitutions;
    @NotNull
    private static final Object NULL_VALUE = new Object();
    @NotNull
    private final ConcurrentHashMap<OCCompilerFeatures.Type, Object> myCompilerFeatures;
    @Nullable
    private OCInclusionContext.ResolvePathListener myResolvePathListener;
    static final NotNullLazyKey<Map<CompilerSettingsKey, Map<FileSymbolTable, Boolean>>, OCResolveConfiguration> INCLUDE_RESOLVE_CACHE = NotNullLazyKey.create((String)"INCLUDE_RESOLVE_CACHE", dom -> Collections.synchronizedMap(CollectionFactory.createSmallMemoryFootprintMap()));
    static final NotNullLazyKey<InitialPlainAndPchContexts, OCResolveConfiguration> INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY = NotNullLazyKey.create((String)"INITIAL_CONTEXTS_KEY", p -> new InitialPlainAndPchContexts());
    private static final NameScopeInterner NAME_SCOPE_INTERNER = new NameScopeInterner();
    private static final @NonNls String @NotNull [] OBJC_MAIN_HEADER = new String[]{"objc", "objc.h"};
    static volatile Integer MAX_INCLUSION_LEVEL_IN_TESTS = null;

    @NotNull
    static List<VirtualFile> getPrecompiledHeaders(@NotNull OCResolveConfiguration config, @NotNull OCLanguageKind kind, @NotNull VirtualFile sourceFile) {
        if (config == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(1);
        }
        if (sourceFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(2);
        }
        List pchs = config.getCompilerSettings(kind, sourceFile).getImplicitIncludes();
        List list = ContainerUtil.copyList((List)pchs);
        if (list == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    OCInclusionContextImpl(@Nullable OCResolveConfiguration configuration, @NotNull Project project, @NotNull OCLanguageKind languageKind, @Nullable CompilerSettingsKey settingsKey) {
        if (project == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(4);
        }
        if (languageKind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(5);
        }
        this.mySubstitutions = CollectionFactory.createSmallMemoryFootprintMap();
        this.myUndefList = new HashSet<String>();
        this.myPrecompiledHeaders = null;
        this.mySignatureBuilder = null;
        assert (configuration == null || project.equals(configuration.getProject()));
        this.myConfiguration = configuration;
        this.myProject = project;
        this.myLanguageKind = languageKind;
        this.myCompilerSettingsKey = settingsKey;
        this.myNameScope = new OCParsingNameScope();
        this.myParentContext = null;
        this.myInclusionLevel = 0;
        this.myNotifyLocalDefinitions = false;
        this.myImpatientReschedule = null;
        this.myAbortOnLanguageKindMismatch = false;
        this.myCurrentNamespace = new ArrayList<String>();
        this.myOverriddenSubstitutions = CollectionFactory.createSmallMemoryFootprintMap();
        this.myCompilerFeatures = new ConcurrentHashMap();
        this.myProcessedFiles = CollectionFactory.createSmallMemoryFootprintSet();
    }

    private OCInclusionContextImpl(@NotNull OCInclusionContextImpl parentContext, @NotNull PsiFile rootFile, @NotNull OCParsingNameScope nameScope, @NotNull OCLanguageKind languageKind, boolean notifyLocalDefinitions) {
        if (parentContext == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(6);
        }
        if (rootFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(7);
        }
        if (nameScope == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(8);
        }
        if (languageKind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(9);
        }
        this.mySubstitutions = CollectionFactory.createSmallMemoryFootprintMap();
        this.myUndefList = new HashSet<String>();
        this.myPrecompiledHeaders = null;
        this.mySignatureBuilder = null;
        this.myConfiguration = parentContext.myConfiguration;
        this.myProject = parentContext.myProject;
        this.myLanguageKind = languageKind;
        this.myCompilerSettingsKey = parentContext.myCompilerSettingsKey;
        this.myIsSurrogate = parentContext.isSurrogate();
        this.myParentContext = parentContext;
        this.myRootFile = rootFile;
        this.myNameScope = nameScope;
        this.myInclusionLevel = parentContext.myInclusionLevel + 1;
        this.myNotifyLocalDefinitions = notifyLocalDefinitions;
        this.myImpatientReschedule = parentContext.myImpatientReschedule;
        this.myAbortOnLanguageKindMismatch = parentContext.myAbortOnLanguageKindMismatch;
        this.myCurrentNamespace = new ArrayList<String>();
        this.myOverriddenSubstitutions = parentContext.myOverriddenSubstitutions;
        this.myCompilerFeatures = parentContext.myCompilerFeatures;
        this.myResolvePathListener = parentContext.myResolvePathListener;
        this.myInheritProcessedFiles = parentContext.myInheritProcessedFiles;
        this.myProcessedFiles = this.myInheritProcessedFiles ? parentContext.myProcessedFiles : CollectionFactory.createSmallMemoryFootprintSet();
        OCLog.LOG.assertTrue(this.myInclusionLevel <= OCInclusionContext.getMaxInclusionLevel() + 2, (Object)"Inclusion level is too high");
    }

    @Override
    @NotNull
    public OCLanguageKind getLanguageKind() {
        OCLanguageKind oCLanguageKind = this.myLanguageKind;
        if (oCLanguageKind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(10);
        }
        return oCLanguageKind;
    }

    @Override
    public boolean isSurrogate() {
        return this.myIsSurrogate || this.myParentContext != null && this.myParentContext.isSurrogate();
    }

    @Override
    public boolean isDumb() {
        if (!DumbService.isDumb((Project)this.myProject)) {
            return false;
        }
        if (this.mySignatureBuilder != null) {
            this.mySignatureBuilder.setIsDumbPlaceholder();
        }
        return true;
    }

    @Override
    public void markAsSurrogate() {
        this.myIsSurrogate = true;
    }

    @Override
    @Nullable
    public Runnable getImpatientRescheduling() {
        return this.myImpatientReschedule;
    }

    @Override
    public void setImpatientRescheduling(@Nullable Runnable reschedule) {
        this.myImpatientReschedule = reschedule;
    }

    @Override
    public void setAbortOnLanguageKindMismatch(boolean active) {
        this.myAbortOnLanguageKindMismatch = active;
    }

    @Override
    public void setInheritProcessedFiles(boolean share) {
        this.myInheritProcessedFiles = share;
    }

    @Override
    public void addProcessedFile(@NotNull VirtualFile file) {
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(11);
        }
        if (this.myChangeBuilder != null) {
            this.myChangeBuilder.addProcessedFile(file);
        }
        this.myProcessedFiles.add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkConformanceAndFillSignatures(@NotNull FileSymbolTable table) {
        if (table == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(12);
        }
        this.enterConformanceCheckMode();
        boolean isCompatibleTable = false;
        try {
            ContextSignature sig = table.getSignature();
            if (sig.isCompatible(this)) {
                isCompatibleTable = this.myConfiguration == null || this.conformsToByIncludes(table);
            }
            boolean bl = isCompatibleTable;
            return bl;
        }
        finally {
            this.exitConformanceCheckMode(isCompatibleTable);
        }
    }

    @Override
    public void setProcessingListener(@Nullable Processor<OCSymbol> processingListener) {
        this.myProcessingListener = processingListener;
    }

    @Override
    public void setResolvePathListener(@Nullable OCInclusionContext.ResolvePathListener resolvePathListener) {
        this.myResolvePathListener = resolvePathListener;
    }

    @Override
    public void setChangeBuilder(@Nullable OCContextChangeBuilder changeBuilder) {
        this.myChangeBuilder = changeBuilder;
    }

    @NotNull
    static OCInclusionContext emptyWithBuiltinMacros(@Nullable OCLanguageKind kind, @NotNull PsiFile file) {
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(13);
        }
        if (kind == null) {
            kind = OCLanguageKindCalculator.calculateLanguageKindFast(file);
        }
        OCInclusionContextImpl result = (OCInclusionContextImpl)OCInclusionContext.empty(kind, file);
        result.initContext(file, null);
        OCInclusionContextImpl oCInclusionContextImpl = result;
        if (oCInclusionContextImpl == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(14);
        }
        return oCInclusionContextImpl;
    }

    @NotNull
    static OCInclusionContextImpl initialContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (configuration == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(15);
        }
        if (kind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(16);
        }
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(17);
        }
        if (!OCInclusionContextUtil.isLongLived(virtualFile = OCInclusionContextUtil.getVirtualFile(file))) {
            return OCInclusionContextImpl.createNewContext(configuration, kind, file, null, true);
        }
        CompilerSettingsKey key = configuration.getCompilerSettings(kind, virtualFile).getCachingKey();
        if (key == null) {
            return OCInclusionContextImpl.createNewContext(configuration, kind, file, null, false);
        }
        OCInclusionContextImpl oCInclusionContextImpl = OCInclusionContextImpl.cacheOrGet(((InitialPlainAndPchContexts)OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)configuration)).switches2plainContext, key, () -> {
            OCInclusionContextImpl result = OCInclusionContextImpl.createNewContext(configuration, kind, file, key, true);
            result.myNameScope = NAME_SCOPE_INTERNER.intern(result.myNameScope);
            return result;
        });
        if (oCInclusionContextImpl == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(18);
        }
        return oCInclusionContextImpl;
    }

    @NotNull
    static OCInclusionContextImpl initialPCHContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (configuration == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(19);
        }
        if (kind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(20);
        }
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(21);
        }
        if (!OCInclusionContextUtil.isLongLived(virtualFile = OCInclusionContextUtil.getVirtualFile(file))) {
            return OCInclusionContextImpl.initialContextWithoutRoot(configuration, kind, file);
        }
        return OCInclusionContextImpl.initialPCHContextWithoutRoot(configuration, kind, file, virtualFile, true);
    }

    @NotNull
    private static OCInclusionContextImpl initialPCHContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file, @NotNull VirtualFile virtualFile, boolean allowLanguageKindFallback) {
        CompilerSettingsKey key;
        if (configuration == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(22);
        }
        if (kind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(23);
        }
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(24);
        }
        if (virtualFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(25);
        }
        if ((key = configuration.getCompilerSettings(kind, virtualFile).getCachingKey()) == null || !kind.supportsPrecompiledHeaders() || OCInclusionContext.isPrecompiledHeader(virtualFile, configuration)) {
            return OCInclusionContextImpl.initialContextWithoutRoot(configuration, kind, file);
        }
        OCInclusionContextImpl oCInclusionContextImpl = OCInclusionContextImpl.cacheOrGet(((InitialPlainAndPchContexts)OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)configuration)).switches2PCHContext, key, () -> {
            try {
                return OCInclusionContextImpl.createNewPCHContext(configuration, kind, file, virtualFile);
            }
            catch (OCInclusionContext.LanguageKindMismatchException e) {
                OCLanguageKind requiredLanguageKind = OCInclusionContext.handleLanguageKindMismatch(virtualFile, e, allowLanguageKindFallback);
                return OCInclusionContextImpl.initialPCHContextWithoutRoot(configuration, requiredLanguageKind, file, virtualFile, false);
            }
        });
        if (oCInclusionContextImpl == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(26);
        }
        return oCInclusionContextImpl;
    }

    @NotNull
    private static OCInclusionContextImpl createNewPCHContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file, @NotNull VirtualFile virtualFile) throws OCInclusionContext.LanguageKindMismatchException {
        if (configuration == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(27);
        }
        if (kind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(28);
        }
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(29);
        }
        if (virtualFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(30);
        }
        OCInclusionContextImpl initial = OCInclusionContextImpl.initialContextWithoutRoot(configuration, kind, file);
        List<VirtualFile> precompiledHeaders = OCInclusionContextImpl.getPrecompiledHeaders(configuration, kind, virtualFile);
        if (precompiledHeaders.isEmpty()) {
            OCInclusionContextImpl oCInclusionContextImpl = initial;
            if (oCInclusionContextImpl == null) {
                OCInclusionContextImpl.$$$reportNull$$$0(31);
            }
            return oCInclusionContextImpl;
        }
        OCInclusionContextImpl ctx = initial.derive(file);
        ctx.setAbortOnLanguageKindMismatch(true);
        for (VirtualFile pch : precompiledHeaders) {
            try {
                ctx.preprocessInclude(pch, true, null, 0);
            }
            catch (OCInclusionContext.LanguageKindMismatchException e) {
                e.responsibleFile = pch;
                throw e;
            }
        }
        for (VirtualFile pch : precompiledHeaders) {
            OCImportGraph.getInstance(file.getProject()).addHeaderIncluder(pch, virtualFile);
        }
        ctx.setRootFile(null);
        ctx.setAbortOnLanguageKindMismatch(false);
        ctx.setPrecompiledHeaders(precompiledHeaders);
        ctx.myNameScope = NAME_SCOPE_INTERNER.intern(ctx.myNameScope);
        OCInclusionContextImpl oCInclusionContextImpl = ctx;
        if (oCInclusionContextImpl == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(32);
        }
        return oCInclusionContextImpl;
    }

    @NotNull
    private static OCInclusionContextImpl createNewContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file, @Nullable CompilerSettingsKey settingsKey, boolean initFromCompilerSettings) {
        if (configuration == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(33);
        }
        if (kind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(34);
        }
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(35);
        }
        OCInclusionContextImpl result = new OCInclusionContextImpl(configuration, configuration.getProject(), kind, settingsKey);
        result.initContext(file, (OCResolveConfiguration)(initFromCompilerSettings ? configuration : null));
        OCInclusionContextImpl oCInclusionContextImpl = result;
        if (oCInclusionContextImpl == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(36);
        }
        return oCInclusionContextImpl;
    }

    private static <T, R> R cacheOrGet(@NotNull Map<T, R> map, @NotNull T key, @NotNull Supplier<? extends R> mappingFunction) {
        R context;
        if (map == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(37);
        }
        if (key == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(38);
        }
        if (mappingFunction == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(39);
        }
        if ((context = map.get(key)) != null) {
            return context;
        }
        R newContext = mappingFunction.get();
        context = map.putIfAbsent(key, newContext);
        return context != null ? context : newContext;
    }

    private void initContext(@NotNull PsiFile sourceFile, @Nullable OCResolveConfiguration configuration) {
        if (sourceFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(40);
        }
        assert (this.myParentContext == null || !(this.myParentContext.myLanguageKind instanceof CLanguageKind)) : "initContext is supposed to be called on a root context.";
        OCLanguageKind languageKind = this.getLanguageKind();
        this.mySubstitutions.putAll(OCInclusionContextImpl.getSubstitutions(languageKind, sourceFile, OCCompilerMacros.PREDEFINED_MACROS));
        if (configuration != null) {
            VirtualFile vFile = OCInclusionContextUtil.getVirtualFile(sourceFile);
            OCCompilerSettings compilerSettings = configuration.getCompilerSettings(languageKind, vFile);
            this.mySubstitutions.putAll(OCInclusionContextImpl.getSubstitutions(languageKind, sourceFile, StringUtil.join((Collection)compilerSettings.getPreprocessorDefines(), (String)"\n")));
            this.myCompilerFeatures.putAll(compilerSettings.getCompilerFeatures());
        }
        this.myOverriddenSubstitutions.putAll(OCInclusionContextImpl.getSubstitutions(languageKind, sourceFile, "#define __OSX_AVAILABLE_BUT_DEPRECATED(_macIntro, _macDep, _iosIntro, _iosDep)           __CIDR_OSX_AVAILABLE_BUT_DEPRECATED_IMPL(_macIntro, _macDep, _iosIntro, _iosDep)\n#define __OSX_AVAILABLE_BUT_DEPRECATED_MSG(_macIntro, _macDep, _iosIntro, _iosDep, _msg) __CIDR_OSX_AVAILABLE_BUT_DEPRECATED_IMPL(_macIntro, _macDep, _iosIntro, _iosDep)\n#define __OSX_AVAILABLE_STARTING(mac, ios) __CIDR_OSX_AVAILABLE_STARTING_IMPL(mac, ios)\n#define CF_DEPRECATED(_macIntro, _macDep, _iosIntro, _iosDep, ...) __CIDR_OSX_DEPRECATED(_macIntro, _macDep, _iosIntro, _iosDep)\n#define CF_DEPRECATED_MAC(_macIntro, _macDep, ...)                 __CIDR_OSX_DEPRECATED(_macIntro, _macDep, NA,        NA)\n#define CF_DEPRECATED_IOS(_iosIntro, _iosDep, ...)                 __CIDR_OSX_DEPRECATED(NA,        NA,      _iosIntro, _iosDep)\n#define CF_AVAILABLE(mac, ios)       __CIDR_OSX_AVAILABLE(mac, ios)\n#define CF_AVAILABLE_MAC(mac)        __CIDR_OSX_AVAILABLE(mac, NA) \n#define CF_AVAILABLE_IOS(ios)        __CIDR_OSX_AVAILABLE(NA,  ios)\n#define CF_CLASS_AVAILABLE(mac, ios) __CIDR_OSX_AVAILABLE(mac, ios)\n#define CF_CLASS_AVAILABLE_MAC(mac)  __CIDR_OSX_AVAILABLE(mac, NA) \n#define CF_CLASS_AVAILABLE_IOS(ios)  __CIDR_OSX_AVAILABLE(NA,  ios)\n#define NS_AVAILABLE(mac, ios)       __CIDR_OSX_AVAILABLE(mac, ios)\n#define NS_AVAILABLE_MAC(mac)        __CIDR_OSX_AVAILABLE(mac, NA) \n#define NS_AVAILABLE_IOS(ios)        __CIDR_OSX_AVAILABLE(NA,  ios)\n#define NS_CLASS_AVAILABLE(mac, ios) __CIDR_OSX_AVAILABLE(mac, ios)\n#define NS_CLASS_AVAILABLE_MAC(mac)  __CIDR_OSX_AVAILABLE(mac, NA) \n#define NS_CLASS_AVAILABLE_IOS(ios)  __CIDR_OSX_AVAILABLE(NA,  ios)\n#define __API_A(x)     __CIDR_API_AVAILABLE_PLATFORM_##x\n#define __API_D(msg,x) __CIDR_API_DEPRECATED_PLATFORM_##x\n#define __API_R(msg,x) __CIDR_API_DEPRECATED_PLATFORM_##x\n#define __CF_NAMED_ENUM(_type, _name) __attribute__((NS_ENUM_MACRO)) enum _name : _type _name; enum __attribute__((NS_ENUM)) _name : _type\n#define __CF_ANON_ENUM(_type) enum __attribute__((NS_ENUM)) : _type\n\n#define NS_OPTIONS(_type, _name) __attribute__((NS_OPTIONS_MACRO)) enum _name : _type _name; enum __attribute__((NS_OPTIONS)) _name : _type\n"));
        CollectionFactory.trimMap(this.myOverriddenSubstitutions);
    }

    private static Map<String, OCMacroSymbol> getSubstitutions(@NotNull OCLanguageKind languageKind, @NotNull PsiFile sourceFile, @NotNull String text) {
        if (languageKind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(41);
        }
        if (sourceFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(42);
        }
        if (text == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(43);
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return Collections.emptyMap();
        }
        Project project = sourceFile.getProject();
        Map cache = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED}));
        Map<String, OCMacroSymbol> cached = (Map<String, OCMacroSymbol>)cache.get(text);
        if (cached == null) {
            OCInclusionContextImpl context = (OCInclusionContextImpl)OCInclusionContext.empty(languageKind, sourceFile);
            OCPreprocessingLexer lexer = new OCPreprocessingLexer(context, null);
            lexer.start((CharSequence)new MergingCharSequence((CharSequence)"\n", (CharSequence)text));
            while (lexer.getTokenType() != null) {
                lexer.advance();
            }
            cached = context.mySubstitutions;
            CollectionFactory.trimMap(cached);
            cache.putIfAbsent(text, cached);
        }
        return cached;
    }

    private boolean conformsToByIncludes(@NotNull FileSymbolTable table) {
        Map<FileSymbolTable, Boolean> resolveCache;
        Boolean cached;
        if (table == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(44);
        }
        Boolean bl = cached = (resolveCache = this.getSymbolTablesConformingCache()) != null ? resolveCache.get(table) : null;
        if (cached != null) {
            return cached;
        }
        boolean conforms = table.processIncludes((Processor<? super OCSymbol>)((Processor)symbol -> {
            if (!(symbol instanceof OCIncludeSymbol)) {
                return true;
            }
            OCIncludeSymbol includeSymbol = (OCIncludeSymbol)symbol;
            VirtualFile targetFile = includeSymbol.getTargetFile();
            if (targetFile instanceof LightVirtualFileBase) {
                return true;
            }
            VirtualFile owner = table.getContainingFile();
            OCIncludeSymbol.IncludePath path = includeSymbol.getIncludePath();
            VirtualFile resolved = this.resolvePath(path, owner, includeSymbol.isNext(), false);
            return Comparing.equal((Object)targetFile, (Object)resolved);
        }));
        if (resolveCache != null) {
            resolveCache.put(table, conforms);
        }
        return conforms;
    }

    @Override
    public int getInclusionLevel() {
        return this.myInclusionLevel;
    }

    @Override
    @Nullable
    public OCImmutableInclusionContext getParent() {
        return this.myParentContext;
    }

    @Override
    public void setPrecompiledHeaders(@NotNull List<VirtualFile> precompiledHeaders) {
        if (precompiledHeaders == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(45);
        }
        this.myPrecompiledHeaders = precompiledHeaders.toArray(VirtualFile.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public List<VirtualFile> getPrecompiledHeaders() {
        Object[] precompiledHeaders = this.myPrecompiledHeaders;
        if (!ArrayUtil.isEmpty((Object[])precompiledHeaders)) {
            ImmutableList immutableList = ContainerUtil.immutableList((Object[])precompiledHeaders);
            if (immutableList == null) {
                OCInclusionContextImpl.$$$reportNull$$$0(46);
            }
            return immutableList;
        }
        List<VirtualFile> list = this.myParentContext == null ? Collections.emptyList() : this.myParentContext.getPrecompiledHeaders();
        if (list == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(47);
        }
        return list;
    }

    @Override
    public boolean hasRootFile() {
        return this.myRootFile != null;
    }

    @Override
    @NotNull
    public PsiFile getRootFile() {
        if (this.myRootFile == null) {
            OCLog.LOG.error("No root file");
        }
        PsiFile psiFile = this.myRootFile;
        if (psiFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(48);
        }
        return psiFile;
    }

    @Override
    public OCInclusionContext setRootFile(@Nullable PsiFile file) {
        if (this.myRootFile != null && file != null) {
            throw new IllegalStateException("Trying to change root file for inclusion context with existing root file");
        }
        this.myRootFile = file;
        return this;
    }

    @Nullable
    static OCImmutableInclusionContext findInCachedPCHPrecompiledContexts(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header) {
        if (config == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(49);
        }
        if (header == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(50);
        }
        InitialPlainAndPchContexts initialContexts = (InitialPlainAndPchContexts)INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)config);
        Collection values = initialContexts.switches2PCHContext.values();
        OCImmutableInclusionContext bestContext = null;
        for (OCImmutableInclusionContext each : values) {
            OCLanguageKind eachContextLang = each.getLanguageKind();
            assert (eachContextLang.supportsPrecompiledHeaders());
            if (!each.isProcessed(header)) continue;
            assert (eachContextLang instanceof CLanguageKind || eachContextLang instanceof CUDALanguageKind);
            if (!(eachContextLang instanceof CLanguageKind) || bestContext != null && bestContext.getLanguageKind() != CLanguageKind.min((CLanguageKind)((CLanguageKind)eachContextLang), (CLanguageKind)((CLanguageKind)bestContext.getLanguageKind()))) continue;
            bestContext = each;
        }
        return bestContext;
    }

    @Nullable
    private Map<FileSymbolTable, Boolean> getSymbolTablesConformingCache() {
        if (this.myConfiguration == null) {
            return null;
        }
        if (this.myRootFile == null) {
            return null;
        }
        if (this.myCompilerSettingsKey == null) {
            return null;
        }
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(this.myRootFile);
        if (!OCInclusionContextUtil.isLongLived(virtualFile)) {
            return null;
        }
        Map settingsCache = (Map)INCLUDE_RESOLVE_CACHE.getValue((UserDataHolder)this.myConfiguration);
        Map result = (Map)settingsCache.get(this.myCompilerSettingsKey);
        if (result == null) {
            result = settingsCache.putIfAbsent(this.myCompilerSettingsKey, Collections.synchronizedMap(ContainerUtil.createWeakMap()));
        }
        return result;
    }

    @Nullable
    public <T> T getCompilerFeature(@NotNull OCCompilerFeatures.Type<T> feature) {
        Object value;
        if (feature == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(51);
        }
        if ((value = OCCompilerFeatures.getForTests((Project)this.getProject(), feature)) != null) {
            return (T)value;
        }
        Object result = this.myCompilerFeatures.get(feature);
        if (result == null) {
            OCInclusionContextImpl topMost = this;
            while (topMost.myParentContext != null) {
                topMost = topMost.myParentContext;
            }
            result = feature.compute((OCCompilerFeaturesProvider)topMost);
            if (result == null) {
                result = NULL_VALUE;
            }
            this.myCompilerFeatures.putIfAbsent(feature, result);
        }
        return (T)(result == NULL_VALUE ? null : result);
    }

    @Nullable
    private String getSubstitution(@NotNull @NonNls String id) {
        OCMacroSymbol macro;
        if (id == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(52);
        }
        return (macro = this.getDefinition(id)) == null ? null : macro.getSubstitution();
    }

    public boolean areMSExtensionsEnabled() {
        return "1".equals(this.getSubstitution("_MSC_EXTENSIONS"));
    }

    public OCLanguageStandard getLanguageStandard() {
        if (this.getLanguageKind().isCpp()) {
            return OCLanguageStandard.getCppStandard((String)this.getSubstitution("__cplusplus"));
        }
        return OCLanguageStandard.getCStandard((String)this.getSubstitution("__STDC_VERSION__"));
    }

    @Override
    @NotNull
    public OCParsingNameScope getNameScope() {
        OCParsingNameScope oCParsingNameScope = this.myNameScope;
        if (oCParsingNameScope == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(53);
        }
        return oCParsingNameScope;
    }

    @Override
    @NotNull
    public OCInclusionContextImpl derive() {
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        return new OCInclusionContextImpl(this, this.myRootFile, this.myNameScope.copy(), this.myLanguageKind, true);
    }

    @Override
    @NotNull
    public OCInclusionContextImpl derive(@NotNull PsiFile file) {
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(54);
        }
        if (this.myRootFile != null) {
            throw new IllegalStateException("Deriving from context with existing root file. Use 'derive()' instead");
        }
        return new OCInclusionContextImpl(this, file, this.myNameScope.copy(), this.myLanguageKind, true);
    }

    @Override
    @NotNull
    public OCInclusionContextImpl derive(@NotNull OCParsingNameScope nameScope) {
        if (nameScope == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(55);
        }
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        return new OCInclusionContextImpl(this, this.myRootFile, nameScope, this.myLanguageKind, true);
    }

    @Override
    @NotNull
    public OCInclusionContextImpl deriveButDontCopyTypes(boolean notifyLocalDefinitions) {
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        return new OCInclusionContextImpl(this, this.myRootFile, this.myNameScope, this.myLanguageKind, notifyLocalDefinitions);
    }

    @Override
    @NotNull
    public OCInclusionContext deriveWithLanguageKind(@NotNull OCLanguageKind languageKind) {
        if (languageKind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(56);
        }
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        OCInclusionContextImpl derived = new OCInclusionContextImpl(this, this.myRootFile, this.myNameScope, languageKind, false);
        if (languageKind instanceof CLanguageKind && !(this.myLanguageKind instanceof CLanguageKind)) {
            derived.initContext(this.myRootFile, this.myConfiguration);
        }
        OCInclusionContextImpl oCInclusionContextImpl = derived;
        if (oCInclusionContextImpl == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(57);
        }
        return oCInclusionContextImpl;
    }

    @Override
    public void define(@NotNull OCMacroSymbol def) {
        String name;
        OCMacroSymbol overridden;
        if (def == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(58);
        }
        if ((overridden = this.myOverriddenSubstitutions.get(name = def.getName())) != null) {
            if (def.getContainingFile() != null && ApplicationManager.getApplication().isUnitTestMode()) {
                int defNum = def.getParameterNames().size();
                int ovNum = overridden.getParameterNames().size();
                boolean defVar = def.isVararg();
                boolean ovVar = overridden.isVararg();
                OCLog.LOG.assertTrue(defNum == ovNum, (Object)(def.getName() + ": overridden with " + ovNum + " params instead of " + defNum));
                OCLog.LOG.assertTrue(defVar == ovVar, (Object)(def.getName() + ": overridden with vararg=" + ovVar + " instead of " + defVar));
            }
            def = overridden;
        }
        this.revealDefinition(name);
        this.mySubstitutions.put(name, def);
        if (this.myChangeBuilder != null) {
            this.myChangeBuilder.define(name, def);
        }
    }

    @Override
    public void define(String def, String content) {
        this.define(new OCMacroSymbol(null, 0L, def, OCImmutableList.emptyList(), content));
    }

    @Override
    public void undef(String name) {
        this.hideDefinition(name);
        this.mySubstitutions.remove(name);
        if (this.myChangeBuilder != null) {
            this.myChangeBuilder.undef(name);
        }
    }

    @Override
    public void hideDefinition(@NotNull String name) {
        if (name == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(59);
        }
        this.myUndefList.add(name);
    }

    @Override
    public void revealDefinition(@NotNull String name) {
        if (name == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(60);
        }
        this.myUndefList.remove(name);
    }

    @Override
    public boolean isDefined(@Nullable String name, boolean isAlreadyInterned) {
        return this.getDefinition(name, OCImmutableInclusionContext.SignaturePart.HAS_DEFINITION, isAlreadyInterned) != null;
    }

    @Override
    @Nullable
    public OCMacroSymbol getDefinition(@Nullable String id, boolean isIdAlreadyInterned) {
        return this.getDefinition(id, OCImmutableInclusionContext.SignaturePart.EXACT_DEFINITION, isIdAlreadyInterned);
    }

    private void enterConformanceCheckMode() {
        if (this.mySignatureBuilder != null) {
            this.mySignatureBuilder.enterConformanceCheckMode();
        }
        if (this.myParentContext != null) {
            this.myParentContext.enterConformanceCheckMode();
        }
    }

    private void exitConformanceCheckMode(boolean commit) {
        if (this.mySignatureBuilder != null) {
            this.mySignatureBuilder.exitConformanceCheckMode(commit);
        }
        if (this.myParentContext != null) {
            this.myParentContext.exitConformanceCheckMode(commit);
        }
    }

    @Override
    @Nullable
    public OCMacroSymbol getDefinition(@Nullable String id, @NotNull OCImmutableInclusionContext.SignaturePart sp, boolean isIdAlreadyInterned) {
        OCMacroSymbol answer;
        boolean notify;
        if (sp == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(61);
        }
        if (id == null) {
            return null;
        }
        boolean bl = notify = sp != OCImmutableInclusionContext.SignaturePart.NO;
        if (this.myUndefList.contains(id)) {
            answer = null;
            notify = this.myNotifyLocalDefinitions;
        } else {
            OCMacroSymbol local = this.mySubstitutions.get(id);
            if (local != null) {
                answer = local;
                notify = this.myNotifyLocalDefinitions;
            } else {
                OCMacroSymbol oCMacroSymbol = this.myParentContext != null ? this.myParentContext.getDefinition(id, sp == OCImmutableInclusionContext.SignaturePart.HEADER_GUARD ? OCImmutableInclusionContext.SignaturePart.NO : sp, isIdAlreadyInterned) : (answer = null);
            }
        }
        if (notify && this.mySignatureBuilder != null) {
            switch (sp) {
                case HAS_DEFINITION: {
                    this.mySignatureBuilder.setDefined(isIdAlreadyInterned ? id : OCNamesInterner.intern((String)id), answer != null);
                    break;
                }
                case EXACT_DEFINITION: {
                    if (answer == null) break;
                    this.mySignatureBuilder.setDefinition(isIdAlreadyInterned ? id : OCNamesInterner.intern((String)id), answer);
                    break;
                }
                case HEADER_GUARD: {
                    this.mySignatureBuilder.setHeaderGuardDefined(id, answer != null);
                }
            }
        }
        return answer;
    }

    @Override
    public boolean isProcessed(@Nullable VirtualFile file) {
        return file != null && (this.myProcessedFiles.contains(file) || this.myParentContext != null && this.myParentContext.isProcessed(file));
    }

    @Override
    @NotNull
    public Set<VirtualFile> getProcessedFiles() {
        Set files = CollectionFactory.createSmallMemoryFootprintSet();
        this.collectProcessedFile(files);
        Set<VirtualFile> set = Collections.unmodifiableSet(files);
        if (set == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(62);
        }
        return set;
    }

    private void collectProcessedFile(Set<VirtualFile> result) {
        if (this.myParentContext != null) {
            this.myParentContext.collectProcessedFile(result);
        }
        result.addAll(this.myProcessedFiles);
    }

    @Override
    public void setSignatureBuilder(@Nullable OCInclusionContext.SignatureBuilder signatureBuilder) {
        this.mySignatureBuilder = signatureBuilder;
    }

    @Override
    public void enterNamespace(@NotNull String name) {
        if (name == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(63);
        }
        this.myCurrentNamespace.add(name);
    }

    @Override
    public void exitNamespace() {
        if (!this.myCurrentNamespace.isEmpty()) {
            this.myCurrentNamespace.remove(this.myCurrentNamespace.size() - 1);
        }
    }

    @Override
    @NotNull
    public List<String> getCurrentNamespace() {
        ArrayList<String> result = new ArrayList<String>(this.myCurrentNamespace.size());
        this.gatherCurrentNamespace(result);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(64);
        }
        return arrayList;
    }

    private void gatherCurrentNamespace(@NotNull List<String> result) {
        if (result == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(65);
        }
        if (this.myParentContext != null) {
            this.myParentContext.gatherCurrentNamespace(result);
        }
        result.addAll(this.myCurrentNamespace);
    }

    @Override
    @Nullable
    public VirtualFile resolvePath(@NotNull OCIncludeSymbol.IncludePath path, @NotNull VirtualFile contextFile, boolean isIncludeNext) {
        if (path == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(66);
        }
        if (contextFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(67);
        }
        return this.resolvePath(path, contextFile, isIncludeNext, true);
    }

    @Nullable
    private VirtualFile resolvePath(@NotNull OCIncludeSymbol.IncludePath path, @NotNull VirtualFile contextFile, boolean isIncludeNext, boolean notify) {
        if (path == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(68);
        }
        if (contextFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(69);
        }
        Ref result = new Ref();
        OCIncludeHelpers.resolveNextIncludedFile(this.getRootAndConfigurationWithCLanguageKind(), contextFile, (VirtualFile)(isIncludeNext ? contextFile : null), path, this.getProject(), (Ref<VirtualFile>)result);
        VirtualFile resolved = (VirtualFile)result.get();
        if (notify && this.myResolvePathListener != null) {
            this.myResolvePathListener.resolve(path, isIncludeNext, resolved);
        }
        return resolved;
    }

    @NotNull
    private OCResolveRootAndConfiguration getRootAndConfigurationWithCLanguageKind() {
        OCLanguageKind kind = this.myLanguageKind instanceof CLanguageKind || this.myLanguageKind instanceof CUDALanguageKind ? this.myLanguageKind : CLanguageKind.OBJ_C;
        return new OCResolveRootAndConfiguration(this.myConfiguration, kind, OCInclusionContextUtil.getVirtualFile(this.myRootFile));
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(70);
        }
        return project;
    }

    @Override
    @Nullable
    public OCResolveConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    public boolean reserveInclude(@NotNull VirtualFile file, boolean once) {
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(71);
        }
        if (file.isValid()) {
            String includeId = OCInclusionContextUtil.inclusionId(file);
            if (once && this.isDefined(includeId)) {
                return false;
            }
            String pragmaOnceId = OCInclusionContextUtil.pragmaOnceId(file);
            if (this.getDefinition(pragmaOnceId, OCImmutableInclusionContext.SignaturePart.NO) != null) {
                return false;
            }
            if (this.myAbortOnLanguageKindMismatch) {
                OCInclusionContextImpl.throwIfLanguageKindMismatch(this.myLanguageKind, this.myRootFile, file);
            }
            this.define(OCMacroSymbol.inclusionGuard(includeId));
        }
        return true;
    }

    private static void throwIfLanguageKindMismatch(@NotNull OCLanguageKind attemptedLanguageKind, @Nullable PsiFile rootFile, @NotNull VirtualFile includedFile) {
        if (attemptedLanguageKind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(72);
        }
        if (includedFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(73);
        }
        if (!(attemptedLanguageKind instanceof CLanguageKind) && !(attemptedLanguageKind instanceof CUDALanguageKind)) {
            return;
        }
        if (!attemptedLanguageKind.isObjC() && OCInclusionContextImpl.isObjcMainHeader(includedFile)) {
            OCLanguageKind requiredLanguageKind = CLanguageKind.find((boolean)true, (boolean)attemptedLanguageKind.isCpp(), (boolean)attemptedLanguageKind.isCuda());
            throw new OCInclusionContext.LanguageKindMismatchException(attemptedLanguageKind, requiredLanguageKind, rootFile, includedFile);
        }
    }

    private static boolean isObjcMainHeader(@Nullable VirtualFile segment) {
        for (int i2 = OBJC_MAIN_HEADER.length - 1; i2 >= 0; --i2) {
            if (segment == null || !FilePathHashingStrategy.INSTANCE.equals((Object)OBJC_MAIN_HEADER[i2], (Object)segment.getNameSequence())) {
                return false;
            }
            segment = segment.getParent();
        }
        return true;
    }

    @Override
    public void preprocessContextOf(@Nullable PsiFile root, @Nullable VirtualFile breakOn) {
        this.preprocessInclude(root, true, breakOn, this.myInclusionLevel);
    }

    @Override
    public void preprocessInclude(@Nullable PsiFile file, boolean once) {
        this.preprocessInclude(file, once, null, this.myInclusionLevel);
    }

    @Override
    public boolean preprocessInclude(@Nullable PsiFile file, boolean once, @Nullable VirtualFile breakOn, int inclusionLevel) {
        VirtualFile vFile = OCInclusionContextUtil.getVirtualFile(file);
        if (!OCInclusionContextUtil.isLongLived(vFile)) {
            return true;
        }
        return this.preprocessInclude(vFile, once, breakOn, inclusionLevel);
    }

    public boolean preprocessInclude(@NotNull VirtualFile vFile, boolean once, @Nullable VirtualFile breakOn) {
        if (vFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(74);
        }
        return this.preprocessInclude(vFile, once, breakOn, this.myInclusionLevel);
    }

    public boolean preprocessInclude(@NotNull VirtualFile vFile, boolean once, @Nullable VirtualFile breakOn, int inclusionLevel) {
        if (vFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(75);
        }
        if (inclusionLevel >= OCInclusionContext.getMaxInclusionLevel()) {
            return true;
        }
        if (!this.reserveInclude(vFile, once)) {
            return true;
        }
        this.addProcessedFile(vFile);
        FileSymbolTable table = FileSymbolTable.forFile(vFile, (OCInclusionContext)this);
        if (table != null && OCCodeInsightUtil.isPreProcessable(vFile, this.getProject())) {
            return this.preprocessFile(vFile, breakOn, inclusionLevel, -1, -1, table.getContents(), null) != null;
        }
        return true;
    }

    @Override
    @Contract(value="_, null, _, _, _, _, _ -> !null")
    public OCInclusionContext preprocessFile(@Nullable VirtualFile vFile, @Nullable VirtualFile breakOn, int inclusionLevel, int afterOffset, int beforeOffset, @NotNull List<OCSymbol> symbols, @Nullable OCContextChangeSet changeSet) {
        Builder builder2;
        if (symbols == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(76);
        }
        class Builder
        implements Processor<OCSymbol> {
            @NotNull
            private OCParsingNameScope myNameScope;
            @Nullable
            private final OCContextChangeBuilder myContextChangeBuilder;
            private boolean wasTruncated;
            final /* synthetic */ int val$afterOffset;
            final /* synthetic */ int val$beforeOffset;
            final /* synthetic */ VirtualFile val$vFile;
            final /* synthetic */ VirtualFile val$breakOn;
            final /* synthetic */ int val$inclusionLevel;
            final /* synthetic */ OCContextChangeSet val$changeSet;

            Builder(@Nullable OCParsingNameScope nameScope, OCContextChangeBuilder builder2) {
                if (nameScope == null) {
                    Builder.$$$reportNull$$$0(0);
                }
                this.val$afterOffset = n;
                this.val$beforeOffset = n2;
                this.val$vFile = virtualFile;
                this.val$breakOn = virtualFile2;
                this.val$inclusionLevel = n3;
                this.val$changeSet = oCContextChangeSet;
                this.myNameScope = nameScope;
                this.myContextChangeBuilder = builder2;
            }

            public boolean wasTruncated() {
                return this.wasTruncated;
            }

            @NotNull
            public OCParsingNameScope getNameScope() {
                OCParsingNameScope oCParsingNameScope = this.myNameScope;
                if (oCParsingNameScope == null) {
                    Builder.$$$reportNull$$$0(1);
                }
                return oCParsingNameScope;
            }

            public boolean process(OCSymbol symbol) {
                if (OCInclusionContextImpl.this.myProcessingListener != null) {
                    OCInclusionContextImpl.this.myProcessingListener.process((Object)symbol);
                }
                OCContextChangeBuilder changeBuilder = this.myContextChangeBuilder;
                if (symbol instanceof OCModuleImportSymbol) {
                    OCModuleImportSymbol importSymbol = (OCModuleImportSymbol)symbol;
                    Processor processor = header -> this.processFileInclude((VirtualFile)header, true, importSymbol.getEndOffset());
                    QualifiedName moduleName = importSymbol.getModuleName();
                    if (moduleName != null && !OCModuleResolver.processImportedHeaders(OCInclusionContextImpl.this, moduleName, (Processor<? super VirtualFile>)processor)) {
                        return false;
                    }
                } else if (symbol instanceof OCIncludeSymbol) {
                    OCIncludeSymbol include = (OCIncludeSymbol)symbol;
                    VirtualFile targetFile = include.getTargetFile();
                    include.enterNamespace(OCInclusionContextImpl.this);
                    if (!this.processFileInclude(targetFile, include.isOnce(), include.getEndOffset())) {
                        return false;
                    }
                    include.exitNamespace(OCInclusionContextImpl.this);
                } else if (symbol instanceof OCMacroSymbol) {
                    OCInclusionContextImpl.this.define((OCMacroSymbol)symbol);
                } else if (symbol instanceof OCUndefMacroSymbol) {
                    OCInclusionContextImpl.this.undef(symbol.getName());
                } else {
                    OCSymbolKind kind = symbol.getKind();
                    OCParsingNameScope resultNameScope = this.myNameScope;
                    if (symbol instanceof OCNamespaceSymbol) {
                        OCSymbol lastMember;
                        boolean interrupted;
                        OCParsingNameScope inner;
                        OCNamespaceSymbol namespaceSymbol = (OCNamespaceSymbol)symbol;
                        List<OCSymbol> members = namespaceSymbol.getMembersList();
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                            changeBuilder = null;
                        }
                        if (this.val$afterOffset != -1 && this.val$afterOffset > symbol.getOffset()) {
                            inner = this.myNameScope;
                        } else {
                            inner = this.myNameScope.defineNamespace(symbol.getName());
                            if (symbol instanceof OCStructSymbol) {
                                for (OCTypeParameterSymbol templateParam : ((OCStructSymbol)symbol).getTemplateParameters()) {
                                    if (templateParam instanceof OCTypeParameterTypeSymbol) {
                                        inner.defineType(templateParam.getName(), true);
                                        continue;
                                    }
                                    if (!(templateParam instanceof OCTypeParameterValueSymbol)) continue;
                                    inner.defineValue(templateParam.getName(), false);
                                }
                            }
                        }
                        OCInclusionContextImpl.this.enterNamespace(namespaceSymbol.getName());
                        Builder innerProcessor = new Builder(inner, null);
                        boolean bl = interrupted = !namespaceSymbol.processMembersAndUsings(innerProcessor, this.val$afterOffset, this.val$beforeOffset);
                        if (!interrupted) {
                            OCInclusionContextImpl.this.exitNamespace();
                        }
                        OCSymbol oCSymbol = lastMember = members != null ? (OCSymbol)ContainerUtil.getLastItem(members) : null;
                        if (this.val$beforeOffset != -1 && lastMember != null && this.val$beforeOffset <= lastMember.getOffset() || innerProcessor.wasTruncated()) {
                            this.wasTruncated = true;
                            resultNameScope = innerProcessor.getNameScope();
                        } else {
                            OCParsingNameScope scope = innerProcessor.getNameScope();
                            resultNameScope = scope.getParent();
                            if (resultNameScope == null) {
                                OCLog.LOG.error("no parent scope found for '" + symbol.getName() + "' (current scope is '" + scope + "')");
                            }
                        }
                    }
                    if (symbol instanceof OCUsingSymbol) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                            this.myNameScope.defineNamespaceUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                        } else {
                            this.myNameScope.defineSymbolUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                        }
                    } else if (kind.isType()) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        if (kind.isClass()) {
                            if (kind == OCSymbolKind.PROTOCOL) {
                                this.myNameScope.defineProtocol(symbol.getName());
                            } else {
                                this.myNameScope.defineInterface(symbol.getName());
                            }
                            if (symbol instanceof OCClassSymbol) {
                                ((OCClassSymbol)symbol).processMembers((String)null, new OCCommonProcessors.SelfAdapterProcessor(this));
                            }
                        } else if (kind.isClassOrTypedef() || OCInclusionContextImpl.this.myLanguageKind.isCpp()) {
                            boolean isTemplate = symbol instanceof OCTemplateSymbol && ((OCTemplateSymbol)symbol).isTemplateSymbol();
                            boolean isFriendClass = symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isFriend();
                            this.myNameScope.defineType(symbol.getName(), isTemplate, isFriendClass);
                        }
                        if (kind == OCSymbolKind.ENUM && symbol instanceof OCStructSymbol && !((OCStructSymbol)symbol).isEnumClass()) {
                            ((OCStructSymbol)symbol).processFields((Processor<? super OCDeclaratorSymbol>)((Processor)symbol1 -> {
                                this.myNameScope.defineValue(symbol1.getName(), false);
                                return true;
                            }));
                        }
                    } else if (symbol instanceof OCInstanceVariableSymbol) {
                        this.myNameScope.defineValue(symbol.getName(), false);
                    } else if (symbol instanceof OCConceptSymbol) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        this.myNameScope.defineConcept(symbol.getName());
                    } else if (symbol instanceof OCFunctionSymbol && !symbol.getKind().isConstructorOrDestructor() && ((OCFunctionSymbol)symbol).getQualifiedName().getQualifier() == null) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        this.myNameScope.defineValue(symbol.getName(), ((OCFunctionSymbol)symbol).isTemplateSymbol());
                    } else if (symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).getQualifiedName().getQualifier() == null) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        this.myNameScope.defineValue(symbol.getName(), ((OCDeclaratorSymbol)symbol).isTemplateSymbol());
                    } else if (symbol instanceof OCNamespaceAliasSymbol) {
                        OCSymbolReference namespace;
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        if ((namespace = ((OCNamespaceAliasSymbol)symbol).getNamespaceReference()) != null && namespace.getQualifiedName().getName() != null) {
                            this.myNameScope.defineNamespaceAlias(symbol.getName(), namespace.getQualifiedName().flatten());
                        }
                    }
                    this.myNameScope = resultNameScope;
                }
                return true;
            }

            protected boolean processFileInclude(@Nullable VirtualFile targetFile, boolean once, int endOffset) {
                assert (this.val$vFile != null);
                if (targetFile != null && targetFile.isValid() && OCCodeInsightUtil.isPreProcessable(targetFile, OCInclusionContextImpl.this.getProject())) {
                    if (targetFile.equals(this.val$breakOn)) {
                        return false;
                    }
                    if (!OCInclusionContextImpl.this.preprocessInclude(targetFile, once, this.val$breakOn, this.val$inclusionLevel + 1, endOffset, this.val$changeSet)) {
                        return false;
                    }
                    OCImportGraph.getInstance(OCInclusionContextImpl.this.getProject()).addHeaderIncluder(targetFile, this.val$vFile);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nameScope";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl$1Builder";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl$1Builder";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNameScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        if (OCResolveUtil.processSymbolsFromList(builder2 = new Builder(this.myNameScope, this.myChangeBuilder), symbols, afterOffset, beforeOffset)) {
            this.myNameScope = builder2.getNameScope();
            return this;
        }
        return null;
    }

    @Override
    public boolean preprocessInclude(@NotNull VirtualFile file, boolean once, @Nullable VirtualFile breakOn, int includeLevel, int offsetAfterInclude, @Nullable OCContextChangeSet changeSet) {
        boolean result;
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(77);
        }
        OCContextChangeBuilderImpl builder2 = null;
        OCContextChange change = null;
        if (changeSet != null && (change = changeSet.getChange(offsetAfterInclude)) == null) {
            builder2 = new OCContextChangeBuilderImpl(offsetAfterInclude);
            this.setChangeBuilder(builder2);
        }
        if (change == null) {
            result = this.preprocessInclude(file, once, breakOn, includeLevel);
        } else {
            change.apply(this);
            result = true;
        }
        if (builder2 != null && !this.isProcessed(OCInclusionContextUtil.getVirtualFile(this.myRootFile))) {
            changeSet.setChange(offsetAfterInclude, builder2);
            this.setChangeBuilder(null);
        }
        return result;
    }

    @TestOnly
    public DeepEqual.Equality<OCInclusionContextImpl> equality() {
        return new DeepEqual.Equality<OCInclusionContextImpl>(){

            @Override
            public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCInclusionContextImpl first, @NotNull OCInclusionContextImpl second) {
                if (c == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (first == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (second == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (first.myLanguageKind != second.myLanguageKind) {
                    return false;
                }
                if (first.myInclusionLevel != second.myInclusionLevel) {
                    return false;
                }
                if (!Comparing.equal((Object)first.myRootFile, (Object)second.myRootFile)) {
                    return false;
                }
                if (first.myNotifyLocalDefinitions != second.myNotifyLocalDefinitions) {
                    return false;
                }
                if (first.myConfiguration != second.myConfiguration) {
                    return false;
                }
                if (!first.myUndefList.equals(second.myUndefList)) {
                    return false;
                }
                if (!first.myProcessedFiles.equals(second.myProcessedFiles)) {
                    return false;
                }
                if (!Comparing.equal((Object)first.mySignatureBuilder, (Object)second.mySignatureBuilder)) {
                    return false;
                }
                if (!c.equalObjects(first.myParentContext, second.myParentContext)) {
                    return false;
                }
                if (!c.equalMaps(first.mySubstitutions, second.mySubstitutions)) {
                    return false;
                }
                return c.equalObjects(first.myNameScope, second.myNameScope);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "c";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "first";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "second";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl$1";
                objectArray[2] = "deepEqualStep";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @TestOnly
    public static void setDefaultMaxInclusionLevelInTests(@Nullable Integer level) {
        MAX_INCLUSION_LEVEL_IN_TESTS = level;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 18: 
            case 26: 
            case 31: 
            case 32: 
            case 36: 
            case 46: 
            case 47: 
            case 48: 
            case 53: 
            case 57: 
            case 62: 
            case 64: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 18: 
            case 26: 
            case 31: 
            case 32: 
            case 36: 
            case 46: 
            case 47: 
            case 48: 
            case 53: 
            case 57: 
            case 62: 
            case 64: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 16: 
            case 20: 
            case 23: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 18: 
            case 26: 
            case 31: 
            case 32: 
            case 36: 
            case 46: 
            case 47: 
            case 48: 
            case 53: 
            case 57: 
            case 62: 
            case 64: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: 
            case 41: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 8: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameScope";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 21: 
            case 24: 
            case 29: 
            case 35: 
            case 54: 
            case 71: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingFunction";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "precompiledHeaders";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 59: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sp";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attemptedLanguageKind";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedFile";
                break;
            }
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl";
                break;
            }
            case 3: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrecompiledHeaders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageKind";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyWithBuiltinMacros";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "initialContextWithoutRoot";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "initialPCHContextWithoutRoot";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewPCHContext";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewContext";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFile";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameScope";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveWithLanguageKind";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessedFiles";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentNamespace";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrecompiledHeaders";
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 18: 
            case 26: 
            case 31: 
            case 32: 
            case 36: 
            case 46: 
            case 47: 
            case 48: 
            case 53: 
            case 57: 
            case 62: 
            case 64: 
            case 70: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addProcessedFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkConformanceAndFillSignatures";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "emptyWithBuiltinMacros";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "initialContextWithoutRoot";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "initialPCHContextWithoutRoot";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createNewPCHContext";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createNewContext";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "cacheOrGet";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "initContext";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutions";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "conformsToByIncludes";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setPrecompiledHeaders";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findInCachedPCHPrecompiledContexts";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerFeature";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitution";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "derive";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "deriveWithLanguageKind";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "define";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "hideDefinition";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "revealDefinition";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getDefinition";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "enterNamespace";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "gatherCurrentNamespace";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "reserveInclude";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "throwIfLanguageKindMismatch";
                break;
            }
            case 74: 
            case 75: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "preprocessInclude";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "preprocessFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 18: 
            case 26: 
            case 31: 
            case 32: 
            case 36: 
            case 46: 
            case 47: 
            case 48: 
            case 53: 
            case 57: 
            case 62: 
            case 64: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class NameScopeInterner {
        private final ConcurrentMap<OCParsingNameScope, OCParsingNameScope> interner = ContainerUtil.createConcurrentWeakKeyWeakValueMap(OCParsingNameScope.HASHING_STRATEGY);

        NameScopeInterner() {
        }

        @NotNull
        OCParsingNameScope intern(@NotNull OCParsingNameScope nameScope) {
            if (nameScope == null) {
                NameScopeInterner.$$$reportNull$$$0(0);
            }
            OCParsingNameScope oCParsingNameScope = this.interner.computeIfAbsent(nameScope, Function.identity());
            if (oCParsingNameScope == null) {
                NameScopeInterner.$$$reportNull$$$0(1);
            }
            return oCParsingNameScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameScope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl$NameScopeInterner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl$NameScopeInterner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "intern";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class InitialPlainAndPchContexts {
        final ConcurrentMap<CompilerSettingsKey, OCInclusionContextImpl> switches2plainContext = new ConcurrentHashMap<CompilerSettingsKey, OCInclusionContextImpl>();
        final ConcurrentMap<CompilerSettingsKey, OCInclusionContextImpl> switches2PCHContext = new ConcurrentHashMap<CompilerSettingsKey, OCInclusionContextImpl>();

        InitialPlainAndPchContexts() {
        }
    }
}

