/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OCFileReference
extends FileReference {
    private static final Logger LOG = Logger.getInstance(OCFileReference.class);
    private final OCIncludeDirective myDirective;
    private final Project myProject;
    private String myIncludedFilePath;
    private boolean myRenameOnly;
    private OCAutoImportHelper.ImportSpecification myNewImportSpecification;
    private OCIncludeDirective.Delimiters myNewDelimiters;
    private OCResolveRootAndConfiguration myResolveRootAndConfiguration;

    public OCFileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text, @NotNull OCIncludeDirective directive, @NotNull Project project) {
        if (fileReferenceSet == null) {
            OCFileReference.$$$reportNull$$$0(0);
        }
        if (directive == null) {
            OCFileReference.$$$reportNull$$$0(1);
        }
        if (project == null) {
            OCFileReference.$$$reportNull$$$0(2);
        }
        super(fileReferenceSet, range, index, text);
        this.myIncludedFilePath = null;
        this.myRenameOnly = false;
        this.myNewImportSpecification = null;
        this.myNewDelimiters = null;
        this.myResolveRootAndConfiguration = null;
        this.myDirective = directive;
        this.myProject = project;
    }

    public void preprocessHeaderRootsAndActiveConfiguration() {
        VirtualFile targetFile;
        Application application = ApplicationManager.getApplication();
        LOG.assertTrue(application.isUnitTestMode() || !application.isDispatchThread());
        PsiFile includedPsiFile = this.myDirective.getIncludedFile();
        if (includedPsiFile != null) {
            VirtualFile includedVirtualFile = OCElementUtil.getFilePath(includedPsiFile);
            String string = this.myIncludedFilePath = includedVirtualFile != null ? includedVirtualFile.getPath() : null;
        }
        if ((targetFile = OCInclusionContextUtil.getVirtualFile(this.getContainingOCFile())) != null) {
            this.myResolveRootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(targetFile, this.myProject);
        }
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        String newFilePath;
        VirtualFile newVirtualFile;
        if (element == null) {
            OCFileReference.$$$reportNull$$$0(3);
        }
        if (this.myIncludedFilePath != null && element instanceof PsiFile && (newVirtualFile = OCElementUtil.getVirtualFile(element)) != null && !OCFileReference.shouldChangePath(PathUtil.getParentPath((String)(newFilePath = newVirtualFile.getPath())), PathUtil.getParentPath((String)this.myIncludedFilePath))) {
            this.myRenameOnly = true;
            return super.bindToElement(element, absolute);
        }
        class ImportProcessor
        implements Processor<OCAutoImportHelper.ImportSpecification> {
            public OCAutoImportHelper.ImportSpecification bestImportSpecification = null;
            public OCIncludeDirective.Delimiters bestDelimiters = null;
            public boolean exactMatch = false;
            public boolean renameOnly = false;

            ImportProcessor() {
            }

            public boolean process(OCAutoImportHelper.ImportSpecification specification) {
                OCIncludeDirective.Delimiters delimiters;
                assert (!this.exactMatch && !this.renameOnly);
                OCIncludeDirective.Delimiters currentDelimiters = OCFileReference.this.myDirective.getDelimiters();
                if (specification.areDelimitersAllowed(currentDelimiters)) {
                    if (!OCFileReference.shouldChangePath(specification.getImportPath(), OCFileReference.this.getReferenceText())) {
                        this.exactMatch = true;
                    } else if (!OCFileReference.shouldChangePath(PathUtil.getParentPath((String)specification.getImportPath()), PathUtil.getParentPath((String)OCFileReference.this.getReferenceText()))) {
                        this.renameOnly = true;
                    }
                    if (this.exactMatch || this.renameOnly) {
                        this.bestImportSpecification = specification;
                        this.bestDelimiters = currentDelimiters;
                        return false;
                    }
                }
                OCIncludeDirective.Delimiters delimiters2 = delimiters = specification.areDelimitersAllowed(currentDelimiters) ? currentDelimiters : specification.getPreferredDelimiters();
                if (this.bestImportSpecification == null || this.bestDelimiters != currentDelimiters && delimiters == currentDelimiters) {
                    this.bestImportSpecification = specification;
                    this.bestDelimiters = delimiters;
                }
                return true;
            }
        }
        ImportProcessor processor = new ImportProcessor();
        VirtualFile fileToImport = element instanceof PsiFile ? OCInclusionContextUtil.getVirtualFile((PsiFile)element) : null;
        VirtualFile targetFile = OCInclusionContextUtil.getVirtualFile(this.getContainingOCFile());
        if (OCInclusionContextUtil.isLongLived(fileToImport) && targetFile != null) {
            OCResolveRootAndConfiguration resolveRootAndConfiguration = this.getResolveRootAndConfiguration(targetFile);
            OCIncludeHelpers.processImportSpecifications(this.myProject, resolveRootAndConfiguration, targetFile, fileToImport, processor);
        }
        this.myRenameOnly = processor.renameOnly;
        if (processor.bestImportSpecification == null || processor.exactMatch) {
            return this.myDirective;
        }
        this.myNewImportSpecification = processor.bestImportSpecification;
        this.myNewDelimiters = processor.bestDelimiters;
        return super.bindToElement(element, absolute);
    }

    protected PsiElement rename(String newName) throws IncorrectOperationException {
        if (this.myRenameOnly) {
            return super.rename(this.myDirective.getDelimiters().getBeforeText() + this.getNewImportText(newName) + this.myDirective.getDelimiters().getAfterText());
        }
        if (this.myNewImportSpecification == null || this.myNewDelimiters == null) {
            OCLog.LOG.error("Invalid rename for include directive");
            return super.rename(newName);
        }
        return super.rename(this.myNewImportSpecification.getImportText(this.myNewDelimiters));
    }

    @NotNull
    private String getNewImportText(@NotNull String newName) {
        if (newName == null) {
            OCFileReference.$$$reportNull$$$0(4);
        }
        File oldFilePath = new File(this.getReferenceText());
        File newFilePath = new File(newName);
        String oldFileName = oldFilePath.getName();
        String newFileName = newFilePath.getName();
        int fileNameIndex = this.getReferenceText().lastIndexOf(oldFileName);
        if (fileNameIndex < 0) {
            LOG.error("Failed to rename import directive: ImportText: " + this.getReferenceText() + "; FileName: " + oldFileName + "; NewFileName: " + newFileName);
            String string = this.getReferenceText();
            if (string == null) {
                OCFileReference.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.getReferenceText().substring(0, fileNameIndex) + newFileName;
        if (string == null) {
            OCFileReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected ResolveResult @NotNull [] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        PsiFile file;
        OCIncludeSymbol include;
        if (containingFile == null) {
            OCFileReference.$$$reportNull$$$0(7);
        }
        if ((include = this.getContainingOCFile().findSymbol(this.myDirective, OCIncludeSymbol.class)) != null && include.getTargetFile() != null && include.getTargetFile().isValid() && (file = PsiManager.getInstance((Project)this.myProject).findFile(include.getTargetFile())) != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)file)};
            if (resolveResultArray == null) {
                OCFileReference.$$$reportNull$$$0(8);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = super.innerResolve(caseSensitive, containingFile);
        if (resolveResultArray == null) {
            OCFileReference.$$$reportNull$$$0(9);
        }
        return resolveResultArray;
    }

    protected Object createLookupItem(PsiElement candidate) {
        if (candidate instanceof PsiFile) {
            PsiFile file = (PsiFile)candidate;
            return new LookupElementDecorator<LookupElement>((LookupElement)FileInfoManager.getFileLookupItem((PsiElement)file, (String)file.getName(), (Icon)file.getIcon(0))){

                public boolean requiresCommittedDocuments() {
                    return false;
                }
            };
        }
        return super.createLookupItem(candidate);
    }

    @NotNull
    private OCResolveRootAndConfiguration getResolveRootAndConfiguration(@NotNull VirtualFile targetFile) {
        if (targetFile == null) {
            OCFileReference.$$$reportNull$$$0(10);
        }
        if (this.myResolveRootAndConfiguration != null) {
            OCResolveRootAndConfiguration oCResolveRootAndConfiguration = this.myResolveRootAndConfiguration;
            if (oCResolveRootAndConfiguration == null) {
                OCFileReference.$$$reportNull$$$0(11);
            }
            return oCResolveRootAndConfiguration;
        }
        OCResolveRootAndConfiguration oCResolveRootAndConfiguration = this.myResolveRootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(targetFile, this.myProject);
        if (oCResolveRootAndConfiguration == null) {
            OCFileReference.$$$reportNull$$$0(12);
        }
        return oCResolveRootAndConfiguration;
    }

    private OCFile getContainingOCFile() {
        return this.myDirective.getContainingOCFile();
    }

    private String getReferenceText() {
        return this.myDirective.getReferenceText();
    }

    private static boolean shouldChangePath(@NotNull String candidate, @NotNull String existing) {
        if (candidate == null) {
            OCFileReference.$$$reportNull$$$0(13);
        }
        if (existing == null) {
            OCFileReference.$$$reportNull$$$0(14);
        }
        return existing.contains("\\") || !FileUtil.toCanonicalPath((String)candidate, (boolean)false).equals(FileUtil.toCanonicalPath((String)existing, (boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directive";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCFileReference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCFileReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewImportText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveRootAndConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNewImportText";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getResolveRootAndConfiguration";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shouldChangePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

