/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddTypeModifierIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private OCElementType myModifier;
    private String mySubject;
    private boolean myProcessSameSymbols;

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbol symbol, OCElementType modifier, @NotNull Project project, @Nullable String subject, boolean processSameSymbols) {
        if (symbol == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(1);
        }
        super(project, symbol);
        this.myProcessSameSymbols = true;
        this.myModifier = modifier;
        this.mySubject = subject;
        this.myProcessSameSymbols = processSameSymbols;
    }

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbol symbol, OCElementType modifier, Project project, boolean processSameSymbols) {
        if (symbol == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(2);
        }
        this(symbol, modifier, project, symbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, project)), processSameSymbols);
    }

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbol symbol, OCElementType modifier, Project project) {
        if (symbol == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(3);
        }
        this(symbol, modifier, project, true);
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.name.add.type.modifier", this.mySubject, this.myModifier.getName());
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.add.modifier", this.myModifier.getName());
        if (string == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        if (!super.isAvailable()) {
            return false;
        }
        if (this.myModifier == OCTokenTypes.CONST_KEYWORD && (((OCDeclaratorSymbol)this.mySymbol).isConst() || this.mySymbol.getKind() == OCSymbolKind.ENUM_CONST)) {
            return false;
        }
        if (this.myModifier == OCTokenTypes.BLOCK_KEYWORD && (((OCDeclaratorSymbol)this.mySymbol).isBlockModifiable() || this.mySymbol.getKind() != OCSymbolKind.LOCAL_VARIABLE)) {
            return false;
        }
        if (this.myModifier == OCTokenTypes.VIRTUAL_CPP_KEYWORD && ((OCFunctionSymbol)this.mySymbol).isVirtual()) {
            return false;
        }
        return !this.mySymbol.getKind().isFunction() || this.myModifier != OCTokenTypes.STATIC_KEYWORD || !((OCFunctionSymbol)this.mySymbol).isVirtual();
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        if (project == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(5);
        }
        if (!OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition(project))) {
            return;
        }
        ArrayList nodesToUpdate = new ArrayList();
        Processor processor = symbol1 -> {
            PsiElement element = symbol1.locateDefinition(project);
            if (element == null || !(element.getParent() instanceof OCDeclaration)) {
                return true;
            }
            OCTypeElement typeElement = ((OCDeclaration)element.getParent()).getTypeElement();
            if (typeElement == null) {
                return true;
            }
            ASTNode typeNode = typeElement.getNode();
            if (typeNode != null && typeNode.getFirstChildNode() != null && typeNode.findChildByType((IElementType)this.myModifier) == null) {
                nodesToUpdate.add(typeNode);
            }
            return true;
        };
        if (this.myProcessSameSymbols) {
            this.mySymbol.processSameSymbols((Processor<OCSymbol>)processor, project);
        } else {
            processor.process((Object)this.mySymbol);
        }
        OCFile context = this.mySymbol.getContainingOCFile(project);
        for (ASTNode node : nodesToUpdate) {
            node.addChild(OCElementFactory.spaceFromText(context).getNode(), node.getFirstChildNode());
            OCChangeUtil.addChild(node, OCElementFactory.typeModifierFromText(this.myModifier.getName(), context), node.getFirstChildNode());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCAddTypeModifierIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCAddTypeModifierIntentionAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

