/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCChangeMethodSignatureIntentionAction
extends OCSymbolQuickFix<OCMethodSymbol> {
    @IntentionName
    private final String myText;
    private List<OCType> myNewParamTypes;
    private List<String> myNewSelectors;
    private List<OCExpression> myNewExpressions;

    public OCChangeMethodSignatureIntentionAction(@NotNull OCMethodSymbol methodSymbol, List<OCType> newParamTypes, List<String> newSelectors, List<OCExpression> newExpressions, @NotNull OCCompilationContext context) {
        if (methodSymbol == null) {
            OCChangeMethodSignatureIntentionAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCChangeMethodSignatureIntentionAction.$$$reportNull$$$0(1);
        }
        super(context.getProject(), methodSymbol);
        this.myNewParamTypes = newParamTypes;
        this.myNewSelectors = newSelectors;
        this.myNewExpressions = newExpressions;
        this.myText = OCInspectionsBundle.message("intention.name.add.parameters", ((OCMethodSymbol)this.mySymbol).getNameWithKindLowercase(context));
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.change.method.signature.add.parameters", new Object[0]);
        if (string == null) {
            OCChangeMethodSignatureIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        int i2;
        PsiElement method;
        if (project == null) {
            OCChangeMethodSignatureIntentionAction.$$$reportNull$$$0(3);
        }
        if (!((method = ((OCMethodSymbol)this.mySymbol).locateDefinition(project)) instanceof OCMethod)) {
            return;
        }
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCMethod)method, method, true);
        int oldSelectorsCnt = OCNameSuggester.isObjCGetter(((OCMethodSymbol)this.mySymbol).getName()) ? 0 : ((OCMethodSymbol)this.mySymbol).getSelectors().size();
        HashSet<String> prevParamNames = new HashSet<String>();
        for (i2 = 0; i2 < oldSelectorsCnt; ++i2) {
            OCDeclaratorSymbol parameter = ((OCMethodSymbol)this.mySymbol).getSelectors().get(i2).getParameter();
            if (parameter == null) continue;
            prevParamNames.add(parameter.getName());
        }
        for (i2 = oldSelectorsCnt; i2 < this.myNewSelectors.size(); ++i2) {
            String selector = this.myNewSelectors.get(i2);
            OCExpression expression = this.myNewExpressions.get(i2);
            String paramName = OCNameSuggester.suggestForParameter(prevParamNames, i2 == 0, selector, this.myNewParamTypes.get(i2), (OCMethodSymbol)this.mySymbol, expression, OCResolveContext.forPsi(method));
            prevParamNames.add(paramName);
            handler.addParameter(selector, paramName, this.myNewParamTypes.get(i2), -1, false);
        }
        handler.invokeSynchronously();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSymbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCChangeMethodSignatureIntentionAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCChangeMethodSignatureIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

