/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.ui;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.UsedByDependencyMemberInfoModel;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveCppProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveObjCProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.search.OCDirectInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCDirectStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPushDownDialog
extends OCAbstractMoveDialog {
    private static final int CHECKED_COLUMN = 0;
    private static final int INHERITOR_COLUMN = 1;
    private JBTable myInheritorsTable;
    private List<OCSymbol> myInheritors;
    private final Set<OCSymbol> myCheckedInheritors;
    private boolean myInheritorsCancelled;

    public OCPushDownDialog(@NotNull OCSymbolDeclarator clazz, OCSymbol classSymbol, Condition<PsiElement> selectedCondition) {
        if (clazz == null) {
            OCPushDownDialog.$$$reportNull$$$0(0);
        }
        super(clazz, classSymbol, selectedCondition, clazz.getProject());
        this.myCheckedInheritors = new HashSet<OCSymbol>();
        this.myMemberInfos = this.myStorage.getClassMemberInfos(clazz);
        this.setMembersChecked();
        this.setTitle(RefactoringBundle.message((String)"push.members.down.title"));
        this.findInheritors();
        this.init();
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.pushMembersDown";
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBInsets.create((int)4, (int)8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        panel2.add((Component)new JLabel(OCBundle.message("push.down.members.dialog", this.myClassSymbol.getNameWithKindLowercase(OCCompilationContext.create(this.mySourceFile)))), gbConstraints);
        this.myInheritorsTable = new JBTable();
        this.myInheritorsTable.setModel((TableModel)new MyModel());
        TableColumnModel columnModel = this.myInheritorsTable.getColumnModel();
        TableUtil.setupCheckboxColumn((TableColumn)columnModel.getColumn(0));
        columnModel.getColumn(1).setCellRenderer((TableCellRenderer)((Object)new MyTableRenderer()));
        this.myInheritorsTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)400, (int)-1));
        this.myInheritorsTable.setVisibleRowCount(4);
        this.myInheritorsTable.getSelectionModel().setSelectionMode(2);
        this.myInheritorsTable.setShowGrid(false);
        this.myInheritorsTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        new TableSpeedSearch((JTable)this.myInheritorsTable);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myInheritorsTable);
        ++gbConstraints.gridy;
        panel2.add((Component)scrollPane, gbConstraints);
        return panel2;
    }

    @Override
    @NlsContexts.Button
    protected String getOKButtonText() {
        return OCRefactoringBundle.message("refactoring.move.push.down.ok.button.text", new Object[0]);
    }

    @Override
    public boolean allowsEmptySelection() {
        return false;
    }

    @Override
    public void checkCanRun() throws ConfigurationException {
        super.checkCanRun();
        if (this.myCheckedInheritors.isEmpty()) {
            throw new ConfigurationException(OCRefactoringBundle.message("dialog.message.no.inheritors.are.selected", new Object[0]));
        }
    }

    public List<OCSymbol> getInheritors() {
        return this.myInheritors;
    }

    public boolean isInheritorsSearchCancelled() {
        return this.myInheritorsCancelled;
    }

    @Override
    protected MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> createModel() {
        return new UsedByDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCSymbolDeclarator, OCMemberInfo>(this.mySourceClass){

            public boolean isMemberEnabled(OCMemberInfo member) {
                return OCPushDownDialog.this.isMemberEnabled(member);
            }
        };
    }

    @Override
    protected String getConflictMessage(OCMemberInfo info, OCSymbol symbol) {
        return "Pushed code will be inaccessible from the " + symbol.getNameWithKindLowercase(OCCompilationContext.create(this.mySourceFile));
    }

    private void findInheritors() {
        Object inheritanceFinder = this.mySourceClass instanceof OCClassDeclaration ? () -> OCDirectInheritorsSearch.search((OCClassDeclaration)this.mySourceClass).findAll() : (this.mySourceClass instanceof OCStruct ? () -> OCDirectStructInheritorsSearch.search((OCStruct)this.mySourceClass).findAll() : null);
        if (inheritanceFinder != null) {
            this.myInheritorsCancelled = !ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.lambda$findInheritors$3((Computable)inheritanceFinder), OCBundle.message("push.down.dialog.searching.inheritors", new Object[0]), true, this.myProject);
        }
        this.myInheritors.sort(OCSymbol.PRESENTABLE_NAME_COMPARATOR);
        if (this.myInheritors != null && this.selectAllInheritors()) {
            this.myCheckedInheritors.addAll(this.myInheritors);
        }
    }

    protected boolean selectAllInheritors() {
        return this.myInheritors.size() == 1;
    }

    @Override
    @Nullable
    protected OCMoveProcessor createProcessor() {
        ArrayList<OCSymbol> inheritors = new ArrayList<OCSymbol>(this.myCheckedInheritors);
        inheritors.sort(OCSymbol.PRESENTABLE_NAME_COMPARATOR);
        if (this.mySourceClass instanceof OCClassDeclaration) {
            return new OCMoveObjCProcessor((OCClassDeclaration)this.mySourceClass, this.getSelectedMemberInfos(), null, inheritors){

                @NotNull
                protected String getCommandName() {
                    String string = OCPushDownDialog.this.getTitle();
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/move/ui/OCPushDownDialog$2", "getCommandName"));
                }
            };
        }
        if (this.mySourceClass instanceof OCStruct) {
            return new OCMoveCppProcessor((OCStruct)this.mySourceClass, this.getSelectedMemberInfos(), null, inheritors){

                @NotNull
                protected String getCommandName() {
                    String string = OCPushDownDialog.this.getTitle();
                    if (string == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/move/ui/OCPushDownDialog$3", "getCommandName"));
                }
            };
        }
        assert (false) : this.mySourceClass;
        return null;
    }

    private /* synthetic */ void lambda$findInheritors$3(Computable inheritanceFinder) {
        this.myInheritors = (List)ReadAction.compute(() -> new ArrayList((Collection)inheritanceFinder.compute()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/cidr/lang/refactoring/move/ui/OCPushDownDialog", "<init>"));
    }

    private class MyTableRenderer
    extends ColoredTableCellRenderer {
        private MyTableRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table == null) {
                MyTableRenderer.$$$reportNull$$$0(0);
            }
            int modelColumn = OCPushDownDialog.this.myInheritorsTable.convertColumnIndexToModel(column);
            OCSymbol inheritor = OCPushDownDialog.this.myInheritors.get(row);
            if (modelColumn == 1) {
                this.setIcon(inheritor.getIcon(OCPushDownDialog.this.myProject));
            } else {
                this.setIcon(null);
            }
            this.setIconOpaque(false);
            this.setOpaque(false);
            this.append((String)value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/cidr/lang/refactoring/move/ui/OCPushDownDialog$MyTableRenderer", "customizeCellRenderer"));
        }
    }

    private class MyModel
    extends AbstractTableModel {
        private MyModel() {
        }

        @Override
        public int getRowCount() {
            return OCPushDownDialog.this.myInheritors.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return OCSymbol.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            OCSymbol inheritor = OCPushDownDialog.this.myInheritors.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return OCPushDownDialog.this.myCheckedInheritors.contains(inheritor);
                }
                case 1: {
                    return inheritor.getPresentableName();
                }
            }
            throw new RuntimeException("Incorrect column index");
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (aValue == Boolean.TRUE) {
                    OCPushDownDialog.this.myCheckedInheritors.add(OCPushDownDialog.this.myInheritors.get(rowIndex));
                } else {
                    OCPushDownDialog.this.myCheckedInheritors.remove(OCPushDownDialog.this.myInheritors.get(rowIndex));
                }
                OCPushDownDialog.this.validateButtons();
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return OCRefactoringBundle.message("push.down.inheritor.column", new Object[0]);
                }
            }
            throw new RuntimeException("Incorrect column index");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }
    }
}

