/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMethodReferencesSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    private final boolean myFindAllPotentialCalls;

    public OCMethodReferencesSearch() {
        this(false);
    }

    public OCMethodReferencesSearch(boolean findPotentialAllPotentialCalls) {
        this.myFindAllPotentialCalls = findPotentialAllPotentialCalls;
    }

    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        if (queryParameters == null) {
            OCMethodReferencesSearch.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            OCMethodReferencesSearch.$$$reportNull$$$0(1);
        }
        return (Boolean)ReadAction.compute(() -> this.executeInReadAction(queryParameters, consumer));
    }

    private boolean executeInReadAction(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement element;
        if (queryParameters == null) {
            OCMethodReferencesSearch.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            OCMethodReferencesSearch.$$$reportNull$$$0(3);
        }
        if (!((element = queryParameters.getElementToSearch()) instanceof OCMethod)) {
            return true;
        }
        OCMethod method = (OCMethod)element;
        String searchWord = OCMethodReferencesSearch.getSearchWord(method);
        if (searchWord == null) {
            return true;
        }
        OCObjectType containingClassType = method.getContainingClass().getType();
        String methodSelector = method.getSelector();
        OCMethodSymbol methodSymbol = (OCMethodSymbol)method.getSymbol();
        if (!OCMethodReferencesSearch.processRefs(queryParameters, methodSymbol, method, containingClassType, methodSelector, searchWord, false, this.myFindAllPotentialCalls, consumer)) {
            return false;
        }
        String getterName = OCNameSuggester.getObjCGetterFromSetter(methodSelector);
        return StringUtil.isEmpty((String)getterName) || OCMethodReferencesSearch.processRefs(queryParameters, methodSymbol, method, containingClassType, getterName, getterName, true, this.myFindAllPotentialCalls, consumer);
    }

    public static boolean processRefs(@NotNull ReferencesSearch.SearchParameters queryParameters, @Nullable OCMethodSymbol symbol, @NotNull PsiElement method, @Nullable OCObjectType containingClassType, @NotNull String selector, @NotNull String searchWord, boolean setterMode, boolean findAllPotentialCalls, @NotNull Processor<? super PsiReference> consumer) {
        if (queryParameters == null) {
            OCMethodReferencesSearch.$$$reportNull$$$0(4);
        }
        if (method == null) {
            OCMethodReferencesSearch.$$$reportNull$$$0(5);
        }
        if (selector == null) {
            OCMethodReferencesSearch.$$$reportNull$$$0(6);
        }
        if (searchWord == null) {
            OCMethodReferencesSearch.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            OCMethodReferencesSearch.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)method.getProject());
        MyProcessor processor = new MyProcessor(method, symbol, selector, containingClassType, consumer, setterMode, findAllPotentialCalls);
        SearchScope effectiveSearchScope = queryParameters.getEffectiveSearchScope();
        return helper.processElementsWithWord((TextOccurenceProcessor)processor, effectiveSearchScope, searchWord, (short)1, true);
    }

    @Nullable
    private static String getSearchWord(@NotNull OCMethod method) {
        List<OCMethodSelectorPart> parts2;
        if (method == null) {
            OCMethodReferencesSearch.$$$reportNull$$$0(9);
        }
        if ((parts2 = method.getParameters()).isEmpty()) {
            return null;
        }
        String firstSelector = parts2.get(0).getSelectorPart();
        if (firstSelector == null) {
            return null;
        }
        String searchWord = StringUtil.trimEnd((String)firstSelector, (char)':');
        if (searchWord.isEmpty()) {
            return null;
        }
        return searchWord;
    }

    private static boolean isVirtualCall(@NotNull PsiReference ref) {
        PsiElement element;
        if (ref == null) {
            OCMethodReferencesSearch.$$$reportNull$$$0(10);
        }
        if (!((element = ref.getElement()) instanceof OCSendMessageExpression)) {
            return true;
        }
        OCExpression receiver = OCParenthesesUtils.diveIntoParentheses(((OCSendMessageExpression)element).getReceiverExpression());
        return !(receiver instanceof OCReferenceExpression) || ((OCReferenceExpression)receiver).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF;
    }

    @Nullable
    private static OCObjectTypeContext getReceiverContext(@NotNull PsiReference ref) {
        PsiElement element;
        if (ref == null) {
            OCMethodReferencesSearch.$$$reportNull$$$0(11);
        }
        if ((element = ref.getElement()) instanceof OCSendMessageExpression) {
            return ((OCSendMessageExpression)element).getReceiverContext();
        }
        if (element instanceof OCQualifiedExpression) {
            return ((OCQualifiedExpression)element).getQualifier().getTypeContext();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchWord";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/search/OCMethodReferencesSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInReadAction";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processRefs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getSearchWord";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isVirtualCall";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getReceiverContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyProcessor
    implements TextOccurenceProcessor {
        @NotNull
        private final PsiElement myMethod;
        @Nullable
        private final OCMethodSymbol mySymbol;
        @NotNull
        private final String myMethodSelector;
        @Nullable
        private final OCObjectType myType;
        @NotNull
        private final Processor<? super PsiReference> myConsumer;
        private final boolean myFindAllPotentialCalls;
        private final boolean mySetterMode;

        MyProcessor(@NotNull PsiElement method, @Nullable OCMethodSymbol symbol, @NotNull String methodSelector, @Nullable OCObjectType containingClassType, @NotNull Processor<? super PsiReference> consumer, boolean setterMode, boolean findAllPotentialCalls) {
            if (method == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            if (methodSelector == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            if (consumer == null) {
                MyProcessor.$$$reportNull$$$0(2);
            }
            this.mySetterMode = setterMode;
            this.myMethodSelector = methodSelector;
            this.myMethod = method;
            this.mySymbol = symbol;
            this.myConsumer = consumer;
            this.myFindAllPotentialCalls = findAllPotentialCalls;
            this.myType = containingClassType;
        }

        public boolean execute(@NotNull PsiElement element, int offsetInElement) {
            if (element == null) {
                MyProcessor.$$$reportNull$$$0(3);
            }
            String selector = null;
            if (element instanceof OCQualifiedExpression) {
                selector = ((OCQualifiedExpression)element).getName();
                OCExpression expression = OCParenthesesUtils.topmostParenthesized((OCExpression)element);
                if (expression.getParent() instanceof OCAssignmentExpression && ((OCAssignmentExpression)expression.getParent()).getReceiverExpression() == expression ? !this.mySetterMode : this.mySetterMode) {
                    return true;
                }
            } else if (this.mySetterMode) {
                return true;
            }
            if (element instanceof OCMessageArgument && offsetInElement == 0) {
                OCSendMessageExpression sendMessageExpression = (OCSendMessageExpression)element.getParent();
                if (sendMessageExpression.getArguments().get(0) == element) {
                    selector = sendMessageExpression.getMessageSelector();
                    element = sendMessageExpression;
                }
            } else if (element instanceof OCSelectorExpression) {
                selector = ((OCSelectorExpression)element).getSelector();
            } else if (element instanceof XmlTag) {
                selector = ((XmlTag)element).getValue().getText();
            } else if (element instanceof XmlAttributeValue) {
                selector = ((XmlAttributeValue)element).getValue();
            } else if (element.getParent() instanceof OCPropertyAttribute) {
                element = element.getParent();
                selector = ((OCPropertyAttribute)element).getValue();
            }
            if (this.myMethodSelector.equals(selector)) {
                for (PsiReference ref : element.getReferences()) {
                    OCObjectTypeContext receiverContext;
                    if (ref.isReferenceTo(this.myMethod)) {
                        return this.myConsumer.process((Object)ref);
                    }
                    if (this.myType == null || this.mySymbol == null || (receiverContext = OCMethodReferencesSearch.getReceiverContext(ref)) == null || !receiverContext.fitsStaticness(this.mySymbol)) continue;
                    OCObjectType receiverType = receiverContext.getType();
                    OCResolveContext context = OCResolveContext.forPsi(element);
                    if (this.myFindAllPotentialCalls && !OCMethodReferencesSearch.isVirtualCall(ref)) {
                        if (!receiverType.equalsAfterResolving(this.myType, context)) continue;
                        this.myConsumer.process((Object)ref);
                        continue;
                    }
                    if ((!this.myFindAllPotentialCalls || !receiverType.isCompatible(this.myType, context)) && (this.myFindAllPotentialCalls || !this.myType.isCompatible(receiverType, context))) continue;
                    return this.myConsumer.process((Object)ref);
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodSelector";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/search/OCMethodReferencesSearch$MyProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

