/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.search.OCDirectStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class OCStructInheritorsSearch
extends QueryFactory<OCStructSymbol, SearchParameters> {
    public static final OCStructInheritorsSearch INSTANCE = new OCStructInheritorsSearch();

    private OCStructInheritorsSearch() {
    }

    public static Query<OCStructSymbol> search(OCStruct struct) {
        Project project = struct.getProject();
        OCStructSymbol symbol = (OCStructSymbol)struct.getSymbol();
        OCQualifiedName structName = symbol != null ? symbol.getResolvedQualifiedName(OCResolveContext.forPsi(struct)) : null;
        return OCStructInheritorsSearch.search(structName, GlobalSearchScope.allScope((Project)project), struct.getContainingFile(), project);
    }

    public static Query<OCStructSymbol> search(OCStructSymbol struct, @NotNull PsiElement context) {
        if (context == null) {
            OCStructInheritorsSearch.$$$reportNull$$$0(0);
        }
        Project project = context.getProject();
        OCQualifiedName structName = struct.getResolvedQualifiedName(OCResolveContext.forPsi(context));
        return OCStructInheritorsSearch.search(structName, GlobalSearchScope.allScope((Project)project), context.getContainingFile(), project);
    }

    public static Query<OCStructSymbol> search(OCQualifiedName structName, GlobalSearchScope scope, PsiFile file, Project project) {
        return INSTANCE.createQuery(new SearchParameters(scope, structName, file, project));
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultExecutor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/search/OCStructInheritorsSearch", "search"));
    }

    private static class DefaultExecutor
    extends QueryExecutorBase<OCStructSymbol, SearchParameters> {
        private DefaultExecutor() {
        }

        public void processQuery(@NotNull SearchParameters p, @NotNull Processor<? super OCStructSymbol> consumer) {
            if (p == null) {
                DefaultExecutor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                DefaultExecutor.$$$reportNull$$$0(1);
            }
            GlobalSearchScope scope = p.getScope();
            Project project = p.getProject();
            Stack names = new Stack();
            HashSet<OCQualifiedName> processed = new HashSet<OCQualifiedName>();
            HashSet accepted = new HashSet();
            names.push((Object)p.getStructName());
            while (!names.isEmpty()) {
                ProgressManager.checkCanceled();
                OCQualifiedName name = (OCQualifiedName)names.pop();
                if (!processed.add(name)) continue;
                Query<OCStructSymbol> search = OCDirectStructInheritorsSearch.search(name, GlobalSearchScope.allScope((Project)project), p.getFile(), project);
                search.forEach(symbol -> {
                    OCQualifiedName qualifiedName = symbol.getResolvedQualifiedName(OCResolveContext.forSymbol(symbol, project));
                    names.push((Object)qualifiedName);
                    return !scope.contains(symbol.getContainingFile()) || !accepted.add(qualifiedName) || consumer.process(symbol);
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "p";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/search/OCStructInheritorsSearch$DefaultExecutor";
            objectArray[2] = "processQuery";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SearchParameters {
        private GlobalSearchScope myScope;
        private OCQualifiedName myStructName;
        private PsiFile myFile;
        private Project myProject;

        public SearchParameters(GlobalSearchScope scope, OCQualifiedName structName, PsiFile file, Project project) {
            this.myScope = scope;
            this.myStructName = structName;
            this.myFile = file;
            this.myProject = project;
        }

        public GlobalSearchScope getScope() {
            return this.myScope;
        }

        public OCQualifiedName getStructName() {
            return this.myStructName;
        }

        public PsiFile getFile() {
            return this.myFile;
        }

        public Project getProject() {
            return this.myProject;
        }
    }
}

