/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedNameImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInterner;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitorBase;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import icons.CidrLangIcons;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCClassSymbolImpl
extends OCSymbolWithQualifiedNameImpl
implements OCClassSymbol {
    @Nullable
    private String myCategoryName;
    @Nullable
    private MostlySingularMultiMap<String, OCMemberSymbol> myMembers;
    @NotNull
    private List<String> myProtocolNames;
    @Nullable
    private OCReferenceType mySuperType;

    /*
     * WARNING - void declaration
     */
    public OCClassSymbolImpl(@Nullable VirtualFile file, long offset, @NotNull String name, @NotNull List<String> attributes, @Nullable String categoryName, @Nullable MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull List<String> protocolNames, @Nullable OCReferenceType oCReferenceType) {
        void superType;
        if (name == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(1);
        }
        if (protocolNames == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(2);
        }
        super(file, offset, null, OCQualifiedName.interned(name), attributes, null);
        this.myCategoryName = OCNamesInterner.intern((String)categoryName);
        this.myMembers = members;
        this.myProtocolNames = protocolNames;
        this.mySuperType = superType;
    }

    public OCClassSymbolImpl() {
    }

    @Override
    @Nullable
    public String getCategoryName() {
        return this.myCategoryName;
    }

    public void setSuperType(@NotNull OCReferenceType type) {
        if (type == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(3);
        }
        assert (this.mySuperType == null) : "Super type is already set";
        this.mySuperType = type;
    }

    @Override
    @NotNull
    public OCReferenceType getSuperType() {
        assert (this.mySuperType != null) : "Super type has to be set in symbol builder";
        OCReferenceType oCReferenceType = this.mySuperType;
        if (oCReferenceType == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(4);
        }
        return oCReferenceType;
    }

    @Override
    @NotNull
    public OCTypeNameVisitorBase.DefaultArgumentsRemovalStrategy getDefaultArgumentsRemovalStrategy() {
        OCTypeNameVisitorBase.DefaultArgumentsRemovalStrategy defaultArgumentsRemovalStrategy = OCTypeNameVisitorBase.DefaultArgumentsRemovalStrategy.ALL_MATCH;
        if (defaultArgumentsRemovalStrategy == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(5);
        }
        return defaultArgumentsRemovalStrategy;
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
        super.updateOffset(start, lengthShift);
        OCSymbolOffsetUtil.updateOffset(this.myMembers, start, lengthShift);
    }

    @Override
    public void compact() {
        super.compact();
        OCNamespaceSymbol.compactMembersMultiMap(this.myMembers);
    }

    @Override
    @NotNull
    public List<String> getProtocolNames() {
        List<String> list = this.myProtocolNames;
        if (list == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public boolean isPredeclaration() {
        return this.myMembers == null;
    }

    @Override
    public int getMembersCount() {
        return this.myMembers != null ? this.myMembers.size() : 0;
    }

    @Override
    public int hashCodeExcludingOffset() {
        int result = super.hashCodeExcludingOffset();
        result = 31 * result + this.getMembersCount();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.getMembersCount() == ((OCClassSymbol)o).getMembersCount();
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(7);
        }
        if (first == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(8);
        }
        if (second == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(9);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCClassSymbolImpl f = (OCClassSymbolImpl)first;
        OCClassSymbolImpl s = (OCClassSymbolImpl)second;
        if (!Objects.equals(f.myCategoryName, s.myCategoryName)) {
            return false;
        }
        if (!Comparing.equal(f.myProtocolNames, s.myProtocolNames)) {
            return false;
        }
        if (!c.equalObjects(f.mySuperType, s.mySuperType)) {
            return false;
        }
        return c.equalMultiMaps(f.myMembers, s.myMembers);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(@Nullable @NonNls String memberName, @Nullable Class<? extends T> memberClass, @NotNull Processor<? super T> processor) {
        Processor myProcessor;
        if (processor == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(10);
        }
        if (this.myMembers == null) {
            return true;
        }
        Processor processor2 = myProcessor = memberClass != null ? member -> !memberClass.isAssignableFrom(member.getClass()) || processor.process(member) : processor;
        if (memberName == null) {
            return this.myMembers.processAllValues(myProcessor);
        }
        return this.myMembers.processForKey((Object)memberName, myProcessor);
    }

    public static boolean processAllMethods(@NotNull OCClassSymbol self, @Nullable String methodName, @NotNull Processor<OCMethodSymbol> processor, @Nullable Set<String> baseProtocols, @Nullable PsiElement context) {
        boolean isAmongBaseProtocols;
        if (self == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(12);
        }
        boolean bl = isAmongBaseProtocols = self instanceof OCProtocolSymbol && baseProtocols != null && baseProtocols.contains(self.getName());
        if (!self.processMembers(methodName, OCMethodSymbol.class, symbol -> isAmongBaseProtocols && !symbol.isOptional() || processor.process(symbol))) {
            return false;
        }
        if (isAmongBaseProtocols) {
            baseProtocols.addAll(self.getProtocolNames());
        }
        for (String protocolName : self.getProtocolNames()) {
            CommonProcessors.FindFirstProcessor<OCSymbol> resolver = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                protected boolean accept(OCSymbol symbol) {
                    return symbol instanceof OCProtocolSymbol && !symbol.isPredeclaration();
                }
            };
            OCResolveUtil.processGlobalSymbols(protocolName, context, (Processor<OCSymbol>)resolver);
            if (!resolver.isFound() || ((OCProtocolSymbol)resolver.getFoundValue()).processAllMethods(methodName, processor, baseProtocols, context)) continue;
            return false;
        }
        return true;
    }

    public static boolean processCategories(@NotNull OCClassSymbol self, @NotNull Processor<? super OCClassSymbol> processor, boolean fromSameParentClass, @Nullable PsiElement context, @NotNull Project project) {
        if (self == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(14);
        }
        if (project == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(15);
        }
        if (!processor.process((Object)self)) {
            return false;
        }
        Processor filterProcessor = symbol -> {
            if (!(!(symbol instanceof OCClassSymbol) || fromSameParentClass && !symbol.getClass().equals(self.getClass()) || symbol.isPredeclaration() || symbol.equals(self))) {
                return processor.process((Object)((OCClassSymbol)symbol));
            }
            return true;
        };
        if (context == null) {
            return OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, (Processor<? super OCSymbol>)filterProcessor, self.getName());
        }
        return OCResolveUtil.processGlobalSymbols(self.getName(), null, context.getContainingFile(), self.getOffset(), (Processor<OCSymbol>)filterProcessor);
    }

    @Override
    public boolean processSameSymbols(@NotNull Processor<OCSymbol> processor, @NotNull Project project) {
        if (processor == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(16);
        }
        if (project == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(17);
        }
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, (Processor<? super OCSymbol>)((Processor)symbol -> !this.isSameSymbol((OCSymbol)symbol, project) || processor.process(symbol)), this.getName());
    }

    @Override
    @Nullable
    public OCClassSymbol getDefinitionSymbol(@NotNull Project project) {
        if (project == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(18);
        }
        return (OCClassSymbol)super.getDefinitionSymbol(project);
    }

    @Nullable
    protected MostlySingularMultiMap<String, OCMemberSymbol> getMembers() {
        return this.myMembers;
    }

    @Nullable
    public static <T extends OCClassSymbol> T getMainSymbol(@NotNull OCClassSymbol self, @Nullable T symbol, @NotNull Project project) {
        if (self == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(19);
        }
        if (project == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(20);
        }
        if (symbol == null) {
            return null;
        }
        if (self.getCategoryName() == null) {
            return symbol;
        }
        CommonProcessors.FindFirstProcessor<OCClassSymbol> finder = new CommonProcessors.FindFirstProcessor<OCClassSymbol>(){

            protected boolean accept(OCClassSymbol each) {
                return each.getCategoryName() == null;
            }
        };
        symbol.processCategories((Processor<OCClassSymbol>)finder, true, null, project);
        return (T)((OCClassSymbol)finder.getFoundValue());
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.myCategoryName == null ? super.getBaseIcon() : CidrLangIcons.CodeAssistantClassExtension;
    }

    @Override
    public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project) {
        Icon result;
        if (project == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(21);
        }
        Icon icon = result = this.myCategoryName == null ? super.computeFullIconNow(symbolElement, project) : CidrLangIcons.CodeAssistantClassExtension;
        if (result == null) {
            return null;
        }
        return OCTestFrameworks.isTestClassOrStruct(this, symbolElement, project) ? OCIcons.getTestIcon(result) : result;
    }

    @Override
    @Nullable
    public OCObjectType getResolvedType(@NotNull OCResolveContext context, boolean ignoringImports) {
        OCType type;
        if (context == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(22);
        }
        return (type = super.getResolvedType(context, ignoringImports)) instanceof OCObjectType ? (OCObjectType)type : null;
    }

    @Override
    public boolean isSameSymbol(OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(23);
        }
        return symbol instanceof OCClassSymbol && this.isSameClass((OCClassSymbol)symbol);
    }

    public static boolean isSameCategory(@NotNull OCClassSymbol self, @Nullable OCSymbol symbol) {
        if (self == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(24);
        }
        if (symbol instanceof OCClassSymbol && self.getName().equals(symbol.getName())) {
            String myCategory = StringUtil.notNullize((String)self.getCategoryName());
            String hisCategory = ((OCClassSymbol)symbol).getCategoryName() == null ? "" : ((OCClassSymbol)symbol).getCategoryName();
            return myCategory.equals(hisCategory);
        }
        return false;
    }

    public static boolean isSubclass(@NotNull OCClassSymbol symbol, final @NotNull OCClassSymbol ancestor, final @NotNull Project project) {
        if (symbol == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(25);
        }
        if (ancestor == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(26);
        }
        if (project == null) {
            OCClassSymbolImpl.$$$reportNull$$$0(27);
        }
        final String ancestorName = ancestor.getName();
        if (symbol.isSameClass(ancestor) || ancestorName.equals("id")) {
            return true;
        }
        boolean ancestorIsInLibraries = OCSearchScope.isInLibraries(ancestor, project);
        if (!ancestorIsInLibraries && ancestor.getCategoryName() != null) {
            OCInterfaceSymbol mainInterface = ancestor.getMainInterface(project);
            ancestorIsInLibraries = OCSearchScope.isInLibraries(mainInterface, project);
        }
        class DFS {
            final Set<OCClassSymbol> processedClasses = new HashSet<OCClassSymbol>();
            final Stack<OCClassSymbol> stack = new Stack();
            boolean wasProcessed;

            DFS() {
            }

            <T extends OCClassSymbol> boolean traverse(String name, Class<T> clazz) {
                if (name.equals(ancestorName) && clazz == OCProtocolSymbol.class == ancestor instanceof OCProtocolSymbol) {
                    return true;
                }
                this.wasProcessed = false;
                OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, new OCCommonProcessors.TypeFilteredProcessor(t -> {
                    if (!t.isPredeclaration()) {
                        this.wasProcessed = true;
                        if (!this.processedClasses.contains(t)) {
                            this.processedClasses.add((OCClassSymbol)t);
                            this.stack.push(t);
                        }
                    }
                    return true;
                }, clazz), name);
                return false;
            }
        }
        DFS dfs = new DFS();
        if (symbol instanceof OCProtocolSymbol) {
            if (dfs.traverse(symbol.getName(), OCProtocolSymbol.class)) {
                return true;
            }
        } else {
            if (dfs.traverse(symbol.getName(), OCInterfaceSymbol.class)) {
                return true;
            }
            if (!dfs.wasProcessed && dfs.traverse(symbol.getName(), OCImplementationSymbol.class)) {
                return true;
            }
        }
        while (!dfs.stack.isEmpty()) {
            OCClassSymbol curClass = (OCClassSymbol)dfs.stack.pop();
            if (!ancestorIsInLibraries && OCSearchScope.isInLibraries(curClass, project)) continue;
            if (curClass instanceof OCInterfaceSymbol || curClass instanceof OCImplementationSymbol) {
                if (dfs.traverse(curClass.getSuperClassName(), OCInterfaceSymbol.class)) {
                    return true;
                }
                if (!dfs.wasProcessed && dfs.traverse(curClass.getSuperClassName(), OCImplementationSymbol.class)) {
                    return true;
                }
            }
            for (String protocolName : curClass.getProtocolNames()) {
                if (!dfs.traverse(protocolName, OCProtocolSymbol.class)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocolNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 13: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/objc/OCClassSymbolImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultArgumentsRemovalStrategy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocolNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSuperType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processAllMethods";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processCategories";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processSameSymbols";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionSymbol";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMainSymbol";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeFullIconNow";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isSameSymbol";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isSameCategory";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isSubclass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

