/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTableBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCSymbolBuildingActivity {
    public static void build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        List sourceFilesToIndex;
        if (indicator == null) {
            OCSymbolBuildingActivity.$$$reportNull$$$0(0);
        }
        if (userData == null) {
            OCSymbolBuildingActivity.$$$reportNull$$$0(1);
        }
        Project project = userData.getProject();
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
        OCSymbolTablesBuildingActivity.Mode mode = userData.getMode();
        ArrayList<VirtualFile> loadedFiles = new ArrayList<VirtualFile>(cache.getCachedFiles());
        indicator.checkCanceled();
        indicator.setText(loadedFiles.isEmpty() ? OCBundle.message("symbol.table.activity.building.symbols", new Object[0]) : OCBundle.message("symbol.table.activity.updating.symbols", new Object[0]));
        indicator.startTiming("Building symbols");
        List sourceFiles = Objects.requireNonNull(userData.getSourceFiles());
        Collection<VirtualFile> allFiles = Objects.requireNonNull(userData.getAllFiles());
        double savingFraction = Objects.requireNonNull(userData.getSavingFraction());
        if (mode == OCSymbolTablesBuildingActivity.Mode.COMPACT) {
            sourceFilesToIndex = sourceFiles;
        } else {
            HashSet<VirtualFile> filesWithOwnTables = new HashSet<VirtualFile>(cache.getFilesWithNonFallbackTables(false));
            sourceFilesToIndex = ContainerUtil.findAll(sourceFiles, file -> !filesWithOwnTables.contains(file));
        }
        @NonNls String buildFilesDescription = sourceFilesToIndex.size() + " source files";
        OCLog.LOG.info("Building symbols for " + buildFilesDescription);
        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "processBuildFiles", (Object)buildFilesDescription);){
            double sourcePart = sourceFilesToIndex.size();
            double headerWithoutTablesCount = allFiles.size() - sourceFiles.size();
            double headersPart = headerWithoutTablesCount * 0.2;
            double loadedFraction = Objects.requireNonNull(userData.getLoadedFraction());
            double sourceFraction = loadedFraction + (savingFraction - loadedFraction) * (sourcePart / Math.max(sourcePart + headersPart, 1.0));
            OCSymbolTableBuilder builder2 = new OCSymbolTableBuilder(project, indicator, sourceFilesToIndex, false);
            builder2.processBuildFiles(loadedFraction, sourceFraction);
        }
        indicator.checkCanceled();
        HashSet<VirtualFile> headersWithoutTables = new HashSet<VirtualFile>(allFiles);
        headersWithoutTables.removeAll(cache.getFilesWithNonFallbackTables(mode == OCSymbolTablesBuildingActivity.Mode.COMPACT));
        @NonNls String headerFilesDescription = headersWithoutTables.size() + " unused headers";
        OCLog.LOG.info("Building symbols for " + headerFilesDescription);
        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "processBuildFiles", (Object)headerFilesDescription);){
            OCSymbolTableBuilder builder3 = new OCSymbolTableBuilder(project, indicator, headersWithoutTables, true);
            builder3.processBuildFiles(indicator.getFraction(), savingFraction);
            indicator.logTiming();
        }
        OCSymbolTablesBuildingActivity.getInstance(project).notifySymbolsAreLoadedAndReparseCachedFiles(indicator);
        @NonNls String allFilesDescription = allFiles.size() + " project files";
        OCLog.LOG.info("Building symbols in " + userData.getMode().name() + " mode, " + sourceFiles.size() + " source files from total " + allFilesDescription);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "indicator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "userData";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolBuildingActivity";
        objectArray[2] = "build";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

