/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded.iar;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IarMessagesConsoleFilter
implements Filter {
    private static final Pattern ourErrorPattern = Pattern.compile("^(?<skip>\\s*)(?:\"(?<filename>.*)\",(?<line>\\d+)\\s+)?(?<severity>Remark|Warning|Error|Fatal error)\\[(?<tag>\\w+)]:(?<message>.*)\\s*");
    private static final Pattern ourColumnPattern = Pattern.compile("^(\\s*)\\^\\s*$");
    private static final Pattern ourNestedErrorPattern = Pattern.compile("\\(declared\\s+at\\s+line\\s+(?<line>\\d+)\\s+of\\s+\"(?<filename>.+)\"\\)", 8);
    @NotNull
    private final EditorColorsScheme myColorsScheme;
    private final Project myProject;
    private int myLastErrorColumnPosition;
    private int myLastTextStart;
    private int myLastSkipSpaces;
    private final StringBuilder myAccumulatedErrorMessage;
    private TextAttributes myLastSeverityAttributes;

    IarMessagesConsoleFilter(@NotNull Project project, @NotNull EditorColorsScheme colorsScheme) {
        if (project == null) {
            IarMessagesConsoleFilter.$$$reportNull$$$0(0);
        }
        if (colorsScheme == null) {
            IarMessagesConsoleFilter.$$$reportNull$$$0(1);
        }
        this.myLastErrorColumnPosition = -1;
        this.myLastTextStart = 0;
        this.myLastSkipSpaces = 0;
        this.myAccumulatedErrorMessage = new StringBuilder();
        this.myLastSeverityAttributes = null;
        this.myProject = project;
        this.myColorsScheme = colorsScheme;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String logLine, int entireLength) {
        if (logLine == null) {
            IarMessagesConsoleFilter.$$$reportNull$$$0(2);
        }
        Matcher columnMatcher = ourColumnPattern.matcher(logLine);
        int baseLength = entireLength - logLine.length();
        if (columnMatcher.matches()) {
            String position = columnMatcher.group(1);
            this.myLastErrorColumnPosition = position != null ? position.length() - 2 : -1;
            return null;
        }
        Matcher errorMatcher = ourErrorPattern.matcher(logLine);
        if (errorMatcher.matches()) {
            VirtualFile file;
            this.myLastSkipSpaces = Math.max(0, errorMatcher.end("skip"));
            String filename = errorMatcher.group("filename");
            int line = Integer.parseInt(Objects.toString(errorMatcher.group("line"), "0")) - 1;
            String severity = Objects.toString(errorMatcher.group("severity"), "");
            this.myLastSeverityAttributes = this.severityTextAttribute(severity);
            Filter.Result result = new Filter.Result(this.myLastTextStart, entireLength, null, this.myLastSeverityAttributes);
            this.myLastTextStart = entireLength;
            VirtualFile virtualFile = file = filename == null ? null : this.createVirtualFile(filename);
            if (file != null) {
                OpenFileHyperlinkInfo hyperlinkInfo = new OpenFileHyperlinkInfo(this.myProject, file, line, this.myLastErrorColumnPosition - this.myLastSkipSpaces);
                Filter.Result gotoFileResult = new Filter.Result(baseLength + errorMatcher.start("filename") - 1, baseLength + errorMatcher.end("line"), (HyperlinkInfo)hyperlinkInfo);
                this.myLastErrorColumnPosition = -1;
                this.myAccumulatedErrorMessage.setLength(0);
                SmartList results = new SmartList((Object[])new Filter.Result[]{result, gotoFileResult});
                Filter.Result nestedError = this.findNestedError(logLine, entireLength);
                if (nestedError != null) {
                    results.add((Object)nestedError);
                }
                return new Filter.Result((List)results);
            }
            return result;
        }
        this.myLastTextStart = baseLength;
        if (this.myLastSeverityAttributes != null) {
            if (this.myLastSkipSpaces < logLine.length() && logLine.charAt(this.myLastSkipSpaces) == ' ') {
                Filter.Result wholeMessageResult = new Filter.Result(baseLength, entireLength, null, this.myLastSeverityAttributes);
                Filter.Result nestedResult = this.findNestedError(logLine, entireLength);
                return nestedResult == null ? wholeMessageResult : new Filter.Result(Arrays.asList(wholeMessageResult, nestedResult));
            }
            this.myLastSkipSpaces = 0;
            this.myLastSeverityAttributes = null;
            this.myAccumulatedErrorMessage.setLength(0);
        }
        return null;
    }

    private Filter.Result findNestedError(@NotNull String logLine, int entireLength) {
        VirtualFile file;
        if (logLine == null) {
            IarMessagesConsoleFilter.$$$reportNull$$$0(3);
        }
        this.myAccumulatedErrorMessage.append(logLine);
        Matcher matcher = ourNestedErrorPattern.matcher(this.myAccumulatedErrorMessage);
        if (!matcher.find()) {
            return null;
        }
        String filename = matcher.group("filename");
        VirtualFile virtualFile = file = filename == null ? null : this.createVirtualFile(filename);
        if (file == null) {
            return null;
        }
        int line = Integer.parseInt(Objects.toString(matcher.group("line"), "0")) - 1;
        OpenFileHyperlinkInfo hyperlinkInfo = new OpenFileHyperlinkInfo(this.myProject, file, line);
        int start = entireLength - this.myAccumulatedErrorMessage.length() + matcher.start("filename");
        int end = entireLength - this.myAccumulatedErrorMessage.length() + matcher.end("filename");
        this.myAccumulatedErrorMessage.setLength(0);
        return new Filter.Result(Math.max(0, start), end, (HyperlinkInfo)hyperlinkInfo);
    }

    @Nullable
    VirtualFile createVirtualFile(@NotNull String filename) {
        if (filename == null) {
            IarMessagesConsoleFilter.$$$reportNull$$$0(4);
        }
        return VfsUtil.findFile((Path)Paths.get(filename, new String[0]), (boolean)true);
    }

    private TextAttributes severityTextAttribute(String severity) {
        TextAttributesKey attributesKey;
        switch (severity) {
            case "Remark": {
                attributesKey = ConsoleViewContentType.LOG_INFO_OUTPUT_KEY;
                break;
            }
            case "Warning": {
                attributesKey = ConsoleViewContentType.LOG_WARNING_OUTPUT_KEY;
                break;
            }
            default: {
                attributesKey = ConsoleViewContentType.LOG_ERROR_OUTPUT_KEY;
            }
        }
        return this.myColorsScheme.getAttributes(attributesKey);
    }

    public static void collectWarnings(@NotNull String stderr, @NotNull List<String> warnings) {
        if (stderr == null) {
            IarMessagesConsoleFilter.$$$reportNull$$$0(5);
        }
        if (warnings == null) {
            IarMessagesConsoleFilter.$$$reportNull$$$0(6);
        }
        for (String s : StringUtil.splitByLinesDontTrim((String)stderr)) {
            Matcher matcher = ourErrorPattern.matcher(s);
            if (!matcher.matches() || !"Warning".equals(matcher.group("severity"))) continue;
            warnings.add(matcher.group());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stderr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnings";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/embedded/iar/IarMessagesConsoleFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findNestedError";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createVirtualFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "collectWarnings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

