/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.diagnostic.LoggerRt;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.Searcher;
import org.jetbrains.plugins.textmate.regex.StringWithId;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.exception.JOniException;

public final class RegexFacade {
    private static final Regex FAILED_REGEX = new Regex("^$", (Encoding)UTF8Encoding.INSTANCE);
    private static final LoggerRt LOGGER = LoggerRt.getInstance(RegexFacade.class);
    @NotNull
    private final Regex myRegex;
    private final boolean hasGMatch;
    private final ThreadLocal<LastMatch> matchResult;
    private static final Cache<String, RegexFacade> REGEX_CACHE = Caffeine.newBuilder().maximumSize(100000L).expireAfterAccess(1L, TimeUnit.MINUTES).build();

    private RegexFacade(@NotNull String regexString) {
        Regex regex;
        if (regexString == null) {
            RegexFacade.$$$reportNull$$$0(0);
        }
        this.matchResult = new ThreadLocal();
        byte[] bytes = regexString.getBytes(StandardCharsets.UTF_8);
        try {
            regex = new Regex(bytes, 0, bytes.length, 256, (Encoding)UTF8Encoding.INSTANCE);
        }
        catch (JOniException e) {
            LOGGER.info("Failed to parse textmate regex", (Throwable)e);
            regex = FAILED_REGEX;
        }
        this.hasGMatch = regexString.contains("\\G");
        this.myRegex = regex;
    }

    public MatchData match(StringWithId string, @Nullable Runnable checkCancelledCallback) {
        return this.match(string, 0, 0, true, checkCancelledCallback);
    }

    public MatchData match(@NotNull StringWithId string, int byteOffset, int gosOffset, boolean matchBeginOfString, @Nullable Runnable checkCancelledCallback) {
        Matcher matcher;
        int matchIndex;
        MatchData lastMatch;
        if (string == null) {
            RegexFacade.$$$reportNull$$$0(1);
        }
        gosOffset = gosOffset >= 0 ? gosOffset : byteOffset;
        int options = matchBeginOfString ? 0 : 65536;
        LastMatch lastResult = this.matchResult.get();
        Object lastId = lastResult != null ? lastResult.lastId : null;
        int lastOffset = lastResult != null ? lastResult.lastOffset : Integer.MAX_VALUE;
        int lastGosOffset = lastResult != null ? lastResult.lastGosOffset : -1;
        int lastOptions = lastResult != null ? lastResult.lastOptions : -1;
        MatchData matchData = lastMatch = lastResult != null ? lastResult.lastMatch : MatchData.NOT_MATCHED;
        if (!(lastId != string.id || lastOffset > byteOffset || lastOptions != options || this.hasGMatch && lastGosOffset != gosOffset || lastMatch.matched() && lastMatch.byteOffset().start < byteOffset)) {
            RegexFacade.checkMatched(lastMatch, string);
            return lastMatch;
        }
        if (checkCancelledCallback != null) {
            checkCancelledCallback.run();
        }
        MatchData matchData2 = (matchIndex = (matcher = this.myRegex.matcher(string.bytes)).search(gosOffset, byteOffset, string.bytes.length, options)) > -1 ? MatchData.fromRegion(matcher.getEagerRegion()) : MatchData.NOT_MATCHED;
        RegexFacade.checkMatched(matchData2, string);
        this.matchResult.set(new LastMatch(string.id, byteOffset, gosOffset, options, matchData2));
        return matchData2;
    }

    private static void checkMatched(MatchData match, StringWithId string) {
        if (match.matched() && match.byteOffset().end > string.bytes.length) {
            throw new IllegalStateException("Match data out of bounds: " + match.byteOffset().start + " > " + string.bytes.length + "\n" + new String(string.bytes, StandardCharsets.UTF_8));
        }
    }

    public Searcher searcher(byte[] stringBytes) {
        return new Searcher(stringBytes, this.myRegex.matcher(stringBytes, 0, stringBytes.length));
    }

    @NotNull
    public static RegexFacade regex(@NotNull String regexString) {
        if (regexString == null) {
            RegexFacade.$$$reportNull$$$0(2);
        }
        RegexFacade regexFacade = (RegexFacade)REGEX_CACHE.get((Object)regexString, RegexFacade::new);
        if (regexFacade == null) {
            RegexFacade.$$$reportNull$$$0(3);
        }
        return regexFacade;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/regex/RegexFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/regex/RegexFacade";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "regex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "regex";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LastMatch {
        private final Object lastId;
        private final int lastOffset;
        private final int lastGosOffset;
        private final int lastOptions;
        private final MatchData lastMatch;

        private LastMatch(Object id, int offset, int gosOffset, int options, MatchData data) {
            this.lastId = id;
            this.lastOffset = offset;
            this.lastGosOffset = gosOffset;
            this.lastOptions = options;
            this.lastMatch = data;
        }
    }
}

