/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.s3.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gradle.internal.impldep.com.amazonaws.annotation.SdkInternalApi;
import org.gradle.internal.impldep.com.amazonaws.services.s3.AmazonS3;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.HeadBucketRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.HeadBucketResult;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ObjectMetadata;
import org.gradle.internal.impldep.com.amazonaws.services.s3.waiters.HeadBucketFunction;
import org.gradle.internal.impldep.com.amazonaws.services.s3.waiters.HeadObjectFunction;
import org.gradle.internal.impldep.com.amazonaws.waiters.FixedDelayStrategy;
import org.gradle.internal.impldep.com.amazonaws.waiters.HttpFailureStatusAcceptor;
import org.gradle.internal.impldep.com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import org.gradle.internal.impldep.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import org.gradle.internal.impldep.com.amazonaws.waiters.PollingStrategy;
import org.gradle.internal.impldep.com.amazonaws.waiters.Waiter;
import org.gradle.internal.impldep.com.amazonaws.waiters.WaiterBuilder;
import org.gradle.internal.impldep.com.amazonaws.waiters.WaiterState;

public class AmazonS3Waiters {
    private final AmazonS3 client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonS3Waiters(AmazonS3 client) {
        this.client = client;
    }

    public Waiter<HeadBucketRequest> bucketNotExists() {
        return new WaiterBuilder<HeadBucketRequest, HeadBucketResult>().withSdkFunction(new HeadBucketFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<HeadBucketRequest> bucketExists() {
        return new WaiterBuilder<HeadBucketRequest, HeadBucketResult>().withSdkFunction(new HeadBucketFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(301, WaiterState.SUCCESS), new HttpFailureStatusAcceptor(403, WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetObjectMetadataRequest> objectExists() {
        return new WaiterBuilder<GetObjectMetadataRequest, ObjectMetadata>().withSdkFunction(new HeadObjectFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetObjectMetadataRequest> objectNotExists() {
        return new WaiterBuilder<GetObjectMetadataRequest, ObjectMetadata>().withSdkFunction(new HeadObjectFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }
}

