/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc;

import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.exceptions.DBIsNotConnected;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdba.util.Version;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcIntermediateFacade
implements PrimeIntermediateFacade {
    @NotNull
    private final JdbcConnectionProvider myConnectionProvider;
    @NotNull
    protected final DBExceptionRecognizer myExceptionRecognizer;
    @NotNull
    protected final JdbcHelperImpl myHelper;
    private final LinkedBlockingQueue<JdbcIntermediateSession> mySessions;
    @Nullable
    private volatile Connection myConnection;
    protected static final Pattern SIMPLE_VERSION_PATTERN = Pattern.compile("(\\d{1,2}(\\.\\d{1,3}){1,5})");

    public JdbcIntermediateFacade(@NotNull JdbcConnectionProvider provider, @NotNull DBExceptionRecognizer exceptionRecognizer, @NotNull JdbcHelperImpl helper) {
        if (provider == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (exceptionRecognizer == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(1);
        }
        if (helper == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(2);
        }
        this.mySessions = new LinkedBlockingQueue();
        this.myConnection = null;
        this.myConnectionProvider = provider;
        this.myExceptionRecognizer = exceptionRecognizer;
        this.myHelper = helper;
    }

    @Override
    public synchronized void connect() {
        if (this.myConnection == null) {
            try {
                Connection connection;
                this.myConnection = connection = this.myConnectionProvider.getConnection();
            }
            catch (SQLException sqle) {
                throw this.myExceptionRecognizer.recognizeException(sqle, "connect");
            }
        }
    }

    @Override
    public synchronized void reconnect() {
        throw new RuntimeException("The JdbcInterFacade.reconnect has not been implemented yet.");
    }

    @Override
    public synchronized void detachFromDB() {
        this.closeSessions();
        this.myConnection = null;
    }

    private void closeSessions() {
        try {
            while (!this.mySessions.isEmpty()) {
                Thread.sleep(10L);
                ArrayList sessionsToClose = new ArrayList(10);
                this.mySessions.drainTo(sessionsToClose, 10);
                for (JdbcIntermediateSession sessionToClose : sessionsToClose) {
                    sessionToClose.close();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void closeConnection() {
        Connection connection = this.myConnection;
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.myConnection = null;
            }
        }
    }

    @Override
    public synchronized void disconnect() {
        this.closeSessions();
        this.closeConnection();
    }

    @Override
    public boolean isConnected() {
        return this.myConnection != null;
    }

    @Override
    @NotNull
    public ConnectionInfo getConnectionInfo() {
        ConnectionInfo info = null;
        try {
            info = this.obtainConnectionInfoNatively();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (info == null) {
            info = this.obtainConnectionInfoFromJdbc();
        }
        return this.completeConnectionInfo(info);
    }

    @Nullable
    protected ConnectionInfo obtainConnectionInfoNatively() {
        return null;
    }

    @NotNull
    protected ConnectionInfo obtainConnectionInfoFromJdbc() {
        Connection connection = this.myConnection;
        if (connection == null) {
            throw new DBIsNotConnected("Cannot obtain connection info because not connected");
        }
        try {
            DatabaseMetaData md = connection.getMetaData();
            String databaseName = connection.getCatalog();
            String schemaName = JdbcIntermediateFacade.getSchema(connection);
            String userName = this.getUserNameSafe(md);
            return new ConnectionInfo(databaseName, schemaName, userName);
        }
        catch (SQLException sqle) {
            throw this.myExceptionRecognizer.recognizeException(sqle, "getting brief connection info using JDBC connection metadata");
        }
    }

    @NotNull
    private ConnectionInfo completeConnectionInfo(ConnectionInfo info) {
        String rdbmsName = "UNKNOWN".equals(info.dbmsName) ? this.myHelper.getDbmsName() : info.dbmsName;
        String hVersion = this.myHelper.getVersion();
        Version serverVersion = info.serverVersion == Version.ZERO && hVersion != null ? Version.of(hVersion) : info.serverVersion;
        String hDriverVersion = this.myHelper.getDriverVersion();
        Version driverVersion = info.driverVersion == Version.ZERO && hDriverVersion != null ? Version.of(hDriverVersion) : info.driverVersion;
        return new ConnectionInfo(rdbmsName, info.databaseName, info.schemaName, info.userName, serverVersion, driverVersion);
    }

    private String getUserNameSafe(DatabaseMetaData md) {
        try {
            return md.getUserName();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Nullable
    private static String getSchema(Connection connection) {
        String schemaName = null;
        try {
            Class<?> connectionClass = connection.getClass();
            Method getSchemaMethod = connectionClass.getMethod("getSchema", new Class[0]);
            if (getSchemaMethod != null) {
                schemaName = (String)getSchemaMethod.invoke((Object)connection, new Object[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return schemaName;
    }

    @Override
    @NotNull
    public JdbcIntermediateSession openSession() {
        Connection connection = this.myConnection;
        if (connection == null) {
            throw new DBIsNotConnected("Cannot open a session: not connected");
        }
        JdbcIntermediateSession session = this.instantiateSession(connection);
        this.mySessions.add(session);
        JdbcIntermediateSession jdbcIntermediateSession = session;
        if (jdbcIntermediateSession == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(3);
        }
        return jdbcIntermediateSession;
    }

    @NotNull
    protected JdbcIntermediateSession instantiateSession(@NotNull Connection connection) {
        if (connection == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(4);
        }
        return new JdbcIntermediateSession(this, this.myExceptionRecognizer, connection);
    }

    @NotNull
    public DBExceptionRecognizer getExceptionRecognizer() {
        DBExceptionRecognizer dBExceptionRecognizer = this.myExceptionRecognizer;
        if (dBExceptionRecognizer == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(5);
        }
        return dBExceptionRecognizer;
    }

    void sessionIsClosed(@NotNull JdbcIntermediateSession session, @NotNull Connection connection) {
        if (session == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(6);
        }
        if (connection == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(7);
        }
        this.mySessions.remove(session);
    }

    @Override
    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        if (serviceClass == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(8);
        }
        if (serviceName == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(9);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ConnectionInfo getConnectionInfoSmartly(String envQuery) {
        JdbcIntermediateSession session = this.openSession();
        String[] env = session.queryOneRow(envQuery, 3, String.class);
        if (env == null) {
            env = new String[]{null, null, null};
        }
        assert (env.length == 3) : "Session info should contain 3 components";
        ConnectionInfo connectionInfo = new ConnectionInfo(env[0], env[1], env[2]);
        ConnectionInfo connectionInfo2 = connectionInfo;
        if (connectionInfo2 == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(10);
        }
        return connectionInfo2;
        finally {
            session.close();
        }
    }

    @NotNull
    protected static Version extractVersion(@Nullable String serverVersionStr, @NotNull Pattern versionPattern, int groupIndex) {
        if (versionPattern == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(11);
        }
        if (serverVersionStr == null || serverVersionStr.isEmpty()) {
            Version version = Version.ZERO;
            if (version == null) {
                JdbcIntermediateFacade.$$$reportNull$$$0(12);
            }
            return version;
        }
        Matcher m = versionPattern.matcher(serverVersionStr);
        if (m.find()) {
            Version version = Version.of(m.group(groupIndex));
            if (version == null) {
                JdbcIntermediateFacade.$$$reportNull$$$0(13);
            }
            return version;
        }
        Version version = Version.ZERO;
        if (version == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(14);
        }
        return version;
    }

    public int countOpenedSessions() {
        return this.mySessions.size();
    }

    public int countOpenedConnections() {
        return this.myConnection != null ? 1 : 0;
    }

    public int countOpenedSeances() {
        int count = 0;
        for (JdbcIntermediateSession session : this.mySessions) {
            count += session.countOpenedSeances();
        }
        return count;
    }

    public int countOpenedCursors() {
        int count = 0;
        for (JdbcIntermediateSession session : this.mySessions) {
            count += session.countOpenedCursors();
        }
        return count;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/jdbc/JdbcIntermediateFacade";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/JdbcIntermediateFacade";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "openSession";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionRecognizer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionInfoSmartly";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "instantiateSession";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sessionIsClosed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificService";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

