/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.ui.JBColor;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicNodesGroup
extends NodesGroup {
    private final String myGroupName;
    private NodesGroup myParent;
    private boolean myClosed;

    public BasicNodesGroup(@NotNull String groupName) {
        if (groupName == null) {
            BasicNodesGroup.$$$reportNull$$$0(0);
        }
        this(groupName, null);
    }

    public BasicNodesGroup(String groupName, NodesGroup parent) {
        this.myGroupName = groupName;
        this.myParent = parent;
        this.myClosed = true;
    }

    @Override
    @NotNull
    public String getGroupName() {
        String string = this.myGroupName;
        if (string == null) {
            BasicNodesGroup.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public GroupNodeRealizer getGroupNodeRealizer() {
        GroupNodeRealizer groupNodeRealizer = GraphManager.getGraphManager().createGroupNodeRealizer();
        groupNodeRealizer.setInnerGraphDisplayEnabled(true);
        groupNodeRealizer.setAutoBoundsEnabled(true);
        groupNodeRealizer.setLabelText(this.getGroupName());
        groupNodeRealizer.setOpenGroupIcon(PlatformIcons.PACKAGE_ICON);
        groupNodeRealizer.setClosedGroupIcon(PlatformIcons.PACKAGE_ICON);
        groupNodeRealizer.setFillColor(UIUtil.getLabelBackground());
        NodeLabel label = groupNodeRealizer.getLabel();
        label.setBackgroundColor((Color)JBColor.lightGray);
        label.setTextColor(JBColor.foreground());
        return groupNodeRealizer;
    }

    @Override
    public boolean isClosed() {
        return this.myClosed;
    }

    @Override
    public void setClosed(boolean closed) {
        this.myClosed = closed;
    }

    @Override
    @Nullable
    public NodesGroup getParent() {
        return this.myParent;
    }

    public void setParent(NodesGroup parent) {
        this.myParent = parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicNodesGroup that = (BasicNodesGroup)o;
        return this.myGroupName.equals(that.myGroupName);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.myGroupName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/components/BasicNodesGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/components/BasicNodesGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

