/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0012"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "collectData", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "suggestBranchName", "", "repository", "Lgit4idea/repo/GitRepository;", "branches", "", "Lcom/intellij/vcs/log/VcsRef;", "update", "Data", "intellij.vcs.git"})
public final class GitCreateNewBranchAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        block1: {
            Data data;
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                data = this.collectData(e);
                if (!(data instanceof Data.WithCommit)) break block0;
                Project project = ((Data.WithCommit)data).getRepository().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"data.repository.project");
                List list2 = CollectionsKt.listOf((Object)((Data.WithCommit)data).getRepository());
                String string = ((Data.WithCommit)data).getHash().toString();
                String string2 = GitBundle.message("action.Git.New.Branch.dialog.title", ((Data.WithCommit)data).getHash().toShortString());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"actio\u2026ata.hash.toShortString())");
                GitBranchActionsUtilKt.createOrCheckoutNewBranch(project, list2, string, string2, ((Data.WithCommit)data).getName());
                break block1;
            }
            if (!(data instanceof Data.NoCommit)) break block1;
            GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(((Data.NoCommit)data).getProject(), ((Data.NoCommit)data).getRepositories(), "HEAD", null, null, 24, null);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Data data = this.collectData(e);
        if (data instanceof Data.Invisible) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
        } else if (data instanceof Data.Disabled) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setVisible(true);
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabled(false);
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
            presentation3.setDescription(((Data.Disabled)data).getDescription());
        } else {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(true);
        }
    }

    private final Data collectData(AnActionEvent e) {
        List repositories;
        Project project;
        block21: {
            block20: {
                boolean bl;
                block19: {
                    GitRepository it;
                    List list2;
                    GitRepository repository;
                    Project project2 = e.getProject();
                    if (project2 == null) {
                        return Data.Invisible.INSTANCE;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return Data.Invisible");
                    project = project2;
                    GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(project);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getRepositoryManager(project)");
                    GitRepositoryManager manager = gitRepositoryManager;
                    if (manager.getRepositories().isEmpty()) {
                        return Data.Invisible.INSTANCE;
                    }
                    VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
                    if (log != null) {
                        CommitId commit;
                        List list3 = log.getSelectedCommits();
                        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"log.selectedCommits");
                        List commits2 = list3;
                        if (commits2.isEmpty()) {
                            return Data.Invisible.INSTANCE;
                        }
                        if (commits2.size() > 1) {
                            String string = GitBundle.message("action.New.Branch.disabled.several.commits.description", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"actio\u2026ral.commits.description\")");
                            return new Data.Disabled(string);
                        }
                        CommitId commitId = commit = (CommitId)CollectionsKt.first((List)commits2);
                        Intrinsics.checkNotNullExpressionValue((Object)commitId, (String)"commit");
                        repository = (GitRepository)manager.getRepositoryForRootQuick(commitId.getRoot());
                        if (repository != null) {
                            String initialName = this.suggestBranchName(repository, (List)e.getData(VcsLogDataKeys.VCS_LOG_BRANCHES));
                            Hash hash = commit.getHash();
                            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"commit.hash");
                            return new Data.WithCommit(repository, hash, initialName);
                        }
                    }
                    if (manager.moreThanOneRoot()) {
                        GitVcsSettings gitVcsSettings = GitVcsSettings.getInstance(project);
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcsSettings), (String)"GitVcsSettings.getInstance(project)");
                        if (gitVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC) {
                            list2 = manager.getRepositories();
                        } else {
                            GitRepository repository2;
                            GitRepository gitRepository = repository2 = (GitRepository)manager.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot((Project)project, (VirtualFile)((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE))));
                            if (gitRepository != null) {
                                repository = gitRepository;
                                boolean bl2 = false;
                                boolean bl3 = false;
                                it = repository;
                                boolean bl4 = false;
                                list2 = CollectionsKt.listOf((Object)repository2);
                            } else {
                                list2 = null;
                            }
                        }
                    } else {
                        List<GitRepository> list4 = manager.getRepositories();
                        Intrinsics.checkNotNullExpressionValue(list4, (String)"manager.repositories");
                        list2 = repositories = CollectionsKt.listOf((Object)CollectionsKt.first(list4));
                    }
                    if (repositories == null) break block20;
                    Iterable $this$any$iv = repositories;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (GitRepository)element$iv;
                            boolean bl5 = false;
                            GitRepository gitRepository = it;
                            Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"it");
                            if (!gitRepository.isFresh()) continue;
                            bl = true;
                            break block19;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block21;
            }
            String string = GitBundle.message("action.New.Branch.disabled.fresh.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"actio\u2026abled.fresh.description\")");
            return new Data.Disabled(string);
        }
        return new Data.NoCommit(project, repositories);
    }

    /*
     * WARNING - void declaration
     */
    private final String suggestBranchName(GitRepository repository, List<? extends VcsRef> branches2) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = branches2;
        boolean bl = false;
        List list2 = iterable;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        iterable = list2;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsRef it = (VcsRef)element$iv$iv;
            boolean bl2 = false;
            VcsRefType vcsRefType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)vcsRefType, (String)"it.type");
            if (!vcsRefType.isBranch()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existingBranches = (List)destination$iv$iv;
        Iterable $this$map$iv = existingBranches;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            VcsRef bl2 = (VcsRef)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl3 = false;
            if (repository.getBranches().findBranchByName(it.getName()) == null) {
                string = null;
            } else {
                GitBranch branch;
                Intrinsics.checkNotNullExpressionValue((Object)branch, (String)"repository.branches.find\u2026.name) ?: return@map null");
                if (branch.isRemote()) {
                    GitBranch gitBranch = branch;
                    if (gitBranch == null) {
                        throw new NullPointerException("null cannot be cast to non-null type git4idea.GitRemoteBranch");
                    }
                    string = ((GitRemoteBranch)gitBranch).getNameForRemoteOperations();
                } else {
                    string = branch.getName();
                }
            }
            String string2 = string;
            collection.add(string2);
        }
        List suggestedNames = (List)destination$iv$iv2;
        return (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)suggestedNames));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data;", "", "()V", "Disabled", "Invisible", "NoCommit", "WithCommit", "Lgit4idea/actions/GitCreateNewBranchAction$Data$Invisible;", "Lgit4idea/actions/GitCreateNewBranchAction$Data$Disabled;", "Lgit4idea/actions/GitCreateNewBranchAction$Data$WithCommit;", "Lgit4idea/actions/GitCreateNewBranchAction$Data$NoCommit;", "intellij.vcs.git"})
    private static abstract class Data {
        private Data() {
        }

        public /* synthetic */ Data(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$Invisible;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "()V", "intellij.vcs.git"})
        public static final class Invisible
        extends Data {
            @NotNull
            public static final Invisible INSTANCE;

            private Invisible() {
                super(null);
            }

            static {
                Invisible invisible;
                INSTANCE = invisible = new Invisible();
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0012\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$Disabled;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "description", "", "Lorg/jetbrains/annotations/Nls;", "(Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "intellij.vcs.git"})
        public static final class Disabled
        extends Data {
            @NotNull
            private final String description;

            @NotNull
            public final String getDescription() {
                return this.description;
            }

            public Disabled(@NotNull String description) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                super(null);
                this.description = description;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$WithCommit;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "repository", "Lgit4idea/repo/GitRepository;", "hash", "Lcom/intellij/vcs/log/Hash;", "name", "", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/Hash;Ljava/lang/String;)V", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getName", "()Ljava/lang/String;", "getRepository", "()Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
        public static final class WithCommit
        extends Data {
            @NotNull
            private final GitRepository repository;
            @NotNull
            private final Hash hash;
            @Nullable
            private final String name;

            @NotNull
            public final GitRepository getRepository() {
                return this.repository;
            }

            @NotNull
            public final Hash getHash() {
                return this.hash;
            }

            @Nullable
            public final String getName() {
                return this.name;
            }

            public WithCommit(@NotNull GitRepository repository, @NotNull Hash hash, @Nullable String name) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                super(null);
                this.repository = repository;
                this.hash = hash;
                this.name = name;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$NoCommit;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepositories", "()Ljava/util/List;", "intellij.vcs.git"})
        public static final class NoCommit
        extends Data {
            @NotNull
            private final Project project;
            @NotNull
            private final List<GitRepository> repositories;

            @NotNull
            public final Project getProject() {
                return this.project;
            }

            @NotNull
            public final List<GitRepository> getRepositories() {
                return this.repositories;
            }

            public NoCommit(@NotNull Project project, @NotNull List<? extends GitRepository> repositories) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
                super(null);
                this.project = project;
                this.repositories = repositories;
            }
        }
    }
}

