/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.vcs.FilePath;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt$WhenMappings;
import git4idea.index.GitIndexStatusUtilKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"ignoredStatus", "Lgit4idea/index/GitFileStatus;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "notChangedStatus", "untrackedStatus", "has", "", "contentVersion", "Lgit4idea/index/ContentVersion;", "path", "intellij.vcs.git"})
public final class GitFileStatusKt {
    @NotNull
    public static final GitFileStatus untrackedStatus(@NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return new GitFileStatus('?', '?', filePath, null);
    }

    @NotNull
    public static final GitFileStatus ignoredStatus(@NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return new GitFileStatus('!', '!', filePath, null);
    }

    @NotNull
    public static final GitFileStatus notChangedStatus(@NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return new GitFileStatus(' ', ' ', filePath, null);
    }

    public static final boolean has(@NotNull GitFileStatus $this$has, @NotNull ContentVersion contentVersion) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$has, (String)"$this$has");
        Intrinsics.checkNotNullParameter((Object)((Object)contentVersion), (String)"contentVersion");
        switch (GitFileStatusKt$WhenMappings.$EnumSwitchMapping$0[contentVersion.ordinal()]) {
            case 1: {
                if ($this$has.isTracked() && !GitIndexStatusUtilKt.isAdded($this$has.getIndex()) && !GitIndexStatusUtilKt.isIntendedToBeAdded($this$has.getIndex(), $this$has.getWorkTree())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if ($this$has.isTracked() && !GitIndexStatusUtilKt.isDeleted($this$has.getIndex())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (!GitIndexStatusUtilKt.isDeleted($this$has.getWorkTree())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public static final FilePath path(@NotNull GitFileStatus $this$path, @NotNull ContentVersion contentVersion) {
        FilePath filePath;
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"$this$path");
        Intrinsics.checkNotNullParameter((Object)((Object)contentVersion), (String)"contentVersion");
        switch (GitFileStatusKt$WhenMappings.$EnumSwitchMapping$1[contentVersion.ordinal()]) {
            case 1: {
                filePath = $this$path.getOrigPath();
                if (filePath != null) break;
                filePath = $this$path.getPath();
                break;
            }
            case 2: {
                if (GitIndexStatusUtilKt.isRenamed($this$path.getIndex())) {
                    filePath = $this$path.getPath();
                    break;
                }
                filePath = $this$path.getOrigPath();
                if (filePath != null) break;
                filePath = $this$path.getPath();
                break;
            }
            case 3: {
                filePath = $this$path.getPath();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return filePath;
    }
}

