/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import org.jetbrains.annotations.NotNull;

public class StringScanner {
    private final String myText;
    private int myPosition;

    public StringScanner(@NotNull String text) {
        if (text == null) {
            StringScanner.$$$reportNull$$$0(0);
        }
        this.myText = text;
        this.myPosition = 0;
    }

    public boolean hasMoreData() {
        return this.myPosition < this.myText.length();
    }

    public boolean isEol() {
        if (!this.hasMoreData()) {
            return true;
        }
        char ch = this.myText.charAt(this.myPosition);
        return ch == '\n';
    }

    public void nextLine() {
        while (!this.isEol()) {
            ++this.myPosition;
        }
        if (this.hasMoreData()) {
            char ch = this.myText.charAt(this.myPosition++);
            if (this.hasMoreData()) {
                char ch2 = this.myText.charAt(this.myPosition);
                if (ch == '\r' && ch2 == '\n') {
                    ++this.myPosition;
                }
            }
        }
    }

    public String spaceToken() {
        return this.boundedToken(' ');
    }

    public String tabToken() {
        return this.boundedToken('\t');
    }

    @NotNull
    public String boundedToken(char boundaryChar) {
        String string = this.boundedToken(boundaryChar, false);
        if (string == null) {
            StringScanner.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String boundedToken(char boundaryChar, boolean ignoreEol) {
        int start = this.myPosition;
        while (this.myPosition < this.myText.length()) {
            char ch = this.myText.charAt(this.myPosition);
            if (ch == boundaryChar) {
                String rc = this.myText.substring(start, this.myPosition);
                ++this.myPosition;
                String string = rc;
                if (string == null) {
                    StringScanner.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (!ignoreEol && this.isEol()) {
                String string = this.myText.substring(start, this.myPosition);
                if (string == null) {
                    StringScanner.$$$reportNull$$$0(3);
                }
                return string;
            }
            ++this.myPosition;
        }
        throw new IllegalStateException("Unexpected text end at " + this.myPosition);
    }

    public boolean startsWith(char c) {
        return this.hasMoreData() && this.myText.charAt(this.myPosition) == c;
    }

    public boolean startsWith(String text) {
        return this.myText.startsWith(text, this.myPosition);
    }

    public String line() {
        return this.line(false);
    }

    public String line(boolean includeNewLine) {
        int end;
        int start = this.myPosition;
        while (!this.isEol()) {
            ++this.myPosition;
        }
        if (includeNewLine) {
            this.nextLine();
            end = this.myPosition;
        } else {
            end = this.myPosition;
            this.nextLine();
        }
        return this.myText.substring(start, end);
    }

    public void skipChars(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Amount of chars to skip must be non neagitve: " + n);
        }
        if (this.myPosition + n >= this.myText.length()) {
            throw new IllegalArgumentException("Skipping beyond end of the text (" + this.myPosition + " + " + n + " >= " + this.myText.length() + ")");
        }
        this.myPosition += n;
    }

    public boolean tryConsume(char c) {
        if (this.startsWith(c)) {
            this.skipChars(1);
            return true;
        }
        return false;
    }

    public boolean tryConsume(String chars) {
        if (this.startsWith(chars)) {
            this.skipChars(chars.length());
            return true;
        }
        return false;
    }

    public char peek() {
        if (!this.hasMoreData()) {
            throw new IllegalStateException("There is no next character");
        }
        return this.myText.charAt(this.myPosition);
    }

    public String getAllText() {
        return this.myText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/StringScanner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/StringScanner";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "boundedToken";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

