/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution;

import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.RestClientFormBodyPart;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.http.cookie.Cookie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestClientRequest {
    public List<Biscuit> biscuits = new ArrayList<Biscuit>();
    public String httpMethod;
    public String urlBase;
    public String urlPath;
    public List<KeyValuePair> headers = new ArrayList<KeyValuePair>();
    public List<KeyValuePair> parameters = new ArrayList<KeyValuePair>();
    public boolean parametersEnabled;
    public boolean haveTextToSend;
    public boolean haveFileToSend;
    public boolean isFileUpload;
    public String textToSend;
    public String filesToSend;
    @Transient
    public List<RestClientFormBodyPart> formBodyPart = new ArrayList<RestClientFormBodyPart>();
    @Transient
    public String multipartBoundary = null;
    @Transient
    public HttpClientAuthData authData = null;
    @Transient
    @NotNull
    public HttpRequestConfig config = new HttpRequestConfig(true, true, true);
    @Transient
    @Nullable
    public SslConfiguration sslConfiguration = null;

    public String getHeaderValue(String name, String defaultValue) {
        for (KeyValuePair header : this.headers) {
            if (!name.equals(header.getKey())) continue;
            return header.getValue();
        }
        return defaultValue;
    }

    @Nullable
    public List<String> getHeadersValue(@NotNull String name) {
        if (name == null) {
            RestClientRequest.$$$reportNull$$$0(0);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (KeyValuePair header : this.headers) {
            if (!name.equals(header.getKey())) continue;
            list.add(header.getValue());
        }
        return list.isEmpty() ? null : list;
    }

    public void deleteHeader(@NotNull String name) {
        if (name == null) {
            RestClientRequest.$$$reportNull$$$0(1);
        }
        this.headers.removeIf(header -> name.equals(header.getKey()));
    }

    public List<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (String path : StringUtil.split((String)this.filesToSend, (String)File.pathSeparator)) {
            files.add(new File(path));
        }
        return files;
    }

    public String getURL() {
        Object base = this.urlBase;
        if (!((String)base).endsWith("/") && this.urlPath.length() > 0) {
            base = (String)base + "/";
        }
        base = this.urlPath.startsWith("/") ? (String)base + this.urlPath.substring(1) : (String)base + this.urlPath;
        return ((String)base).replace(" ", "%20");
    }

    public String createQueryString() {
        return StringUtil.join(this.parameters, pair -> {
            String key2 = URLEncoder.encode(pair.getKey(), StandardCharsets.UTF_8);
            String value = URLEncoder.encode(pair.getValue(), StandardCharsets.UTF_8);
            return key2 + "=" + value;
        }, (String)"&");
    }

    public void addBiscuit(Cookie cookie) {
        Date date = cookie.getExpiryDate();
        this.biscuits.add(new Biscuit(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), date != null ? date.getTime() : -1L));
    }

    public boolean isEmptyCredentials() {
        return this.authData == HttpClientAuthData.EMPTY_CREDENTIALS;
    }

    public void setEmptyCredentials() {
        this.authData = HttpClientAuthData.EMPTY_CREDENTIALS;
    }

    public String toString() {
        String url = this.getURL();
        String queryString = this.createQueryString();
        if (queryString.length() > 0) {
            return url + (url.contains("?") ? "&" : "?") + queryString;
        }
        return url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestClientRequest request = (RestClientRequest)o;
        if (this.haveFileToSend != request.haveFileToSend) {
            return false;
        }
        if (this.haveTextToSend != request.haveTextToSend) {
            return false;
        }
        if (this.isFileUpload != request.isFileUpload) {
            return false;
        }
        if (this.parametersEnabled != request.parametersEnabled) {
            return false;
        }
        if (!this.config.equals(request.config)) {
            return false;
        }
        if (!Objects.equals(this.filesToSend, request.filesToSend)) {
            return false;
        }
        if (!Objects.equals(this.headers, request.headers)) {
            return false;
        }
        if (!Objects.equals(this.httpMethod, request.httpMethod)) {
            return false;
        }
        if (!Objects.equals(this.parameters, request.parameters)) {
            return false;
        }
        if (!Objects.equals(this.textToSend, request.textToSend)) {
            return false;
        }
        if (!Objects.equals(this.urlBase, request.urlBase)) {
            return false;
        }
        if (!Objects.equals(this.urlPath, request.urlPath)) {
            return false;
        }
        if (!Objects.equals(this.biscuits, request.biscuits)) {
            return false;
        }
        if (!Objects.equals(this.formBodyPart, request.formBodyPart)) {
            return false;
        }
        if (!Objects.equals(this.multipartBoundary, request.multipartBoundary)) {
            return false;
        }
        return Objects.equals(this.authData, request.authData);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.httpMethod);
        result = 31 * result + Objects.hashCode(this.urlBase);
        result = 31 * result + Objects.hashCode(this.urlPath);
        result = 31 * result + Objects.hashCode(this.headers);
        result = 31 * result + Objects.hashCode(this.parameters);
        result = 31 * result + Objects.hashCode(this.config);
        result = 31 * result + (this.parametersEnabled ? 1 : 0);
        result = 31 * result + (this.haveTextToSend ? 1 : 0);
        result = 31 * result + (this.haveFileToSend ? 1 : 0);
        result = 31 * result + (this.isFileUpload ? 1 : 0);
        result = 31 * result + Objects.hashCode(this.textToSend);
        result = 31 * result + Objects.hashCode(this.filesToSend);
        result = 31 * result + Objects.hashCode(this.formBodyPart);
        result = 31 * result + Objects.hashCode(this.multipartBoundary);
        result = 31 * result + Objects.hashCode(this.authData);
        result = 31 * result + Objects.hashCode(this.biscuits);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "name";
        objectArray2[1] = "com/intellij/httpClient/execution/RestClientRequest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHeadersValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteHeader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Biscuit {
        private String myName;
        private String myValue;
        private String myDomain;
        private String myPath;
        private long myDate;

        public Biscuit() {
        }

        public Biscuit(String name, String value, String domain, String path, long date) {
            this.myName = name;
            this.myValue = value;
            this.myDomain = domain;
            this.myPath = path;
            this.myDate = date;
        }

        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        public String getDomain() {
            return this.myDomain;
        }

        public void setDomain(String domain) {
            this.myDomain = domain;
        }

        public String getPath() {
            return this.myPath;
        }

        public void setPath(String path) {
            this.myPath = path;
        }

        public long getDate() {
            return this.myDate;
        }

        public void setDate(long date) {
            this.myDate = date;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Biscuit biscuit = (Biscuit)o;
            if (this.myDate != biscuit.myDate) {
                return false;
            }
            if (!Objects.equals(this.myDomain, biscuit.myDomain)) {
                return false;
            }
            if (!this.myName.equals(biscuit.myName)) {
                return false;
            }
            if (!Objects.equals(this.myPath, biscuit.myPath)) {
                return false;
            }
            return this.myValue.equals(biscuit.myValue);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + this.myValue.hashCode();
            result = 31 * result + (this.myDomain != null ? this.myDomain.hashCode() : 0);
            result = 31 * result + (this.myPath != null ? this.myPath.hashCode() : 0);
            result = 31 * result + (int)(this.myDate ^ this.myDate >>> 32);
            return result;
        }
    }

    public static class KeyValuePair {
        private String myKey;
        private String myValue;

        public KeyValuePair() {
        }

        public KeyValuePair(String key2, String value) {
            this.myKey = key2;
            this.myValue = value;
        }

        public String getKey() {
            return this.myKey;
        }

        public void setKey(String key2) {
            this.myKey = key2;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyValuePair pair = (KeyValuePair)o;
            if (!this.myKey.equals(pair.myKey)) {
                return false;
            }
            return this.myValue.equals(pair.myValue);
        }

        public int hashCode() {
            int result = this.myKey.hashCode();
            result = 31 * result + this.myValue.hashCode();
            return result;
        }
    }
}

