/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.environment;

import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentInputFilter;
import com.intellij.httpClient.http.request.index.HttpRequestStringsExternalizer;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class HttpRequestEnvironmentIndex
extends FileBasedIndexExtension<String, Set<String>> {
    public static final ID<String, Set<String>> INDEX_ID = ID.create((String)"http.request.execution.environment");

    @NotNull
    public ID<String, Set<String>> getName() {
        ID<String, Set<String>> iD = INDEX_ID;
        if (iD == null) {
            HttpRequestEnvironmentIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Set<String>, FileContent> getIndexer() {
        return new DataIndexer<String, Set<String>, FileContent>(){

            @NotNull
            public Map<String, Set<String>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiFile file2 = inputData.getPsiFile();
                assert (file2 instanceof JsonFile);
                JsonValue root = ((JsonFile)file2).getTopLevelValue();
                if (!(root instanceof JsonObject)) {
                    Map<String, Set<String>> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
                for (JsonProperty property : ((JsonObject)root).getPropertyList()) {
                    JsonValue value = property.getValue();
                    if (!(value instanceof JsonObject)) continue;
                    result.put(property.getName(), HttpRequestEnvironmentIndex.readEnvVariables((JsonObject)value, file2.getName()));
                }
                HashMap<String, Set<String>> hashMap = result;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/httpClient/http/request/environment/HttpRequestEnvironmentIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/httpClient/http/request/environment/HttpRequestEnvironmentIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    private static Set<String> readEnvVariables(@NotNull JsonObject obj, @NotNull String fileName) {
        List properties;
        if (obj == null) {
            HttpRequestEnvironmentIndex.$$$reportNull$$$0(1);
        }
        if (fileName == null) {
            HttpRequestEnvironmentIndex.$$$reportNull$$$0(2);
        }
        if ((properties = obj.getPropertyList()).isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                HttpRequestEnvironmentIndex.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<String> set = properties.stream().map(property -> StringUtil.nullize((String)property.getName())).filter(Objects::nonNull).filter(propertyName -> !"SSLConfiguration".equals(propertyName) || !ArrayUtil.contains((String)fileName, (String[])HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES)).collect(Collectors.toSet());
        if (set == null) {
            HttpRequestEnvironmentIndex.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            HttpRequestEnvironmentIndex.$$$reportNull$$$0(5);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Set<String>> getValueExternalizer() {
        return new HttpRequestStringsExternalizer();
    }

    public int getVersion() {
        return 3;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new HttpRequestEnvironmentInputFilter();
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/environment/HttpRequestEnvironmentIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/environment/HttpRequestEnvironmentIndex";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readEnvVariables";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readEnvVariables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

