/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestGlobalContext {
    private static final Logger LOG = Logger.getInstance(HttpRequestGlobalContext.class);
    private static final Map<String, HttpRequestGlobalContext> ourContexts = new HashMap<String, HttpRequestGlobalContext>();
    private final HttpClientVariables myGlobal = new HttpClientVariables();

    @NotNull
    public static synchronized HttpRequestGlobalContext getInstance(@NotNull Project project) {
        String projectName;
        if (project == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(0);
        }
        if (!ourContexts.containsKey(projectName = HttpRequestGlobalContext.getProjectNameKey(project))) {
            ourContexts.put(projectName, new HttpRequestGlobalContext());
            LOG.info("Global request context for '" + project.getName() + "' was created.");
        }
        HttpRequestGlobalContext httpRequestGlobalContext = ourContexts.get(projectName);
        if (httpRequestGlobalContext == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(1);
        }
        return httpRequestGlobalContext;
    }

    @NotNull
    private static String getProjectNameKey(@NotNull Project project) {
        if (project == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(2);
        }
        String string = ProjectUtil.getProjectCacheFileName((Project)project);
        if (string == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isEmpty() {
        return this.myGlobal.isEmpty();
    }

    @Nullable
    public String getValue(@NotNull String name) {
        if (name == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(4);
        }
        return this.myGlobal.get(name);
    }

    @NotNull
    public Collection<String> getAllVariables() {
        Set<String> set = this.myGlobal.myVariables.keySet();
        if (set == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public HttpClientVariables getGlobal() {
        HttpClientVariables httpClientVariables = this.myGlobal;
        if (httpClientVariables == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(6);
        }
        return httpClientVariables;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRequestGlobalContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestGlobalContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectNameKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVariables";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectNameKey";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HttpRequestGlobalContextProjectListener
    implements ProjectManagerListener {
        public void projectClosing(@NotNull Project project) {
            String closedProjectName;
            if (project == null) {
                HttpRequestGlobalContextProjectListener.$$$reportNull$$$0(0);
            }
            if (ourContexts.containsKey(closedProjectName = HttpRequestGlobalContext.getProjectNameKey(project))) {
                LOG.info("Global request context for '" + project.getName() + "' was disposed.");
                ourContexts.remove(closedProjectName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/httpClient/http/request/run/HttpRequestGlobalContext$HttpRequestGlobalContextProjectListener", "projectClosing"));
        }
    }

    public static class HttpClientVariables {
        private final ConcurrentMap<String, String> myVariables = new ConcurrentHashMap<String, String>();

        public boolean isEmpty() {
            return this.myVariables.isEmpty();
        }

        public void set(@NotNull String name, @NotNull String value) {
            if (name == null) {
                HttpClientVariables.$$$reportNull$$$0(0);
            }
            if (value == null) {
                HttpClientVariables.$$$reportNull$$$0(1);
            }
            this.myVariables.put(name, value);
        }

        public String get(@NotNull String name) {
            if (name == null) {
                HttpClientVariables.$$$reportNull$$$0(2);
            }
            return (String)this.myVariables.get(name);
        }

        public Map<String, String> getAllVars() {
            return this.myVariables;
        }

        public void clear(@NotNull String name) {
            if (name == null) {
                HttpClientVariables.$$$reportNull$$$0(3);
            }
            this.myVariables.remove(name);
        }

        public void clearAll() {
            this.myVariables.clear();
        }

        public String toString() {
            return ContainerUtil.toString(this.myVariables);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestGlobalContext$HttpClientVariables";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "set";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clear";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

