/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.config;

import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.httpClient.http.request.run.config.HttpRequestRuntimeConfigurationProducer;
import com.intellij.httpClient.http.request.run.config.HttpSingleRequestRuntimeConfigurationProducer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpSingleRequestExecutionConfig
implements HttpRequestExecutionConfig {
    private final List<HttpRequest> myRequests;
    private final boolean myShowInformationAboutRequest;

    public HttpSingleRequestExecutionConfig(HttpRequest request) {
        this(request, true);
    }

    public HttpSingleRequestExecutionConfig(HttpRequest request, boolean showInformationAboutRequest) {
        this.myRequests = new SmartList((Object)request);
        this.myShowInformationAboutRequest = showInformationAboutRequest;
    }

    @Override
    @NotNull
    public List<HttpRequest> getRequests() {
        List<HttpRequest> list = this.myRequests;
        if (list == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public PsiFile getContext() {
        PsiFile psiFile = this.myRequests.get(0).getContainingFile();
        if (psiFile == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(1);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public String getName(@NotNull HttpRequestVariableSubstitutor substitutor) {
        if (substitutor == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(2);
        }
        String string = StringUtil.notNullize((String)this.myRequests.get(0).getHttpUrl(substitutor));
        if (string == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getActionDescription(@NotNull @Nls String actionName, @Nullable String env) {
        if (actionName == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)env)) {
            String string = actionName + " " + StringUtil.notNullize((String)this.myRequests.get(0).getHttpHost(HttpRequestVariableSubstitutor.empty()));
            if (string == null) {
                HttpSingleRequestExecutionConfig.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = RestClientBundle.message("rest.client.request.execute.with.environment", actionName, env);
        if (string == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public HttpRequestRuntimeConfigurationProducer getRuntimeConfigurationProducer() {
        HttpRequestRuntimeConfigurationProducer httpRequestRuntimeConfigurationProducer = (HttpRequestRuntimeConfigurationProducer)RunConfigurationProducer.getInstance(HttpSingleRequestRuntimeConfigurationProducer.class);
        if (httpRequestRuntimeConfigurationProducer == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(7);
        }
        return httpRequestRuntimeConfigurationProducer;
    }

    @Override
    public boolean isShowInformationAboutRequest() {
        return this.myShowInformationAboutRequest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/config/HttpSingleRequestExecutionConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequests";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/config/HttpSingleRequestExecutionConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActionDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

