/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.config;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunType;
import com.intellij.httpClient.http.request.run.config.HttpRequestRuntimeConfigurationProducer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpSingleRequestRuntimeConfigurationProducer
extends HttpRequestRuntimeConfigurationProducer {
    protected boolean setupConfigurationFromContext(@NotNull HttpRequestRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Location location;
        if (configuration == null) {
            HttpSingleRequestRuntimeConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HttpSingleRequestRuntimeConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            HttpSingleRequestRuntimeConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (!((location = context.getLocation()) instanceof PsiLocation)) {
            return false;
        }
        PsiElement originalElement = location.getPsiElement();
        HttpRequest request = HttpSingleRequestRuntimeConfigurationProducer.findHttpRequestElement(location.getPsiElement());
        if (request != null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
            if (virtualFile == null) {
                return false;
            }
            int index = HttpSingleRequestRuntimeConfigurationProducer.getRequestIndex(request);
            if (index < 0) {
                return false;
            }
            HttpRequestRunConfiguration.Settings settings = configuration.getSettings();
            settings.setFilePath(virtualFile.getFileSystem().getProtocol().equals("jar") ? virtualFile.getUrl() : virtualFile.getPath());
            settings.setIndex(index);
            settings.setRunType(HttpRequestRunType.SINGLE_REQUEST);
            sourceElement.set((Object)request);
            configuration.setName(configuration.suggestedName());
            return true;
        }
        return false;
    }

    public boolean isConfigurationFromContext(@NotNull HttpRequestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Location location;
        if (configuration == null) {
            HttpSingleRequestRuntimeConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            HttpSingleRequestRuntimeConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        PsiElement originalElement = location.getPsiElement();
        HttpRequest request = HttpSingleRequestRuntimeConfigurationProducer.findHttpRequestElement(location.getPsiElement());
        if (request != null) {
            HttpRequestRunConfiguration.Settings settings = configuration.getSettings();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
            if (virtualFile == null || !FileUtil.pathsEqual((String)settings.getFilePath(), (String)virtualFile.getPath())) {
                return false;
            }
            int index = HttpSingleRequestRuntimeConfigurationProducer.getRequestIndex(request);
            return settings.getIndex() == index && HttpRequestRunType.SINGLE_REQUEST.equals((Object)settings.getRunType());
        }
        return false;
    }

    @Override
    protected boolean checkExistingConfiguration(@Nullable RunConfiguration configuration, @NotNull ConfigurationContext context) {
        HttpRequestRunConfiguration runConfiguration;
        if (context == null) {
            HttpSingleRequestRuntimeConfigurationProducer.$$$reportNull$$$0(5);
        }
        return configuration instanceof HttpRequestRunConfiguration && (runConfiguration = (HttpRequestRunConfiguration)configuration).getSettings().isDefaultEnvironment() && this.isConfigurationFromContext(runConfiguration, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/run/config/HttpSingleRequestRuntimeConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExistingConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

