/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import java.io.File;
import java.nio.file.Path;
import java.util.Date;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PluginDescriptor {
    @NotNull
    public PluginId getPluginId();

    public ClassLoader getPluginClassLoader();

    default public boolean isBundled() {
        return false;
    }

    @Deprecated
    default public File getPath() {
        Path path = this.getPluginPath();
        return path == null ? null : path.toFile();
    }

    public Path getPluginPath();

    @Nullable
    @Nls
    public String getDescription();

    public String getChangeNotes();

    @NlsSafe
    public String getName();

    @Nullable
    public String getProductCode();

    @Nullable
    public Date getReleaseDate();

    public int getReleaseVersion();

    public boolean isLicenseOptional();

    @Deprecated
    public PluginId @NotNull [] getOptionalDependentPluginIds();

    @NlsSafe
    public String getVendor();

    @NlsSafe
    default public String getOrganization() {
        return "";
    }

    @NlsSafe
    public String getVersion();

    @Nullable
    public String getResourceBundleBaseName();

    @NlsSafe
    public String getCategory();

    public String getVendorEmail();

    public String getVendorUrl();

    public String getUrl();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    default public String getDownloads() {
        return null;
    }

    @NlsSafe
    public String getSinceBuild();

    @NlsSafe
    public String getUntilBuild();

    default public boolean allowBundledUpdate() {
        return false;
    }

    default public boolean isImplementationDetail() {
        return false;
    }

    default public boolean isRequireRestart() {
        return false;
    }

    public boolean isEnabled();

    public void setEnabled(boolean var1);
}

