/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapInputDataDiffBuilder<Key, Value>
extends DirectInputDataDiffBuilder<Key, Value> {
    @NotNull
    private final Map<Key, Value> myMap;
    private static final AtomicInteger totalRequests = new AtomicInteger();
    private static final AtomicInteger totalRemovals = new AtomicInteger();
    private static final AtomicInteger totalAdditions = new AtomicInteger();
    private static final AtomicInteger incrementalRemovals = new AtomicInteger();
    private static final AtomicInteger incrementalAdditions = new AtomicInteger();
    private static final AtomicInteger noopModifications = new AtomicInteger();

    public MapInputDataDiffBuilder(int inputId, @Nullable Map<Key, Value> map2) {
        super(inputId);
        this.myMap = map2 == null ? Collections.emptyMap() : map2;
    }

    @Override
    public boolean differentiate(@NotNull Map<Key, Value> newData, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> addProcessor, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> updateProcessor, @NotNull RemovedKeyProcessor<? super Key> removeProcessor) throws StorageException {
        if (newData == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(0);
        }
        if (addProcessor == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(1);
        }
        if (updateProcessor == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(2);
        }
        if (removeProcessor == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(3);
        }
        if (this.myMap.isEmpty()) {
            return EmptyInputDataDiffBuilder.processAllKeyValuesAsAdded(this.myInputId, newData, addProcessor);
        }
        if (newData.isEmpty()) {
            return EmptyInputDataDiffBuilder.processAllKeyValuesAsRemoved(this.myInputId, this.myMap, removeProcessor);
        }
        int added = 0;
        int removed = 0;
        int updated = 0;
        for (Map.Entry<Key, Value> e : this.myMap.entrySet()) {
            Value newValue;
            Key key = e.getKey();
            Value oldValue = e.getValue();
            if (Comparing.equal(oldValue, newValue = newData.get(key)) && (newValue != null || newData.containsKey(key))) continue;
            if (newData.containsKey(key)) {
                updateProcessor.process(key, newValue, this.myInputId);
                ++updated;
                continue;
            }
            removeProcessor.process(key, this.myInputId);
            ++removed;
        }
        for (Map.Entry<Key, Value> e : newData.entrySet()) {
            Key newKey = e.getKey();
            if (this.myMap.containsKey(newKey)) continue;
            addProcessor.process(newKey, e.getValue(), this.myInputId);
            ++added;
        }
        if (IndexDebugProperties.DEBUG) {
            MapInputDataDiffBuilder.updateStatistics(added, removed, updated, this.myMap, newData);
        }
        return added != 0 || removed != 0 || updated != 0;
    }

    @Override
    @NotNull
    public Collection<Key> getKeys() {
        Set<Key> set = this.myMap.keySet();
        if (set == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static <Key, Value> void updateStatistics(int added, int removed, int updated, @NotNull Map<Key, Value> oldData, @NotNull Map<Key, Value> newData) {
        int requests;
        if (oldData == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(5);
        }
        if (newData == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(6);
        }
        incrementalAdditions.addAndGet(added);
        incrementalRemovals.addAndGet(removed);
        totalRemovals.addAndGet(oldData.size());
        totalAdditions.addAndGet(newData.size());
        if (added == 0 && removed == 0 && updated == 0) {
            noopModifications.incrementAndGet();
        }
        if (((requests = totalRequests.incrementAndGet()) & 0xFFFF) == 0) {
            Logger.getInstance(MapInputDataDiffBuilder.class).info("Incremental index diff update: " + requests + ", removals: " + totalRemovals + "->" + incrementalRemovals + ", additions: " + totalAdditions + "->" + incrementalAdditions + ", no op changes: " + noopModifications);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/MapInputDataDiffBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/MapInputDataDiffBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "differentiate";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateStatistics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

