/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;

final class IntObjectHashMap<T> {
    private final IntFunction<T[]> arrayFactory;
    private int size;
    private int[] keys;
    private T[] values;
    private T specialZeroValue;
    private boolean hasZeroValue;

    IntObjectHashMap(IntFunction<T[]> arrayFactory) {
        this.arrayFactory = arrayFactory;
        this.keys = new int[16];
        this.values = arrayFactory.apply(this.keys.length);
    }

    IntObjectHashMap(IntObjectHashMap<T> original) {
        this.arrayFactory = original.arrayFactory;
        this.keys = (int[])original.keys.clone();
        this.values = (Object[])original.values.clone();
        this.size = original.size;
        this.specialZeroValue = original.specialZeroValue;
        this.hasZeroValue = original.hasZeroValue;
    }

    int size() {
        return this.size + (this.hasZeroValue ? 1 : 0);
    }

    void replaceByIndex(int index, int key, @NotNull T value) {
        if (value == null) {
            IntObjectHashMap.$$$reportNull$$$0(0);
        }
        if (key == 0) {
            this.specialZeroValue = value;
            this.hasZeroValue = true;
        } else {
            this.values[index] = value;
        }
    }

    void addByIndex(int index, int key, @NotNull T value) {
        if (value == null) {
            IntObjectHashMap.$$$reportNull$$$0(1);
        }
        if (key == 0) {
            this.specialZeroValue = value;
            this.hasZeroValue = true;
            return;
        }
        if (this.size >= 2 * this.values.length / 3) {
            this.rehash();
            index = IntObjectHashMap.hashIndex(this.keys, key);
        }
        ++this.size;
        this.values[index] = value;
        this.keys[index] = key;
    }

    void put(int key, @NotNull T value) {
        int index;
        if (value == null) {
            IntObjectHashMap.$$$reportNull$$$0(2);
        }
        if (key == 0) {
            this.specialZeroValue = value;
            this.hasZeroValue = true;
            return;
        }
        if (this.size >= 2 * this.values.length / 3) {
            this.rehash();
        }
        if (this.values[index = IntObjectHashMap.hashIndex(this.keys, key)] == null) {
            ++this.size;
        }
        this.values[index] = value;
        if (this.keys[index] == 0) {
            this.keys[index] = key;
        }
    }

    int index(int key) {
        return key == 0 ? Integer.MIN_VALUE : IntObjectHashMap.hashIndex(this.keys, key);
    }

    private static int hashIndex(int @NotNull [] keys, int key) {
        int candidate;
        if (keys == null) {
            IntObjectHashMap.$$$reportNull$$$0(3);
        }
        int hash = (int)((long)key * 2654435769L & Integer.MAX_VALUE);
        int index = hash & keys.length - 1;
        while ((candidate = keys[index]) != 0) {
            if (candidate == key) {
                return index;
            }
            if (index == 0) {
                index = keys.length;
            }
            --index;
        }
        return index;
    }

    private void rehash() {
        int[] newKeys = new int[this.keys.length << 1];
        T[] newValues = this.arrayFactory.apply(newKeys.length);
        for (int i = this.keys.length - 1; i >= 0; --i) {
            int key = this.keys[i];
            if (key == 0) continue;
            int index = IntObjectHashMap.hashIndex(newKeys, key);
            newValues[index] = this.values[i];
            if (newKeys[index] != 0) continue;
            newKeys[index] = key;
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    public T get(int key) {
        return key == 0 ? this.specialZeroValue : this.values[IntObjectHashMap.hashIndex(this.keys, key)];
    }

    public T getByIndex(int index, int key) {
        return key == 0 ? this.specialZeroValue : this.values[index];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/lang/IntObjectHashMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceByIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addByIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hashIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

