/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaBinOpValue
extends DfaValue {
    @NotNull
    private final DfaVariableValue myLeft;
    @NotNull
    private final DfaValue myRight;
    @NotNull
    private final DfIntegralType myType;
    @NotNull
    private final LongRangeBinOp myOp;

    private DfaBinOpValue(@NotNull DfaVariableValue left, @NotNull DfaValue right, @NotNull DfIntegralType type, @NotNull LongRangeBinOp op) {
        if (left == null) {
            DfaBinOpValue.$$$reportNull$$$0(0);
        }
        if (right == null) {
            DfaBinOpValue.$$$reportNull$$$0(1);
        }
        if (type == null) {
            DfaBinOpValue.$$$reportNull$$$0(2);
        }
        if (op == null) {
            DfaBinOpValue.$$$reportNull$$$0(3);
        }
        super(left.getFactory());
        switch (op) {
            case PLUS: {
                if (right.getDfType() instanceof DfConstantType || right instanceof DfaVariableValue) break;
                throw new IllegalArgumentException("RHO must be constant or variable for plus");
            }
            case MINUS: {
                if (right instanceof DfaVariableValue) break;
                throw new IllegalArgumentException("RHO must be variable for minus");
            }
            case MOD: {
                if (right.getDfType() instanceof DfConstantType) break;
                throw new IllegalArgumentException("RHO must be constant for mod");
            }
            default: {
                throw new IllegalArgumentException("Unsupported op: " + op);
            }
        }
        this.myLeft = left;
        this.myRight = right;
        this.myType = type;
        this.myOp = op;
    }

    @NotNull
    public DfaVariableValue getLeft() {
        DfaVariableValue dfaVariableValue = this.myLeft;
        if (dfaVariableValue == null) {
            DfaBinOpValue.$$$reportNull$$$0(4);
        }
        return dfaVariableValue;
    }

    @NotNull
    public DfaValue getRight() {
        DfaValue dfaValue = this.myRight;
        if (dfaValue == null) {
            DfaBinOpValue.$$$reportNull$$$0(5);
        }
        return dfaValue;
    }

    @Override
    public DfaValue bindToFactory(@NotNull DfaValueFactory factory) {
        if (factory == null) {
            DfaBinOpValue.$$$reportNull$$$0(6);
        }
        return factory.getBinOpFactory().doCreate(this.myLeft.bindToFactory(factory), this.myRight.bindToFactory(factory), this.myType, this.myOp);
    }

    @Override
    @NotNull
    public DfIntegralType getDfType() {
        DfIntegralType dfIntegralType = this.myType;
        if (dfIntegralType == null) {
            DfaBinOpValue.$$$reportNull$$$0(7);
        }
        return dfIntegralType;
    }

    @Override
    public boolean dependsOn(DfaVariableValue other) {
        return this.myLeft.dependsOn(other) || this.myRight.dependsOn(other);
    }

    @NotNull
    public LongRangeBinOp getOperation() {
        LongRangeBinOp longRangeBinOp = this.myOp;
        if (longRangeBinOp == null) {
            DfaBinOpValue.$$$reportNull$$$0(8);
        }
        return longRangeBinOp;
    }

    public String toString() {
        long value2;
        String delimiter = this.myOp.toString();
        if (this.myOp == LongRangeBinOp.PLUS && this.myRight instanceof DfaTypeValue && (value2 = DfaBinOpValue.extractLong((DfaTypeValue)this.myRight)) < 0L) {
            delimiter = "";
        }
        return this.myLeft + delimiter + this.myRight;
    }

    private static long extractLong(DfaTypeValue right) {
        return Objects.requireNonNull(right.getDfType().getConstantOfType(Number.class)).longValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaBinOpValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaBinOpValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeft";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRight";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToFactory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory {
        private final DfaValueFactory myFactory;
        private final Map<Trinity<Long, LongRangeBinOp, DfType>, DfaBinOpValue> myValues = new HashMap<Trinity<Long, LongRangeBinOp, DfType>, DfaBinOpValue>();

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        public DfaValue create(DfaValue left, DfaValue right, DfaMemoryState state, DfIntegralType resultType, LongRangeBinOp op) {
            if (op == null) {
                return this.myFactory.getUnknown();
            }
            DfaValue value2 = this.doCreate(left, right, state, resultType, op);
            if (value2 != null) {
                return value2;
            }
            DfIntegralType leftType = (DfIntegralType)ObjectUtils.tryCast((Object)state.getDfType(left), DfIntegralType.class);
            DfIntegralType rightType = (DfIntegralType)ObjectUtils.tryCast((Object)state.getDfType(right), DfIntegralType.class);
            if (leftType == null || rightType == null) {
                return this.myFactory.fromDfType(resultType);
            }
            if (op == LongRangeBinOp.MUL) {
                if (LongRangeSet.point(1L).equals(leftType.getRange())) {
                    return right;
                }
                if (LongRangeSet.point(1L).equals(rightType.getRange())) {
                    return left;
                }
            }
            if (op == LongRangeBinOp.DIV && LongRangeSet.point(1L).equals(rightType.getRange())) {
                return left;
            }
            if ((op == LongRangeBinOp.SHL || op == LongRangeBinOp.SHR || op == LongRangeBinOp.USHR) && LongRangeSet.point(0L).equals(rightType.getRange())) {
                return left;
            }
            DfType resType = leftType.eval(rightType, op);
            return this.myFactory.fromDfType(resType);
        }

        @Nullable
        private DfaValue doCreate(DfaValue left, DfaValue right, DfaMemoryState state, DfIntegralType resultType, LongRangeBinOp op) {
            DfType rightDfType;
            Number rightConst;
            if (op != LongRangeBinOp.PLUS && op != LongRangeBinOp.MINUS && op != LongRangeBinOp.MOD) {
                return null;
            }
            DfType leftDfType = state.getDfType(left);
            Number leftConst = leftDfType.getConstantOfType(Number.class);
            if (leftConst != null) {
                left = left.getFactory().fromDfType(leftDfType);
            }
            if ((rightConst = (rightDfType = state.getDfType(right)).getConstantOfType(Number.class)) != null) {
                right = right.getFactory().fromDfType(rightDfType);
            }
            if (op == LongRangeBinOp.MINUS && state.areEqual(left, right)) {
                return this.myFactory.fromDfType(resultType.meetRange(LongRangeSet.point(0L)));
            }
            if (op == LongRangeBinOp.MOD) {
                long divisor;
                if (leftDfType instanceof DfIntegralType && rightDfType instanceof DfIntegralType && Factory.withinDivisorRange(state, left, right, ((DfIntegralType)leftDfType).getRange(), ((DfIntegralType)rightDfType).getRange())) {
                    return left;
                }
                if (left instanceof DfaVariableValue && rightConst != null && (divisor = rightConst.longValue()) > 1L && divisor <= 64L) {
                    return this.doCreate((DfaVariableValue)left, right, resultType, op);
                }
                return null;
            }
            if (leftConst != null && (right instanceof DfaVariableValue || right instanceof DfaBinOpValue) && op == LongRangeBinOp.PLUS) {
                return this.doCreate(right, left, state, resultType, op);
            }
            if (left instanceof DfaVariableValue) {
                if (right instanceof DfaVariableValue) {
                    if (op == LongRangeBinOp.PLUS && right.getID() > left.getID()) {
                        return this.doCreate((DfaVariableValue)right, left, resultType, op);
                    }
                    return this.doCreate((DfaVariableValue)left, right, resultType, op);
                }
                if (rightConst != null) {
                    long value2 = rightConst.longValue();
                    if (value2 == 0L) {
                        return left;
                    }
                    if (op == LongRangeBinOp.MINUS) {
                        right = this.myFactory.fromDfType(resultType.meetRange(LongRangeSet.point(value2).negate(resultType.getLongRangeType())));
                    }
                    return this.doCreate((DfaVariableValue)left, right, resultType, LongRangeBinOp.PLUS);
                }
            }
            if (left instanceof DfaBinOpValue) {
                DfaBinOpValue sumValue = (DfaBinOpValue)left;
                if (sumValue.getOperation() != LongRangeBinOp.PLUS && sumValue.getOperation() != LongRangeBinOp.MINUS) {
                    return null;
                }
                if (rightConst != null && sumValue.getRight() instanceof DfaTypeValue) {
                    DfType rightType = sumValue.getRight().getDfType();
                    LongRangeSet value1 = ((DfIntegralType)rightType).getRange();
                    LongRangeSet value2 = LongRangeSet.point(rightConst.longValue());
                    if (op == LongRangeBinOp.MINUS) {
                        value2 = value2.negate(resultType.getLongRangeType());
                    }
                    LongRangeSet res = value1.plus(value2, resultType.getLongRangeType());
                    right = this.myFactory.fromDfType(resultType.meetRange(res));
                    return this.create(sumValue.getLeft(), right, state, resultType, LongRangeBinOp.PLUS);
                }
                if (op == LongRangeBinOp.MINUS && sumValue.getOperation() == LongRangeBinOp.PLUS) {
                    if (state.areEqual(right, sumValue.getLeft())) {
                        return sumValue.getRight();
                    }
                    if (state.areEqual(right, sumValue.getRight())) {
                        return sumValue.getLeft();
                    }
                }
            }
            return null;
        }

        private static boolean withinDivisorRange(@NotNull DfaMemoryState state, @NotNull DfaValue dividend, @NotNull DfaValue divisor, @NotNull LongRangeSet dividendRange, @NotNull LongRangeSet divisorRange) {
            if (state == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (dividend == null) {
                Factory.$$$reportNull$$$0(1);
            }
            if (divisor == null) {
                Factory.$$$reportNull$$$0(2);
            }
            if (dividendRange == null) {
                Factory.$$$reportNull$$$0(3);
            }
            if (divisorRange == null) {
                Factory.$$$reportNull$$$0(4);
            }
            if (divisorRange.min() > 0L) {
                LongRangeBinOp prevOp;
                if (dividendRange.min() > -divisorRange.max() && (dividendRange.max() < divisorRange.min() || state.getRelation(dividend, divisor) == RelationType.LT)) {
                    return true;
                }
                if (dividend instanceof DfaBinOpValue && (prevOp = ((DfaBinOpValue)dividend).getOperation()) == LongRangeBinOp.MINUS) {
                    boolean positive;
                    boolean negative = dividendRange.max() <= 0L;
                    boolean bl = positive = dividendRange.min() >= 0L;
                    if (positive || negative) {
                        DfaVariableValue left = ((DfaBinOpValue)dividend).getLeft();
                        DfaValue right = ((DfaBinOpValue)dividend).getRight();
                        DfIntegralType leftType = (DfIntegralType)ObjectUtils.tryCast((Object)state.getDfType(left), DfIntegralType.class);
                        DfIntegralType rightType = (DfIntegralType)ObjectUtils.tryCast((Object)state.getDfType(right), DfIntegralType.class);
                        if (leftType != null && rightType != null) {
                            LongRangeSet leftRange = leftType.getRange();
                            LongRangeSet rightRange = rightType.getRange();
                            if (leftRange.min() >= 0L && rightRange.min() >= 0L) {
                                RelationType relation;
                                if (negative && ((relation = state.getRelation(right, divisor)) == RelationType.LT || relation == RelationType.EQ && leftRange.min() >= 1L)) {
                                    return true;
                                }
                                if (positive && ((relation = state.getRelation(left, divisor)) == RelationType.LT || relation == RelationType.EQ && rightRange.min() >= 1L)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
            return false;
        }

        @NotNull
        private DfaBinOpValue doCreate(DfaVariableValue left, DfaValue right, DfIntegralType resultType, LongRangeBinOp op) {
            long hash = (long)left.getID() << 32 | (long)right.getID();
            Trinity key = Trinity.create((Object)hash, (Object)((Object)op), (Object)resultType);
            DfaBinOpValue dfaBinOpValue = this.myValues.computeIfAbsent((Trinity<Long, LongRangeBinOp, DfType>)key, k -> new DfaBinOpValue(left, right, resultType, op));
            if (dfaBinOpValue == null) {
                Factory.$$$reportNull$$$0(5);
            }
            return dfaBinOpValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dividend";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divisor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dividendRange";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divisorRange";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaBinOpValue$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaBinOpValue$Factory";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doCreate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "withinDivisorRange";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

