/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.application.options.RegistryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.JBColor;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefOsrHandler;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JPanel;
import org.cef.browser.CefBrowser;
import org.jetbrains.annotations.NotNull;

class JBCefOsrComponent
extends JPanel {
    @NotNull
    private volatile JBCefOsrHandler myRenderHandler;
    @NotNull
    private volatile CefBrowser myBrowser;
    private double myScale = 1.0;
    @NotNull
    private Alarm myAlarm;
    @NotNull
    private Disposable myDisposable;

    JBCefOsrComponent() {
        this.setPreferredSize(JBCefBrowser.DEF_PREF_SIZE);
        this.setBackground(JBColor.background());
        this.addPropertyChangeListener("graphicsConfiguration", e -> {
            this.myScale = JBUIScale.sysScale((Component)this);
            this.myRenderHandler.updateScale(this.myScale);
        });
        this.enableEvents(131128L);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JBCefOsrComponent.this.myBrowser.setFocus(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                JBCefOsrComponent.this.myBrowser.setFocus(false);
            }
        });
    }

    public void setBrowser(@NotNull CefBrowser browser) {
        if (browser == null) {
            JBCefOsrComponent.$$$reportNull$$$0(0);
        }
        this.myBrowser = browser;
    }

    public void setRenderHandler(@NotNull JBCefOsrHandler renderHandler) {
        if (renderHandler == null) {
            JBCefOsrComponent.$$$reportNull$$$0(1);
        }
        this.myRenderHandler = renderHandler;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.myDisposable = Disposer.newDisposable();
        this.myAlarm = AlarmFactory.getInstance().create(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        if (!JBCefBrowserBase.isCefBrowserCreated(this.myBrowser)) {
            this.myBrowser.createImmediately();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myRenderHandler.paint((Graphics2D)g);
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.myBrowser.wasResized((int)Math.ceil((double)w * this.myScale), (int)Math.ceil((double)h * this.myScale)), 100);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        this.myBrowser.sendMouseEvent(e);
        if (e.getID() == 501) {
            this.requestFocusInWindow();
        }
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        super.processMouseWheelEvent(e);
        double val = e.getPreciseWheelRotation() * (double)RegistryManager.getInstance().intValue("ide.browser.jcef.osr.wheelRotation.factor");
        if (SystemInfoRt.isLinux || SystemInfoRt.isMac) {
            val *= -1.0;
        }
        this.myBrowser.sendMouseWheelEvent(new MouseWheelEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), (int)val, val));
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        this.myBrowser.sendMouseEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        this.myBrowser.sendKeyEvent(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderHandler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/jcef/JBCefOsrComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setRenderHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

