/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.SmartList;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.Externalizer;
import com.intellij.util.config.ListProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ExternalizablePropertyContainer
extends AbstractProperty.AbstractPropertyContainer {
    private static final Logger LOG = Logger.getInstance(ExternalizablePropertyContainer.class);
    private final Map<AbstractProperty, Object> myValues = new HashMap<AbstractProperty, Object>();
    private final Map<AbstractProperty, Externalizer> myExternalizers = new HashMap<AbstractProperty, Externalizer>();

    public <T> void registerProperty(AbstractProperty<T> property, Externalizer<T> externalizer) {
        String name = property.getName();
        LOG.assertTrue(!this.myExternalizers.containsKey(property), (Object)name);
        this.myExternalizers.put(property, externalizer);
    }

    public void rememberKey(AbstractProperty property) {
        LOG.assertTrue(this.myExternalizers.get(property) == null, (Object)property.getName());
        this.myExternalizers.put(property, null);
    }

    public <T> void registerProperty(ListProperty<T> property, @NonNls String itemTagName, Externalizer<T> itemExternalizer) {
        this.registerProperty(property, ExternalizablePropertyContainer.createListExternalizer(itemExternalizer, itemTagName));
    }

    private static <T> Externalizer<List<T>> createListExternalizer(Externalizer<T> itemExternalizer, String itemTagName) {
        return new ListExternalizer<T>(itemExternalizer, itemTagName);
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            ExternalizablePropertyContainer.$$$reportNull$$$0(0);
        }
        HashMap<String, AbstractProperty> propertyByName = new HashMap<String, AbstractProperty>();
        for (AbstractProperty abstractProperty : this.myExternalizers.keySet()) {
            propertyByName.put(abstractProperty.getName(), abstractProperty);
        }
        for (Element child : element.getChildren()) {
            Externalizer externalizer;
            AbstractProperty property = (AbstractProperty)propertyByName.get(child.getName());
            if (property == null || (externalizer = this.myExternalizers.get(property)) == null) continue;
            try {
                this.myValues.put(property, externalizer.readValue(child));
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            ExternalizablePropertyContainer.$$$reportNull$$$0(1);
        }
        if (this.myExternalizers.isEmpty()) {
            return;
        }
        ArrayList<AbstractProperty> properties = new ArrayList<AbstractProperty>(this.myExternalizers.keySet());
        properties.sort(AbstractProperty.NAME_COMPARATOR);
        for (AbstractProperty property : properties) {
            Object propValue;
            Externalizer externalizer = this.myExternalizers.get(property);
            if (externalizer == null || Comparing.equal(propValue = property.get(this), property.getDefault(this))) continue;
            Element child = new Element(property.getName());
            externalizer.writeValue(child, propValue);
            if (JDOMUtil.isEmpty((Element)child)) continue;
            element.addContent(child);
        }
    }

    protected Object getValueOf(AbstractProperty property) {
        Object value2 = this.myValues.get(property);
        return value2 != null ? value2 : property.getDefault(this);
    }

    protected void setValueOf(AbstractProperty externalizableProperty, Object value2) {
        this.myValues.put(externalizableProperty, value2);
    }

    @Override
    public boolean hasProperty(AbstractProperty property) {
        return this.myExternalizers.containsKey(property);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/util/config/ExternalizablePropertyContainer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ListExternalizer<T>
    implements Externalizer<List<T>> {
        @NonNls
        private static final String NULL_ELEMENT = "NULL_VALUE_ELEMENT";
        private final Externalizer<T> myItemExternalizer;
        private final String myItemTagName;

        ListExternalizer(Externalizer<T> itemExternalizer, String itemTagName) {
            this.myItemExternalizer = itemExternalizer;
            this.myItemTagName = itemTagName;
        }

        @Override
        public List<T> readValue(Element dataElement) {
            SmartList list = new SmartList();
            for (Element element : dataElement.getChildren()) {
                if (NULL_ELEMENT.equals(element.getName())) {
                    list.add(null);
                    continue;
                }
                if (!this.myItemTagName.equals(element.getName())) continue;
                T item = this.myItemExternalizer.readValue(element);
                if (item == null) {
                    LOG.error("Can't create element " + this.myItemExternalizer);
                    return list;
                }
                list.add(item);
            }
            return list;
        }

        @Override
        public void writeValue(Element dataElement, List<T> value2) {
            for (T item : value2) {
                if (item == null) {
                    dataElement.addContent(new Element(NULL_ELEMENT));
                    continue;
                }
                Element element = new Element(this.myItemTagName);
                this.myItemExternalizer.writeValue(element, item);
                if (item instanceof Externalizer.SkippableValue && JDOMUtil.isEmpty((Element)element)) continue;
                dataElement.addContent(element);
            }
        }
    }
}

