/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrResolveConfigurationProvider;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationBinder;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrContextRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>>
extends RunConfigurationProducer<CONFIGURATION> {
    protected final CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> myBinder;

    protected CidrContextRunConfigurationProducer(@NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        if (binder == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        super(true);
        this.myBinder = binder;
    }

    @NotNull
    protected List<TARGET> getTargetsForFile(@Nullable PsiFile containingFile, @NotNull Predicate<TARGET> condition) {
        if (condition == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (containingFile == null) {
            List list = Collections.emptyList();
            if (list == null) {
                CidrContextRunConfigurationProducer.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<OCResolveConfiguration> orderedConfigurations = new ArrayList<OCResolveConfiguration>(OCWorkspace.getInstance(containingFile.getProject()).getConfigurations());
        CidrResolveConfigurationProvider.EP_NAME.extensions().forEach(provider -> orderedConfigurations.retainAll(provider.getAllResolveConfigurationsForFile(containingFile, null)));
        ArrayList<TARGET> targets = new ArrayList<TARGET>(orderedConfigurations.size());
        for (OCResolveConfiguration configuration : orderedConfigurations) {
            TARGET target = this.myBinder.getTargetFromResolveConfiguration(configuration);
            if (target == null || !condition.test(target)) continue;
            targets.add(target);
        }
        List list = Collections.unmodifiableList(targets);
        if (list == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<TARGET> getExecutableTargetsForFile(@Nullable PsiFile containingFile) {
        List<CidrBuildTarget> list = this.getTargetsForFile(containingFile, CidrBuildTarget::isExecutable);
        if (list == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void setupTarget(@NotNull CONFIGURATION newConfigurationWithTemplateDefaults, @NotNull List<TARGET> targetsWithContext) {
        if (newConfigurationWithTemplateDefaults == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (targetsWithContext == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        this.findBuiltTargetAndConfiguration(newConfigurationWithTemplateDefaults, targetsWithContext, true);
    }

    @Nullable
    protected BuildTargetAndConfigurationData findBuiltTargetAndConfiguration(@NotNull CONFIGURATION configuration, @NotNull List<TARGET> targetsWithContext, boolean adjustConfigurationFromContext) {
        Pair<TARGET, BC> selectedTargetAndConfig;
        if (configuration == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (targetsWithContext == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (targetsWithContext.isEmpty()) {
            return null;
        }
        CidrBuildTarget target = null;
        CidrBuildConfigurationHelper<CidrBuildConfiguration, CidrBuildTarget> helper = ((CidrRunConfiguration)configuration).getHelper();
        Project project = configuration.getProject();
        BuildTargetAndConfigurationData data = null;
        RunnerAndConfigurationSettings selectedSettings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (selectedSettings != null && this.myBinder.isSupportedRunConfiguration(selectedSettings.getConfiguration())) {
            selectedTargetAndConfig = this.myBinder.getTargetAndConfiguration((CidrRunConfiguration)selectedSettings.getConfiguration());
            data = helper.findSimilarValidInTargets((CidrBuildTarget)selectedTargetAndConfig.first, (CidrBuildConfiguration)selectedTargetAndConfig.second, targetsWithContext);
        }
        if (data == null) {
            selectedTargetAndConfig = this.myBinder.getTargetAndConfiguration(configuration);
            data = helper.findSimilarValidInTargets((CidrBuildTarget)selectedTargetAndConfig.first, (CidrBuildConfiguration)selectedTargetAndConfig.second, targetsWithContext);
        }
        if (data != null && data.target != null) {
            target = (CidrBuildTarget)helper.findTarget(data.target, targetsWithContext);
        }
        if (target == null) {
            data = null;
            target = (CidrBuildTarget)targetsWithContext.get(0);
        }
        assert (target != null);
        BuildTargetData buildTargetData = new BuildTargetData(target);
        if (data == null) {
            Object buildConfiguration = ((CidrRunConfiguration)configuration).getHelper().getDefaultConfiguration(target);
            data = new BuildTargetAndConfigurationData(buildTargetData, buildConfiguration == null ? null : buildConfiguration.getName());
        }
        if (adjustConfigurationFromContext) {
            if (configuration instanceof CidrExecutableDataHolder) {
                ((CidrExecutableDataHolder)configuration).setExecutableData(new ExecutableData(buildTargetData));
            }
            ((CidrRunConfiguration)configuration).setTargetAndConfigurationData(data);
        }
        return data;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrContextRunConfigurationProducer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfigurationWithTemplateDefaults";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetsWithContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrContextRunConfigurationProducer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsForFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutableTargetsForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTargetsForFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupTarget";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findBuiltTargetAndConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

