/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class HeadersSearchPath {
    private static final int RECURSIVE = 1;
    private static final int KIND = 2;
    private static final int FRAMEWORK = 4;
    private static final int BUILTIN = 8;
    @NlsSafe
    @NotNull
    private final String myPath;
    private final int myFlags;

    public HeadersSearchPath(@NlsSafe @NotNull String path, int flags) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(0);
        }
        this.myPath = path;
        this.myFlags = flags;
    }

    public HeadersSearchPath(@NotNull File file, boolean recursive, @NotNull Kind kind) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(1);
        }
        if (kind == null) {
            HeadersSearchPath.$$$reportNull$$$0(2);
        }
        this(file.getPath(), recursive, kind);
    }

    public HeadersSearchPath(@NlsSafe @NotNull String path, boolean recursive, @NotNull Kind kind) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(3);
        }
        if (kind == null) {
            HeadersSearchPath.$$$reportNull$$$0(4);
        }
        this(path, recursive, kind, false);
    }

    public HeadersSearchPath(@NotNull File file, boolean recursive, @NotNull Kind kind, boolean frameworksSearchPath) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(5);
        }
        if (kind == null) {
            HeadersSearchPath.$$$reportNull$$$0(6);
        }
        this(file.getPath(), recursive, kind, frameworksSearchPath);
    }

    public HeadersSearchPath(@NotNull File file, boolean recursive, @NotNull Kind kind, boolean frameworksSearchPath, boolean systemSeachPath) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(7);
        }
        if (kind == null) {
            HeadersSearchPath.$$$reportNull$$$0(8);
        }
        this(file.getPath(), recursive, kind, frameworksSearchPath, systemSeachPath);
    }

    public HeadersSearchPath(@NlsSafe @NotNull String path, boolean recursive, @NotNull Kind kind, boolean frameworksSearchPath) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(9);
        }
        if (kind == null) {
            HeadersSearchPath.$$$reportNull$$$0(10);
        }
        this(path, recursive, kind, frameworksSearchPath, false);
    }

    public HeadersSearchPath(@NlsSafe @NotNull String path, boolean recursive, @NotNull Kind kind, boolean frameworksSearchPath, boolean builtInSearchPath) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(11);
        }
        if (kind == null) {
            HeadersSearchPath.$$$reportNull$$$0(12);
        }
        this(path, (recursive ? 1 : 0) | kind.ordinal() * 2 | (frameworksSearchPath ? 4 : 0) | (builtInSearchPath ? 8 : 0));
    }

    @NotNull
    public static HeadersSearchPath includes(@NlsSafe @NotNull String path) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(13);
        }
        return new HeadersSearchPath(path, false, Kind.SYSTEM);
    }

    @NotNull
    public static HeadersSearchPath includes(@NotNull File file) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(14);
        }
        return HeadersSearchPath.includes(file.getPath());
    }

    @NotNull
    public static HeadersSearchPath userIncludes(@NlsSafe @NotNull String path) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(15);
        }
        return new HeadersSearchPath(path, false, Kind.USER);
    }

    @NotNull
    public static HeadersSearchPath builtInIncludes(@NotNull File file) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(16);
        }
        return HeadersSearchPath.builtInIncludes(file.getPath());
    }

    @NotNull
    public static HeadersSearchPath builtInIncludes(@NlsSafe @NotNull String path) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(17);
        }
        return new HeadersSearchPath(path, false, Kind.SYSTEM, false, true);
    }

    @NotNull
    public static HeadersSearchPath userIncludes(@NotNull File file) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(18);
        }
        return HeadersSearchPath.userIncludes(file.getPath());
    }

    @NotNull
    public static HeadersSearchPath frameworks(@NlsSafe @NotNull String path) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(19);
        }
        return new HeadersSearchPath(path, false, Kind.SYSTEM, true);
    }

    @NotNull
    public static HeadersSearchPath frameworks(@NotNull File file) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(20);
        }
        return HeadersSearchPath.frameworks(file.getPath());
    }

    @NlsSafe
    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            HeadersSearchPath.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getUrl() {
        String string = VfsUtilCore.pathToUrl((String)this.myPath);
        if (string == null) {
            HeadersSearchPath.$$$reportNull$$$0(22);
        }
        return string;
    }

    public boolean isRecursive() {
        return (this.myFlags & 1) != 0;
    }

    @NotNull
    public Kind getKind() {
        boolean isUser = (this.myFlags & 2) != 0;
        Kind kind = Kind.fromBoolean(isUser);
        if (kind == null) {
            HeadersSearchPath.$$$reportNull$$$0(23);
        }
        return kind;
    }

    public boolean isBuiltInHeaders() {
        return (this.myFlags & 8) != 0;
    }

    public boolean isFrameworksSearchPath() {
        return (this.myFlags & 4) != 0;
    }

    public int getFlags() {
        return this.myFlags;
    }

    public boolean isAncestorOf(@NotNull VirtualFile file, boolean checkRecursive) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(24);
        }
        return FileUtil.pathsEqual((String)this.getPath(), (String)file.getParent().getPath()) || (this.isRecursive() || !checkRecursive) && FileUtil.isAncestor((String)this.getPath(), (String)file.getPath(), (boolean)true);
    }

    @NotNull
    public HeadersSearchPath createNonRecursiveChildPath(@NlsSafe @NotNull String path) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(25);
        }
        if (!this.isRecursive()) {
            HeadersSearchPath headersSearchPath = this;
            if (headersSearchPath == null) {
                HeadersSearchPath.$$$reportNull$$$0(26);
            }
            return headersSearchPath;
        }
        return new HeadersSearchPath(path, this.getFlags() ^ 1);
    }

    public String toString() {
        return "HeadersSearchPath{" + this.myPath + ", " + this.getKind().toString() + ", " + (this.isRecursive() ? "recursive" : "non-recursive") + (this.isFrameworksSearchPath() ? ", frameworks" : "") + (this.isBuiltInHeaders() ? ", builtin" : "") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeadersSearchPath that = (HeadersSearchPath)o;
        if (this.myFlags != that.myFlags) {
            return false;
        }
        return FileUtil.pathsEqual((String)this.myPath, (String)that.myPath);
    }

    public int hashCode() {
        int result = FileUtil.pathHashCode((String)this.myPath);
        result = 31 * result + this.myFlags;
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createNonRecursiveChildPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "includes";
                break;
            }
            case 15: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "userIncludes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "builtInIncludes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "frameworks";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAncestorOf";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createNonRecursiveChildPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Kind {
        SYSTEM,
        USER,
        FRAMEWORK;


        @NotNull
        public String toString() {
            switch (this) {
                case SYSTEM: {
                    return "system";
                }
                case USER: {
                    return "user";
                }
                case FRAMEWORK: {
                    return "framework";
                }
            }
            throw new IllegalArgumentException(this.name());
        }

        public boolean isSystem() {
            return this == SYSTEM || this == FRAMEWORK;
        }

        public boolean isUser() {
            return this == USER;
        }

        public boolean isFramework() {
            return this == FRAMEWORK;
        }

        @NotNull
        public static Kind fromBoolean(boolean isUser) {
            Kind kind = isUser ? USER : SYSTEM;
            if (kind == null) {
                Kind.$$$reportNull$$$0(0);
            }
            return kind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath$Kind", "fromBoolean"));
        }
    }

    @FunctionalInterface
    public static interface FilePointerFactory {
        @NotNull
        public VirtualFilePointer create(@NlsSafe @NotNull String var1);
    }
}

