/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.electromechanical;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.Display;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.core.measures.Voltage;
import org.diylc.core.measures.VoltageUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Mini Relay", author="Branislav Stojkovic", category="Electromechanical", instanceNamePrefix="RY", description="Miniature PCB mount relay, like Omron G5V-1 or G5V-2", stretchable=false, zOrder=4.0)
public class MiniRelay
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Color BODY_COLOR = Color.gray;
    public static Color BORDER_COLOR = Color.gray.darker();
    public static Color PIN_COLOR = Color.decode("#00B2EE");
    public static Color PIN_BORDER_COLOR = PIN_COLOR.darker();
    public static Color INDENT_COLOR = Color.gray.darker();
    public static Color LABEL_COLOR = Color.white;
    public static int EDGE_RADIUS = 6;
    public static Size PIN_SIZE = new Size(Double.valueOf(0.03), SizeUnit.in);
    public static Size INDENT_SIZE = new Size(Double.valueOf(0.07), SizeUnit.in);
    public static Size BODY_MARGIN = new Size(Double.valueOf(0.05), SizeUnit.in);
    public static Size MINI_PIN_SPACING = new Size(Double.valueOf(0.2), SizeUnit.in);
    public static Size MINI_ROW_SPACING = new Size(Double.valueOf(0.3), SizeUnit.in);
    public static Size MINI_WIDTH = new Size(Double.valueOf(20.1), SizeUnit.mm);
    public static Size MINI_HEIGHT = new Size(Double.valueOf(9.9), SizeUnit.mm);
    public static Size MINI_GAP = new Size(Double.valueOf(0.1), SizeUnit.in);
    public static Size ULTRA_PIN_SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    public static Size ULTRA_ROW_SPACING = new Size(Double.valueOf(0.2), SizeUnit.in);
    public static Size ULTRA_WIDTH = new Size(Double.valueOf(12.2), SizeUnit.mm);
    public static Size ULTRA_HEIGHT = new Size(Double.valueOf(7.2), SizeUnit.mm);
    public static Size ULTRA_GAP = new Size(Double.valueOf(0.1), SizeUnit.in);
    private String value = "";
    private Orientation orientation = Orientation.DEFAULT;
    private Point[] controlPoints = new Point[]{new Point(0, 0)};
    protected Display display = Display.NAME;
    private RelayType type = RelayType.DPDT;
    private RelaySize size = RelaySize.Miniature;
    private Voltage voltage = new Voltage(Double.valueOf(12.0), VoltageUnit.V);
    private transient Area[] body;

    public MiniRelay() {
        this.updateControlPoints();
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public Display getDisplay() {
        if (this.display == null) {
            this.display = Display.VALUE;
        }
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    private void updateControlPoints() {
        Point firstPoint = this.controlPoints[0];
        int pinCount = 0;
        switch (this.type) {
            case DPDT: {
                pinCount = 8;
                break;
            }
            case SPDT: {
                pinCount = 6;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected type: " + (Object)((Object)this.type));
            }
        }
        this.controlPoints = new Point[pinCount];
        this.controlPoints[0] = firstPoint;
        int pinSpacing = this.size == RelaySize.Miniature ? (int)MINI_PIN_SPACING.convertToPixels() : (int)ULTRA_PIN_SPACING.convertToPixels();
        int rowSpacing = this.size == RelaySize.Miniature ? (int)MINI_ROW_SPACING.convertToPixels() : (int)ULTRA_ROW_SPACING.convertToPixels();
        int delta = 0;
        for (int i = 0; i < pinCount / 2; ++i) {
            int dy2;
            int dx2;
            int dy1;
            int dx1;
            if (i == 1) {
                int n = delta = this.size == RelaySize.Miniature ? (int)MINI_GAP.convertToPixels() : (int)ULTRA_GAP.convertToPixels();
                if (this.type == RelayType.SPDT) {
                    delta += pinSpacing;
                }
            }
            switch (this.orientation) {
                case DEFAULT: {
                    dx1 = 0;
                    dy1 = i * pinSpacing + delta;
                    dx2 = rowSpacing;
                    dy2 = i * pinSpacing + delta;
                    break;
                }
                case _90: {
                    dx1 = -(i * pinSpacing + delta);
                    dy1 = 0;
                    dx2 = -(i * pinSpacing + delta);
                    dy2 = rowSpacing;
                    break;
                }
                case _180: {
                    dx1 = 0;
                    dy1 = -(i * pinSpacing + delta);
                    dx2 = -rowSpacing;
                    dy2 = -(i * pinSpacing + delta);
                    break;
                }
                case _270: {
                    dx1 = i * pinSpacing + delta;
                    dy1 = 0;
                    dx2 = i * pinSpacing + delta;
                    dy2 = -rowSpacing;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
            this.controlPoints[i] = new Point(firstPoint.x + dx1, firstPoint.y + dy1);
            this.controlPoints[i + pinCount / 2] = new Point(firstPoint.x + dx2, firstPoint.y + dy2);
        }
    }

    public Area[] getBody() {
        if (this.body == null) {
            this.body = new Area[2];
            int x = this.controlPoints[0].x;
            int y = this.controlPoints[0].y;
            int centerX = (this.controlPoints[0].x + this.controlPoints[this.controlPoints.length - 1].x) / 2;
            int centerY = (this.controlPoints[0].y + this.controlPoints[this.controlPoints.length - 1].y) / 2;
            int bodyMargin = this.getClosestOdd(BODY_MARGIN.convertToPixels());
            int width = 0;
            int height = 0;
            int rowSpacing = this.size == RelaySize.Miniature ? (int)MINI_ROW_SPACING.convertToPixels() : (int)ULTRA_ROW_SPACING.convertToPixels();
            Area indentation = null;
            int indentationSize = this.getClosestOdd(INDENT_SIZE.convertToPixels());
            switch (this.orientation) {
                case DEFAULT: {
                    width = (int)(this.size == RelaySize.Miniature ? MINI_HEIGHT.convertToPixels() : ULTRA_HEIGHT.convertToPixels());
                    height = (int)(this.size == RelaySize.Miniature ? MINI_WIDTH.convertToPixels() : ULTRA_WIDTH.convertToPixels());
                    x -= bodyMargin;
                    indentation = new Area(new Rectangle2D.Double(centerX - indentationSize / 2, (y -= bodyMargin) - indentationSize / 2, indentationSize, indentationSize));
                    break;
                }
                case _90: {
                    width = (int)(this.size == RelaySize.Miniature ? MINI_WIDTH.convertToPixels() : ULTRA_WIDTH.convertToPixels());
                    height = (int)(this.size == RelaySize.Miniature ? MINI_HEIGHT.convertToPixels() : ULTRA_HEIGHT.convertToPixels());
                    y -= bodyMargin;
                    indentation = new Area(new Rectangle2D.Double((x -= -bodyMargin + width) + width - indentationSize / 2, centerY - indentationSize / 2, indentationSize, indentationSize));
                    break;
                }
                case _180: {
                    width = (int)(this.size == RelaySize.Miniature ? MINI_HEIGHT.convertToPixels() : ULTRA_HEIGHT.convertToPixels());
                    height = (int)(this.size == RelaySize.Miniature ? MINI_WIDTH.convertToPixels() : ULTRA_WIDTH.convertToPixels());
                    x -= rowSpacing + bodyMargin;
                    indentation = new Area(new Rectangle2D.Double(centerX - indentationSize / 2, (y -= -bodyMargin + height) + height - indentationSize / 2, indentationSize, indentationSize));
                    break;
                }
                case _270: {
                    width = (int)(this.size == RelaySize.Miniature ? MINI_WIDTH.convertToPixels() : ULTRA_WIDTH.convertToPixels());
                    height = (int)(this.size == RelaySize.Miniature ? MINI_HEIGHT.convertToPixels() : ULTRA_HEIGHT.convertToPixels());
                    y -= bodyMargin + rowSpacing;
                    indentation = new Area(new Rectangle2D.Double((x -= bodyMargin) - indentationSize / 2, centerY - indentationSize / 2, indentationSize, indentationSize));
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
            this.body[0] = new Area(new RoundRectangle2D.Double(centerX - width / 2, centerY - height / 2, width, height, EDGE_RADIUS, EDGE_RADIUS));
            this.body[1] = indentation;
            if (indentation != null) {
                indentation.intersect(this.body[0]);
            }
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        Area mainArea = this.getBody()[0];
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : BODY_COLOR);
        g2d.fill(mainArea);
        g2d.setComposite(oldComposite);
        Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
        int pinSize = (int)PIN_SIZE.convertToPixels() / 2 * 2;
        for (Point point : this.controlPoints) {
            if (!outlineMode) {
                g2d.setColor(PIN_COLOR);
                g2d.fillOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
            }
            g2d.setColor(outlineMode ? theme.getOutlineColor() : PIN_BORDER_COLOR);
            g2d.drawOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
        }
        Color finalBorderColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : BORDER_COLOR);
        g2d.setColor(finalBorderColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        if (outlineMode) {
            Area area = new Area(mainArea);
            area.subtract(this.getBody()[1]);
            g2d.draw(area);
        } else {
            g2d.draw(mainArea);
            if (this.getBody()[1] != null) {
                g2d.setColor(INDENT_COLOR);
                g2d.fill(this.getBody()[1]);
            }
        }
        g2d.setFont(LABEL_FONT);
        Color finalLabelColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : LABEL_COLOR);
        g2d.setColor(finalLabelColor);
        FontMetrics fontMetrics = g2d.getFontMetrics(g2d.getFont());
        String label = this.display == Display.NAME ? this.getName() : this.getValue();
        Rectangle2D rect = fontMetrics.getStringBounds(label, g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        Rectangle bounds = mainArea.getBounds();
        int x = bounds.x + (bounds.width - textWidth) / 2;
        int y = bounds.y + (bounds.height - textHeight) / 2 + fontMetrics.getAscent();
        g2d.drawString(label, x, y);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int radius = 6 * width / 32;
        g2d.setColor(BODY_COLOR);
        g2d.fillRoundRect(width / 6, 1, 4 * width / 6, height - 4, radius, radius);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect(width / 6, 1, 4 * width / 6, height - 4, radius, radius);
        int pinSize = 2 * width / 32;
        g2d.setColor(PIN_COLOR);
        for (int i = 0; i < 4; ++i) {
            if (i == 1) continue;
            g2d.fillOval(width / 4, height / 5 * (i + 1) - 1, pinSize, pinSize);
            g2d.fillOval(3 * width / 4 - pinSize, height / 5 * (i + 1) - 1, pinSize, pinSize);
        }
    }

    public String getValueForDisplay() {
        return this.getValue() + " " + (Object)((Object)this.getType()) + " " + this.getVoltage();
    }

    @EditableProperty
    public RelayType getType() {
        return this.type;
    }

    public void setType(RelayType type) {
        this.type = type;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public Voltage getVoltage() {
        return this.voltage;
    }

    public void setVoltage(Voltage voltage) {
        this.voltage = voltage;
    }

    @EditableProperty
    public RelaySize getSize() {
        return this.size;
    }

    public void setSize(RelaySize size) {
        this.size = size;
        this.updateControlPoints();
        this.body = null;
    }

    public static enum RelaySize {
        Miniature,
        Ultra_miniature;


        public String toString() {
            return this.name().replace('_', '-');
        }
    }

    public static enum RelayType {
        SPDT,
        DPDT;

    }
}

