/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum PasswordValidationDetailsResponseType {
    VALIDATION_DETAILS(-96),
    NO_PASSWORD_PROVIDED(-127),
    MULTIPLE_PASSWORDS_PROVIDED(-126),
    NO_VALIDATION_ATTEMPTED(-125);

    private final byte berType;

    private PasswordValidationDetailsResponseType(byte berType) {
        this.berType = berType;
    }

    public byte getBERType() {
        return this.berType;
    }

    public static PasswordValidationDetailsResponseType forBERType(byte berType) {
        for (PasswordValidationDetailsResponseType t : PasswordValidationDetailsResponseType.values()) {
            if (t.berType != berType) continue;
            return t;
        }
        return null;
    }

    public static PasswordValidationDetailsResponseType forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "validationdetails": 
            case "validation-details": 
            case "validation_details": {
                return VALIDATION_DETAILS;
            }
            case "nopasswordprovided": 
            case "no-password-provided": 
            case "no_password_provided": {
                return NO_PASSWORD_PROVIDED;
            }
            case "multiplepasswordsprovided": 
            case "multiple-passwords-provided": 
            case "multiple_passwords_provided": {
                return MULTIPLE_PASSWORDS_PROVIDED;
            }
            case "novalidationattempted": 
            case "no-validation-attempted": 
            case "no_validation_attempted": {
                return NO_VALIDATION_ATTEMPTED;
            }
        }
        return null;
    }
}

