/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.indexlifecycle.IndexLifecycleExplainResponse;

public class ExplainLifecycleResponse
extends ActionResponse
implements ToXContentObject {
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private Map<String, IndexLifecycleExplainResponse> indexResponses;
    private static final ConstructingObjectParser<ExplainLifecycleResponse, Void> PARSER = new ConstructingObjectParser("explain_lifecycle_response", a -> new ExplainLifecycleResponse(((List)a[0]).stream().collect(Collectors.toMap(IndexLifecycleExplainResponse::getIndex, Function.identity()))));

    public static ExplainLifecycleResponse fromXContent(XContentParser parser) {
        return (ExplainLifecycleResponse)((Object)PARSER.apply(parser, null));
    }

    public ExplainLifecycleResponse() {
    }

    public ExplainLifecycleResponse(Map<String, IndexLifecycleExplainResponse> indexResponses) {
        this.indexResponses = indexResponses;
    }

    public Map<String, IndexLifecycleExplainResponse> getIndexResponses() {
        return this.indexResponses;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(INDICES_FIELD.getPreferredName());
        for (IndexLifecycleExplainResponse indexResponse : this.indexResponses.values()) {
            builder.field(indexResponse.getIndex(), (ToXContent)indexResponse);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public void readFrom(StreamInput in) throws IOException {
        int size = in.readVInt();
        HashMap<String, IndexLifecycleExplainResponse> indexResponses = new HashMap<String, IndexLifecycleExplainResponse>(size);
        for (int i = 0; i < size; ++i) {
            IndexLifecycleExplainResponse indexResponse = new IndexLifecycleExplainResponse(in);
            indexResponses.put(indexResponse.getIndex(), indexResponse);
        }
        this.indexResponses = indexResponses;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.indexResponses.size());
        for (IndexLifecycleExplainResponse e : this.indexResponses.values()) {
            e.writeTo(out);
        }
    }

    public int hashCode() {
        return Objects.hash(this.indexResponses);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ExplainLifecycleResponse other = (ExplainLifecycleResponse)((Object)obj);
        return Objects.equals(this.indexResponses, other.indexResponses);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> (IndexLifecycleExplainResponse)IndexLifecycleExplainResponse.PARSER.apply(p, c), INDICES_FIELD);
    }
}

