/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleAction;
import org.elasticsearch.xpack.core.indexlifecycle.Step;
import org.elasticsearch.xpack.core.indexlifecycle.UpdateSettingsStep;

public class SetPriorityAction
implements LifecycleAction {
    public static final String NAME = "set_priority";
    private static final ParseField RECOVERY_PRIORITY_FIELD = new ParseField("priority", new String[0]);
    private static final ConstructingObjectParser<SetPriorityAction, Void> PARSER = new ConstructingObjectParser("set_priority", a -> new SetPriorityAction((Integer)a[0]));
    final Integer recoveryPriority;

    public static SetPriorityAction parse(XContentParser parser) {
        return (SetPriorityAction)PARSER.apply(parser, null);
    }

    public SetPriorityAction(@Nullable Integer recoveryPriority) {
        if (recoveryPriority != null && recoveryPriority < 0) {
            throw new IllegalArgumentException("[" + RECOVERY_PRIORITY_FIELD.getPreferredName() + "] must be 0 or greater");
        }
        this.recoveryPriority = recoveryPriority;
    }

    public SetPriorityAction(StreamInput in) throws IOException {
        this(in.readOptionalVInt());
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(RECOVERY_PRIORITY_FIELD.getPreferredName(), this.recoveryPriority);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.recoveryPriority);
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey key = new Step.StepKey(phase, NAME, NAME);
        Settings indexPriority = this.recoveryPriority == null ? Settings.builder().putNull(IndexMetaData.INDEX_PRIORITY_SETTING.getKey()).build() : Settings.builder().put(IndexMetaData.INDEX_PRIORITY_SETTING.getKey(), this.recoveryPriority.intValue()).build();
        return Collections.singletonList(new UpdateSettingsStep(key, nextStepKey, client, indexPriority));
    }

    @Override
    public List<Step.StepKey> toStepKeys(String phase) {
        return Collections.singletonList(new Step.StepKey(phase, NAME, NAME));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetPriorityAction that = (SetPriorityAction)o;
        return this.recoveryPriority != null ? this.recoveryPriority.equals(that.recoveryPriority) : that.recoveryPriority == null;
    }

    public int hashCode() {
        return this.recoveryPriority != null ? this.recoveryPriority.hashCode() : 0;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : Integer.valueOf(p.intValue()), RECOVERY_PRIORITY_FIELD, ObjectParser.ValueType.INT_OR_NULL);
    }
}

