/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.email;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.elasticsearch.xpack.watcher.notification.email.Attachment;
import org.elasticsearch.xpack.watcher.notification.email.Email;

public enum Profile {
    STANDARD{

        @Override
        public String textBody(MimeMessage msg) throws IOException, MessagingException {
            MimeBodyPart part;
            int i;
            MimeMultipart mixed = (MimeMultipart)msg.getContent();
            MimeMultipart related = null;
            for (int i2 = 0; i2 < mixed.getCount(); ++i2) {
                MimeBodyPart part2 = (MimeBodyPart)mixed.getBodyPart(i2);
                if (!part2.getContentType().startsWith("multipart/related")) continue;
                related = (MimeMultipart)part2.getContent();
                break;
            }
            if (related == null) {
                throw new IllegalStateException("could not extract body text from mime message using [standard] profile. could not find part content type with [multipart/related]");
            }
            MimeMultipart alternative = null;
            for (i = 0; i < related.getCount(); ++i) {
                part = (MimeBodyPart)related.getBodyPart(i);
                if (!part.getContentType().startsWith("multipart/alternative")) continue;
                alternative = (MimeMultipart)part.getContent();
                break;
            }
            if (alternative == null) {
                throw new IllegalStateException("could not extract body text from mime message using [standard] profile. could not find part content type with [multipart/alternative]");
            }
            for (i = 0; i < alternative.getCount(); ++i) {
                part = (MimeBodyPart)alternative.getBodyPart(i);
                if (!part.getContentType().startsWith("text/plain")) continue;
                return (String)part.getContent();
            }
            throw new IllegalStateException("could not extract body text from mime message using [standard] profile");
        }

        @Override
        public MimeMessage toMimeMessage(Email email, Session session) throws MessagingException {
            MimeMessage message = 1.createCommon(email, session);
            MimeMultipart mixed = new MimeMultipart("mixed");
            message.setContent((Multipart)mixed);
            MimeMultipart related = new MimeMultipart("related");
            mixed.addBodyPart((BodyPart)1.wrap(related, null));
            MimeMultipart alternative = new MimeMultipart("alternative");
            related.addBodyPart((BodyPart)1.wrap(alternative, "text/alternative"));
            MimeBodyPart text = new MimeBodyPart();
            if (email.textBody != null) {
                text.setText(email.textBody, StandardCharsets.UTF_8.name());
            } else {
                text.setText("", StandardCharsets.UTF_8.name());
            }
            alternative.addBodyPart((BodyPart)text);
            if (email.htmlBody != null) {
                MimeBodyPart html = new MimeBodyPart();
                html.setText(email.htmlBody, StandardCharsets.UTF_8.name(), "html");
                alternative.addBodyPart((BodyPart)html);
            }
            if (!email.attachments.isEmpty()) {
                for (Attachment attachment : email.attachments.values()) {
                    if (attachment.isInline()) {
                        related.addBodyPart((BodyPart)attachment.bodyPart());
                        continue;
                    }
                    mixed.addBodyPart((BodyPart)attachment.bodyPart());
                }
            }
            return message;
        }
    }
    ,
    OUTLOOK{

        @Override
        public String textBody(MimeMessage msg) throws IOException, MessagingException {
            return STANDARD.textBody(msg);
        }

        @Override
        public MimeMessage toMimeMessage(Email email, Session session) throws MessagingException {
            return STANDARD.toMimeMessage(email, session);
        }
    }
    ,
    GMAIL{

        @Override
        public String textBody(MimeMessage msg) throws IOException, MessagingException {
            return STANDARD.textBody(msg);
        }

        @Override
        public MimeMessage toMimeMessage(Email email, Session session) throws MessagingException {
            return STANDARD.toMimeMessage(email, session);
        }
    }
    ,
    MAC{

        @Override
        public String textBody(MimeMessage msg) throws IOException, MessagingException {
            return STANDARD.textBody(msg);
        }

        @Override
        public MimeMessage toMimeMessage(Email email, Session session) throws MessagingException {
            return STANDARD.toMimeMessage(email, session);
        }
    };

    static final String MESSAGE_ID_HEADER = "Message-ID";

    public abstract MimeMessage toMimeMessage(Email var1, Session var2) throws MessagingException;

    public abstract String textBody(MimeMessage var1) throws IOException, MessagingException;

    public static Profile resolve(String name) {
        Profile profile = Profile.resolve(name, null);
        if (profile == null) {
            throw new IllegalArgumentException("[" + name + "] is an unknown email profile");
        }
        return profile;
    }

    public static Profile resolve(String name, Profile defaultProfile) {
        if (name == null) {
            return defaultProfile;
        }
        switch (name.toLowerCase(Locale.ROOT)) {
            case "std": 
            case "standard": {
                return STANDARD;
            }
            case "outlook": {
                return OUTLOOK;
            }
            case "gmail": {
                return GMAIL;
            }
            case "mac": {
                return MAC;
            }
        }
        return defaultProfile;
    }

    static MimeMessage createCommon(Email email, Session session) throws MessagingException {
        MimeMessage message = new MimeMessage(session);
        message.setHeader(MESSAGE_ID_HEADER, email.id);
        if (email.from != null) {
            message.setFrom((Address)email.from);
        }
        if (email.replyTo != null) {
            message.setReplyTo((Address[])email.replyTo.toArray());
        }
        if (email.priority != null) {
            email.priority.applyTo(message);
        }
        message.setSentDate(email.sentDate.toDate());
        message.setRecipients(Message.RecipientType.TO, (Address[])email.to.toArray());
        if (email.cc != null) {
            message.setRecipients(Message.RecipientType.CC, (Address[])email.cc.toArray());
        }
        if (email.bcc != null) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])email.bcc.toArray());
        }
        if (email.subject != null) {
            message.setSubject(email.subject, StandardCharsets.UTF_8.name());
        } else {
            message.setSubject("", StandardCharsets.UTF_8.name());
        }
        return message;
    }

    static MimeBodyPart wrap(MimeMultipart multipart, String contentType) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        if (contentType == null) {
            part.setContent((Multipart)multipart);
        } else {
            part.setContent((Object)multipart, contentType);
        }
        return part;
    }
}

