/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit.index;

import java.util.function.Function;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class IndexNameResolver {
    private IndexNameResolver() {
    }

    public static String resolve(DateTime timestamp, Rollover rollover) {
        return rollover.formatter().print((ReadableInstant)timestamp);
    }

    public static String resolveNext(String indexNamePrefix, DateTime timestamp, Rollover rollover) {
        return IndexNameResolver.resolve(indexNamePrefix, rollover.getNext().apply(timestamp), rollover);
    }

    public static String resolve(String indexNamePrefix, DateTime timestamp, Rollover rollover) {
        return indexNamePrefix + IndexNameResolver.resolve(timestamp, rollover);
    }

    public static enum Rollover {
        HOURLY("-yyyy.MM.dd.HH", d -> d.plusHours(1)),
        DAILY("-yyyy.MM.dd", d -> d.plusDays(1)),
        WEEKLY("-yyyy.w", d -> d.plusWeeks(1)),
        MONTHLY("-yyyy.MM", d -> d.plusMonths(1));

        private final DateTimeFormatter formatter;
        private final Function<DateTime, DateTime> next;

        private Rollover(String format, Function<DateTime, DateTime> next) {
            this.formatter = DateTimeFormat.forPattern((String)format);
            this.next = next;
        }

        DateTimeFormatter formatter() {
            return this.formatter;
        }

        Function<DateTime, DateTime> getNext() {
            return this.next;
        }
    }
}

