/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

abstract class ApiKeyBaseRestHandler
extends SecurityBaseRestHandler {
    ApiKeyBaseRestHandler(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    @Override
    protected Exception checkFeatureAvailable(RestRequest request) {
        Exception failedFeature = super.checkFeatureAvailable(request);
        if (failedFeature != null) {
            return failedFeature;
        }
        if (this.licenseState.isApiKeyServiceAllowed()) {
            return null;
        }
        this.logger.info("API Keys are not available under the current [{}] license", (Object)this.licenseState.getOperationMode().description());
        return LicenseUtils.newComplianceException((String)"api keys");
    }
}

