/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.PutCalendarAction;
import org.elasticsearch.xpack.core.ml.action.UpdateCalendarJobAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportUpdateCalendarJobAction
extends HandledTransportAction<UpdateCalendarJobAction.Request, PutCalendarAction.Response> {
    private final JobResultsProvider jobResultsProvider;
    private final JobManager jobManager;

    @Inject
    public TransportUpdateCalendarJobAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobResultsProvider jobResultsProvider, JobManager jobManager) {
        super(settings, "cluster:admin/xpack/ml/calendars/jobs/update", threadPool, transportService, actionFilters, indexNameExpressionResolver, UpdateCalendarJobAction.Request::new);
        this.jobResultsProvider = jobResultsProvider;
        this.jobManager = jobManager;
    }

    protected void doExecute(UpdateCalendarJobAction.Request request, ActionListener<PutCalendarAction.Response> listener) {
        Set jobIdsToAdd = Strings.tokenizeByCommaToSet((String)request.getJobIdsToAddExpression());
        Set jobIdsToRemove = Strings.tokenizeByCommaToSet((String)request.getJobIdsToRemoveExpression());
        this.jobResultsProvider.updateCalendar(request.getCalendarId(), jobIdsToAdd, jobIdsToRemove, c -> this.jobManager.updateProcessOnCalendarChanged(c.getJobIds(), (ActionListener<Boolean>)ActionListener.wrap(r -> listener.onResponse((Object)new PutCalendarAction.Response(c)), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
    }
}

