/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.DataDescription;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.categorization.CategorizationAnalyzer;
import org.elasticsearch.xpack.ml.job.process.DataCountsReporter;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.AbstractDataToProcessWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.XContentRecordReader;

class JsonDataToProcessWriter
extends AbstractDataToProcessWriter {
    private static final Logger LOGGER = LogManager.getLogger(JsonDataToProcessWriter.class);
    private NamedXContentRegistry xContentRegistry;

    JsonDataToProcessWriter(boolean includeControlField, boolean includeTokensField, AutodetectProcess autodetectProcess, DataDescription dataDescription, AnalysisConfig analysisConfig, DataCountsReporter dataCountsReporter, NamedXContentRegistry xContentRegistry) {
        super(includeControlField, includeTokensField, autodetectProcess, dataDescription, analysisConfig, dataCountsReporter, LOGGER);
        this.xContentRegistry = xContentRegistry;
    }

    @Override
    public void write(InputStream inputStream, CategorizationAnalyzer categorizationAnalyzer, XContentType xContentType, BiConsumer<DataCounts, Exception> handler) throws IOException {
        this.dataCountsReporter.startNewIncrementalCount();
        if (xContentType.equals((Object)XContentType.JSON)) {
            this.writeJsonXContent(categorizationAnalyzer, inputStream);
        } else if (xContentType.equals((Object)XContentType.SMILE)) {
            this.writeSmileXContent(categorizationAnalyzer, inputStream);
        } else {
            throw new RuntimeException("XContentType [" + xContentType + "] is not supported by JsonDataToProcessWriter");
        }
        this.dataCountsReporter.finishReporting((ActionListener<Boolean>)ActionListener.wrap(response -> handler.accept(this.dataCountsReporter.incrementalStats(), null), e -> handler.accept((DataCounts)null, (Exception)e)));
    }

    private void writeJsonXContent(CategorizationAnalyzer categorizationAnalyzer, InputStream inputStream) throws IOException {
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, inputStream);){
            this.writeJson(categorizationAnalyzer, parser);
        }
    }

    private void writeSmileXContent(CategorizationAnalyzer categorizationAnalyzer, InputStream inputStream) throws IOException {
        byte[] nextObject;
        while ((nextObject = this.findNextObject(XContentType.SMILE.xContent().streamSeparator(), inputStream)).length != 0) {
            XContentParser parser = XContentFactory.xContent((XContentType)XContentType.SMILE).createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, nextObject);
            try {
                this.writeJson(categorizationAnalyzer, parser);
            }
            finally {
                if (parser == null) continue;
                parser.close();
            }
        }
    }

    private byte[] findNextObject(byte marker, InputStream data) throws IOException {
        int nextByte;
        assert (data.markSupported());
        data.mark(-1);
        int counter = 0;
        do {
            nextByte = data.read();
            ++counter;
            if (nextByte != (marker & 0xFF)) continue;
            data.reset();
            byte[] buffer = new byte[counter];
            data.read(buffer);
            return buffer;
        } while (nextByte != -1);
        return new byte[0];
    }

    private void writeJson(CategorizationAnalyzer categorizationAnalyzer, XContentParser parser) throws IOException {
        Collection<String> inputFields = this.inputFields();
        this.buildFieldIndexMapping(inputFields.toArray(new String[0]));
        int numFields = this.outputFieldCount();
        String[] input = new String[numFields];
        Object[] record = new String[numFields];
        boolean[] gotFields = new boolean[inputFields.size()];
        XContentRecordReader recordReader = new XContentRecordReader(parser, this.inFieldIndexes, LOGGER);
        Integer categorizationFieldIndex = (Integer)this.inFieldIndexes.get(this.analysisConfig.getCategorizationFieldName());
        long inputFieldCount = recordReader.read(input, gotFields);
        while (inputFieldCount >= 0L) {
            Arrays.fill(record, "");
            inputFieldCount = Math.max(inputFieldCount - 1L, 0L);
            long missing = JsonDataToProcessWriter.missingFieldCount(gotFields);
            if (missing > 0L) {
                this.dataCountsReporter.reportMissingFields(missing);
            }
            for (AbstractDataToProcessWriter.InputOutputMap inOut : this.inputOutputMap) {
                String field = input[inOut.inputIndex];
                record[inOut.outputIndex] = field == null ? "" : field;
            }
            if (categorizationAnalyzer != null && categorizationFieldIndex != null) {
                this.tokenizeForCategorization(categorizationAnalyzer, input[categorizationFieldIndex], (String[])record);
            }
            this.transformTimeAndWrite((String[])record, inputFieldCount);
            inputFieldCount = recordReader.read(input, gotFields);
        }
    }

    @Override
    protected boolean checkForMissingFields(Collection<String> inputFields, Map<String, Integer> inputFieldIndexes, String[] header) {
        return true;
    }

    private static long missingFieldCount(boolean[] gotFieldFlags) {
        long count = 0L;
        for (boolean gotFieldFlag : gotFieldFlags) {
            if (gotFieldFlag) continue;
            ++count;
        }
        return count;
    }
}

