/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.results;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.output.FlushAcknowledgement;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.core.ml.job.results.Forecast;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.job.results.Influencer;
import org.elasticsearch.xpack.core.ml.job.results.ModelPlot;

public class AutodetectResult
implements ToXContentObject,
Writeable {
    public static final ParseField TYPE = new ParseField("autodetect_result", new String[0]);
    public static final ConstructingObjectParser<AutodetectResult, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), a -> new AutodetectResult((Bucket)a[0], (List)a[1], (List)a[2], (Quantiles)a[3], a[4] == null ? null : ((ModelSnapshot.Builder)a[4]).build(), a[5] == null ? null : ((ModelSizeStats.Builder)a[5]).build(), (ModelPlot)a[6], (Forecast)a[7], (ForecastRequestStats)a[8], (CategoryDefinition)a[9], (FlushAcknowledgement)a[10]));
    private final Bucket bucket;
    private final List<AnomalyRecord> records;
    private final List<Influencer> influencers;
    private final Quantiles quantiles;
    private final ModelSnapshot modelSnapshot;
    private final ModelSizeStats modelSizeStats;
    private final ModelPlot modelPlot;
    private final Forecast forecast;
    private final ForecastRequestStats forecastRequestStats;
    private final CategoryDefinition categoryDefinition;
    private final FlushAcknowledgement flushAcknowledgement;

    public AutodetectResult(Bucket bucket, List<AnomalyRecord> records, List<Influencer> influencers, Quantiles quantiles, ModelSnapshot modelSnapshot, ModelSizeStats modelSizeStats, ModelPlot modelPlot, Forecast forecast, ForecastRequestStats forecastRequestStats, CategoryDefinition categoryDefinition, FlushAcknowledgement flushAcknowledgement) {
        this.bucket = bucket;
        this.records = records;
        this.influencers = influencers;
        this.quantiles = quantiles;
        this.modelSnapshot = modelSnapshot;
        this.modelSizeStats = modelSizeStats;
        this.modelPlot = modelPlot;
        this.forecast = forecast;
        this.forecastRequestStats = forecastRequestStats;
        this.categoryDefinition = categoryDefinition;
        this.flushAcknowledgement = flushAcknowledgement;
    }

    public AutodetectResult(StreamInput in) throws IOException {
        this.bucket = in.readBoolean() ? new Bucket(in) : null;
        this.records = in.readBoolean() ? in.readList(AnomalyRecord::new) : null;
        this.influencers = in.readBoolean() ? in.readList(Influencer::new) : null;
        this.quantiles = in.readBoolean() ? new Quantiles(in) : null;
        this.modelSnapshot = in.readBoolean() ? new ModelSnapshot(in) : null;
        this.modelSizeStats = in.readBoolean() ? new ModelSizeStats(in) : null;
        this.modelPlot = in.readBoolean() ? new ModelPlot(in) : null;
        this.categoryDefinition = in.readBoolean() ? new CategoryDefinition(in) : null;
        this.flushAcknowledgement = in.readBoolean() ? new FlushAcknowledgement(in) : null;
        if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.forecast = in.readBoolean() ? new Forecast(in) : null;
            this.forecastRequestStats = in.readBoolean() ? new ForecastRequestStats(in) : null;
        } else {
            this.forecast = null;
            this.forecastRequestStats = null;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        AutodetectResult.writeNullable((Writeable)this.bucket, out);
        AutodetectResult.writeNullable(this.records, out);
        AutodetectResult.writeNullable(this.influencers, out);
        AutodetectResult.writeNullable((Writeable)this.quantiles, out);
        AutodetectResult.writeNullable((Writeable)this.modelSnapshot, out);
        AutodetectResult.writeNullable((Writeable)this.modelSizeStats, out);
        AutodetectResult.writeNullable((Writeable)this.modelPlot, out);
        AutodetectResult.writeNullable((Writeable)this.categoryDefinition, out);
        AutodetectResult.writeNullable((Writeable)this.flushAcknowledgement, out);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            AutodetectResult.writeNullable((Writeable)this.forecast, out);
            AutodetectResult.writeNullable((Writeable)this.forecastRequestStats, out);
        }
    }

    private static void writeNullable(Writeable writeable, StreamOutput out) throws IOException {
        boolean isPresent = writeable != null;
        out.writeBoolean(isPresent);
        if (isPresent) {
            writeable.writeTo(out);
        }
    }

    private static void writeNullable(List<? extends Writeable> writeables, StreamOutput out) throws IOException {
        boolean isPresent = writeables != null;
        out.writeBoolean(isPresent);
        if (isPresent) {
            out.writeList(writeables);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        AutodetectResult.addNullableField(Bucket.RESULT_TYPE_FIELD, (ToXContent)this.bucket, builder);
        AutodetectResult.addNullableField(AnomalyRecord.RESULTS_FIELD, this.records, builder);
        AutodetectResult.addNullableField(Influencer.RESULTS_FIELD, this.influencers, builder);
        AutodetectResult.addNullableField(Quantiles.TYPE, (ToXContent)this.quantiles, builder);
        AutodetectResult.addNullableField(ModelSnapshot.TYPE, (ToXContent)this.modelSnapshot, builder);
        AutodetectResult.addNullableField(ModelSizeStats.RESULT_TYPE_FIELD, (ToXContent)this.modelSizeStats, builder);
        AutodetectResult.addNullableField(ModelPlot.RESULTS_FIELD, (ToXContent)this.modelPlot, builder);
        AutodetectResult.addNullableField(Forecast.RESULTS_FIELD, (ToXContent)this.forecast, builder);
        AutodetectResult.addNullableField(ForecastRequestStats.RESULTS_FIELD, (ToXContent)this.forecastRequestStats, builder);
        AutodetectResult.addNullableField(CategoryDefinition.TYPE, (ToXContent)this.categoryDefinition, builder);
        AutodetectResult.addNullableField(FlushAcknowledgement.TYPE, (ToXContent)this.flushAcknowledgement, builder);
        builder.endObject();
        return builder;
    }

    private static void addNullableField(ParseField field, ToXContent value, XContentBuilder builder) throws IOException {
        if (value != null) {
            builder.field(field.getPreferredName(), value);
        }
    }

    private static void addNullableField(ParseField field, List<? extends ToXContent> values, XContentBuilder builder) throws IOException {
        if (values != null) {
            builder.field(field.getPreferredName(), values);
        }
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public List<AnomalyRecord> getRecords() {
        return this.records;
    }

    public List<Influencer> getInfluencers() {
        return this.influencers;
    }

    public Quantiles getQuantiles() {
        return this.quantiles;
    }

    public ModelSnapshot getModelSnapshot() {
        return this.modelSnapshot;
    }

    public ModelSizeStats getModelSizeStats() {
        return this.modelSizeStats;
    }

    public ModelPlot getModelPlot() {
        return this.modelPlot;
    }

    public Forecast getForecast() {
        return this.forecast;
    }

    public ForecastRequestStats getForecastRequestStats() {
        return this.forecastRequestStats;
    }

    public CategoryDefinition getCategoryDefinition() {
        return this.categoryDefinition;
    }

    public FlushAcknowledgement getFlushAcknowledgement() {
        return this.flushAcknowledgement;
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.records, this.influencers, this.categoryDefinition, this.flushAcknowledgement, this.modelPlot, this.forecast, this.forecastRequestStats, this.modelSizeStats, this.modelSnapshot, this.quantiles);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutodetectResult other = (AutodetectResult)obj;
        return Objects.equals(this.bucket, other.bucket) && Objects.equals(this.records, other.records) && Objects.equals(this.influencers, other.influencers) && Objects.equals(this.categoryDefinition, other.categoryDefinition) && Objects.equals(this.flushAcknowledgement, other.flushAcknowledgement) && Objects.equals(this.modelPlot, other.modelPlot) && Objects.equals(this.forecast, other.forecast) && Objects.equals(this.forecastRequestStats, other.forecastRequestStats) && Objects.equals(this.modelSizeStats, other.modelSizeStats) && Objects.equals(this.modelSnapshot, other.modelSnapshot) && Objects.equals(this.quantiles, other.quantiles);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)Bucket.STRICT_PARSER, Bucket.RESULT_TYPE_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)AnomalyRecord.STRICT_PARSER, AnomalyRecord.RESULTS_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)Influencer.LENIENT_PARSER, Influencer.RESULTS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)Quantiles.STRICT_PARSER, Quantiles.TYPE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)ModelSnapshot.STRICT_PARSER, ModelSnapshot.TYPE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)ModelSizeStats.STRICT_PARSER, ModelSizeStats.RESULT_TYPE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)ModelPlot.STRICT_PARSER, ModelPlot.RESULTS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)Forecast.STRICT_PARSER, Forecast.RESULTS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)ForecastRequestStats.STRICT_PARSER, ForecastRequestStats.RESULTS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)CategoryDefinition.STRICT_PARSER, CategoryDefinition.TYPE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)FlushAcknowledgement.PARSER, FlushAcknowledgement.TYPE);
    }
}

