/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskListener;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestDeleteJobAction
extends BaseRestHandler {
    public RestDeleteJobAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.DELETE, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.DELETE, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}", (RestHandler)this);
    }

    public String getName() {
        return "xpack_ml_delete_job_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        DeleteJobAction.Request deleteJobRequest = new DeleteJobAction.Request(restRequest.param(Job.ID.getPreferredName()));
        deleteJobRequest.setForce(restRequest.paramAsBoolean(CloseJobAction.Request.FORCE.getPreferredName(), deleteJobRequest.isForce()));
        deleteJobRequest.timeout(restRequest.paramAsTime("timeout", deleteJobRequest.timeout()));
        deleteJobRequest.masterNodeTimeout(restRequest.paramAsTime("master_timeout", deleteJobRequest.masterNodeTimeout()));
        if (restRequest.paramAsBoolean("wait_for_completion", true)) {
            return channel -> client.execute((Action)DeleteJobAction.INSTANCE, (ActionRequest)deleteJobRequest, (ActionListener)new RestToXContentListener(channel));
        }
        deleteJobRequest.setShouldStoreResult(true);
        Task task = client.executeLocally((GenericAction)DeleteJobAction.INSTANCE, (ActionRequest)deleteJobRequest, RestDeleteJobAction.nullTaskListener());
        return channel -> {
            try (XContentBuilder builder = channel.newBuilder();){
                builder.startObject();
                builder.field("task", client.getLocalNodeId() + ":" + task.getId());
                builder.endObject();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }
        };
    }

    private static TaskListener nullTaskListener() {
        return new TaskListener(){

            public void onResponse(Task task, Object o) {
            }

            public void onFailure(Task task, Throwable e) {
            }
        };
    }
}

