/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.Collections;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class TopHits
extends AggregateFunction {
    TopHits(Source source, Expression field, Expression sortField) {
        super(source, field, sortField != null ? Collections.singletonList(sortField) : Collections.emptyList());
    }

    public Expression orderField() {
        return this.parameters().isEmpty() ? null : this.parameters().get(0);
    }

    @Override
    public DataType dataType() {
        return this.field().dataType();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = TypeResolutions.isNotFoldable(this.field(), this.sourceText(), Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isExact(this.field(), this.sourceText(), Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.orderField() != null) {
            resolution = TypeResolutions.isNotFoldable(this.orderField(), this.sourceText(), Expressions.ParamOrdinal.SECOND);
            if (resolution.unresolved()) {
                return resolution;
            }
            resolution = TypeResolutions.isExact(this.orderField(), this.sourceText(), Expressions.ParamOrdinal.SECOND);
            if (resolution.unresolved()) {
                return resolution;
            }
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }
}

