/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeProcessor;

public class NonIsoDateTimeProcessor
extends BaseDateTimeProcessor {
    public static final String NAME = "nidt";
    private final NonIsoDateTimeExtractor extractor;

    public NonIsoDateTimeProcessor(NonIsoDateTimeExtractor extractor, ZoneId zoneId) {
        super(zoneId);
        this.extractor = extractor;
    }

    public NonIsoDateTimeProcessor(StreamInput in) throws IOException {
        super(in);
        this.extractor = (NonIsoDateTimeExtractor)in.readEnum(NonIsoDateTimeExtractor.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum((Enum)this.extractor);
    }

    public String getWriteableName() {
        return NAME;
    }

    NonIsoDateTimeExtractor extractor() {
        return this.extractor;
    }

    @Override
    public Object doProcess(ZonedDateTime dateTime) {
        return this.extractor.extract(dateTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.extractor, this.zoneId()});
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        NonIsoDateTimeProcessor other = (NonIsoDateTimeProcessor)obj;
        return Objects.equals((Object)this.extractor, (Object)other.extractor) && Objects.equals(this.zoneId(), other.zoneId());
    }

    public String toString() {
        return this.extractor.toString();
    }

    public static enum NonIsoDateTimeExtractor {
        DAY_OF_WEEK(zdt -> {
            int dayOfWeek = zdt.get(ChronoField.DAY_OF_WEEK) + 1;
            return dayOfWeek == 8 ? 1 : dayOfWeek;
        }),
        WEEK_OF_YEAR(zdt -> {
            LocalDateTime ld = zdt.toLocalDateTime();
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(zdt.getZone()), Locale.ROOT);
            cal.clear();
            cal.set(ld.get(ChronoField.YEAR), ld.get(ChronoField.MONTH_OF_YEAR) - 1, ld.get(ChronoField.DAY_OF_MONTH), ld.get(ChronoField.HOUR_OF_DAY), ld.get(ChronoField.MINUTE_OF_HOUR), ld.get(ChronoField.SECOND_OF_MINUTE));
            return cal.get(3);
        });

        private final Function<ZonedDateTime, Integer> apply;

        private NonIsoDateTimeExtractor(Function<ZonedDateTime, Integer> apply) {
            this.apply = apply;
        }

        public final Integer extract(ZonedDateTime dateTime) {
            return this.apply.apply(dateTime);
        }

        public final Integer extract(ZonedDateTime millis, String tzId) {
            return this.apply.apply(millis.withZoneSameInstant(ZoneId.of(tzId)));
        }
    }
}

