/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.execution.search.SqlSourceBuilder;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryOptionalMathProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public class BinaryOptionalMathPipe
extends Pipe {
    private final Pipe left;
    private final Pipe right;
    private final BinaryOptionalMathProcessor.BinaryOptionalMathOperation operation;

    public BinaryOptionalMathPipe(Source source, Expression expression, Pipe left, Pipe right, BinaryOptionalMathProcessor.BinaryOptionalMathOperation operation) {
        super(source, expression, right == null ? Arrays.asList(left) : Arrays.asList(left, right));
        this.left = left;
        this.right = right;
        this.operation = operation;
    }

    @Override
    public final Pipe replaceChildren(List<Pipe> newChildren) {
        int childrenSize = newChildren.size();
        if (childrenSize > 2 || childrenSize < 1) {
            throw new IllegalArgumentException("expected [1 or 2] children but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren.get(0), childrenSize == 1 ? null : newChildren.get(1));
    }

    @Override
    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newRight;
        Pipe newLeft = this.left.resolveAttributes(resolver);
        Pipe pipe = newRight = this.right == null ? this.right : this.right.resolveAttributes(resolver);
        if (newLeft == this.left && newRight == this.right) {
            return this;
        }
        return this.replaceChildren(newLeft, newRight);
    }

    @Override
    public boolean supportedByAggsOnlyQuery() {
        return this.right == null ? this.left.supportedByAggsOnlyQuery() : this.left.supportedByAggsOnlyQuery() || this.right.supportedByAggsOnlyQuery();
    }

    @Override
    public boolean resolved() {
        return this.left.resolved() && (this.right == null || this.right.resolved());
    }

    protected Pipe replaceChildren(Pipe newLeft, Pipe newRight) {
        return new BinaryOptionalMathPipe(this.source(), this.expression(), newLeft, newRight, this.operation);
    }

    @Override
    public final void collectFields(SqlSourceBuilder sourceBuilder) {
        this.left.collectFields(sourceBuilder);
        if (this.right != null) {
            this.right.collectFields(sourceBuilder);
        }
    }

    @Override
    protected NodeInfo<BinaryOptionalMathPipe> info() {
        return NodeInfo.create(this, BinaryOptionalMathPipe::new, this.expression(), this.left, this.right, this.operation);
    }

    @Override
    public BinaryOptionalMathProcessor asProcessor() {
        return new BinaryOptionalMathProcessor(this.left.asProcessor(), this.right == null ? null : this.right.asProcessor(), this.operation);
    }

    public Pipe right() {
        return this.right;
    }

    public Pipe left() {
        return this.left;
    }

    public BinaryOptionalMathProcessor.BinaryOptionalMathOperation operation() {
        return this.operation;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.right, this.operation);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryOptionalMathPipe other = (BinaryOptionalMathPipe)obj;
        return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right) && Objects.equals(this.operation, other.operation);
    }
}

