/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.InsertFunctionPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.InsertFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class Insert
extends ScalarFunction {
    private final Expression source;
    private final Expression start;
    private final Expression length;
    private final Expression replacement;

    public Insert(Source source, Expression src, Expression start, Expression length, Expression replacement) {
        super(source, Arrays.asList(src, start, length, replacement));
        this.source = src;
        this.start = start;
        this.length = length;
        this.replacement = replacement;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution sourceResolution = TypeResolutions.isStringAndExact(this.source, this.sourceText(), Expressions.ParamOrdinal.FIRST);
        if (sourceResolution.unresolved()) {
            return sourceResolution;
        }
        Expression.TypeResolution startResolution = TypeResolutions.isNumeric(this.start, this.sourceText(), Expressions.ParamOrdinal.SECOND);
        if (startResolution.unresolved()) {
            return startResolution;
        }
        Expression.TypeResolution lengthResolution = TypeResolutions.isNumeric(this.length, this.sourceText(), Expressions.ParamOrdinal.THIRD);
        if (lengthResolution.unresolved()) {
            return lengthResolution;
        }
        return TypeResolutions.isStringAndExact(this.replacement, this.sourceText(), Expressions.ParamOrdinal.FOURTH);
    }

    @Override
    public boolean foldable() {
        return this.source.foldable() && this.start.foldable() && this.length.foldable() && this.replacement.foldable();
    }

    @Override
    public Object fold() {
        return InsertFunctionProcessor.doProcess(this.source.fold(), this.start.fold(), this.length.fold(), this.replacement.fold());
    }

    @Override
    protected Pipe makePipe() {
        return new InsertFunctionPipe(this.source(), this, Expressions.pipe(this.source), Expressions.pipe(this.start), Expressions.pipe(this.length), Expressions.pipe(this.replacement));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Insert::new, this.source, this.start, this.length, this.replacement);
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate sourceScript = this.asScript(this.source);
        ScriptTemplate startScript = this.asScript(this.start);
        ScriptTemplate lengthScript = this.asScript(this.length);
        ScriptTemplate replacementScript = this.asScript(this.replacement);
        return this.asScriptFrom(sourceScript, startScript, lengthScript, replacementScript);
    }

    private ScriptTemplate asScriptFrom(ScriptTemplate sourceScript, ScriptTemplate startScript, ScriptTemplate lengthScript, ScriptTemplate replacementScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{sql}.%s(%s,%s,%s,%s)"), "insert", sourceScript.template(), startScript.template(), lengthScript.template(), replacementScript.template()), ParamsBuilder.paramsBuilder().script(sourceScript.params()).script(startScript.params()).script(lengthScript.params()).script(replacementScript.params()).build(), this.dataType());
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.exactAttribute().name()).build(), this.dataType());
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 4) {
            throw new IllegalArgumentException("expected [4] children but received [" + newChildren.size() + "]");
        }
        return new Insert(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }
}

